/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.AnalyzerPreHeater;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Analyzer;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.analyze.MatcherList;
import nl.basjes.parse.useragent.analyze.UselessMatcherException;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.calculate.CalculateAgentClass;
import nl.basjes.parse.useragent.calculate.CalculateAgentEmail;
import nl.basjes.parse.useragent.calculate.CalculateAgentName;
import nl.basjes.parse.useragent.calculate.CalculateDeviceBrand;
import nl.basjes.parse.useragent.calculate.CalculateDeviceName;
import nl.basjes.parse.useragent.calculate.CalculateNetworkType;
import nl.basjes.parse.useragent.calculate.ConcatNONDuplicatedCalculator;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.calculate.MajorVersionCalculator;
import nl.basjes.parse.useragent.config.AnalyzerConfig;
import nl.basjes.parse.useragent.config.ConfigLoader;
import nl.basjes.parse.useragent.config.MatcherConfig;
import nl.basjes.parse.useragent.config.TestCase;
import nl.basjes.parse.useragent.parse.UserAgentTreeFlattener;
import nl.basjes.parse.useragent.utils.CheckLoggingDependencies;
import nl.basjes.parse.useragent.utils.KryoConfig;
import nl.basjes.parse.useragent.utils.YauaaVersion;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@DefaultSerializer(value=KryoSerializer.class)
public abstract class AbstractUserAgentAnalyzerDirect
implements Analyzer,
AnalyzerPreHeater,
Serializable {
    private static final int INFORM_ACTIONS_HASHMAP_CAPACITY = 1000000;
    private static final Logger LOG = LogManager.getLogger(AbstractUserAgentAnalyzerDirect.class);
    private final ArrayList<Matcher> allMatchers = new ArrayList(5000);
    private final ArrayList<Matcher> zeroInputMatchers = new ArrayList(100);
    private final Map<String, Set<MatcherAction>> informMatcherActions = new LinkedHashMap<String, Set<MatcherAction>>(1000000);
    private boolean showMatcherStats = false;
    protected Set<String> wantedFieldNames = null;
    private List<TestCase> testCases = new ArrayList<TestCase>();
    private Map<String, Map<String, String>> lookups;
    private Map<String, Set<String>> lookupSets;
    protected UserAgentTreeFlattener flattener;
    public static final int DEFAULT_USER_AGENT_MAX_LENGTH = 2048;
    private int userAgentMaxLength = 2048;
    private boolean loadTests = false;
    private AnalyzerConfig config = null;
    private boolean delayInitialization = true;
    private boolean matchersHaveBeenInitialized = false;
    private volatile transient Set<String> allPossibleFieldNamesCache = null;
    private volatile transient List<String> allPossibleFieldNamesSortedCache = null;
    private final Map<String, Set<WordRangeVisitor.Range>> informMatcherActionRanges = new HashMap<String, Set<WordRangeVisitor.Range>>(10000);
    public static final int MAX_PREFIX_HASH_MATCH = 3;
    private final Map<String, Set<Integer>> informMatcherActionPrefixesLengths = new HashMap<String, Set<Integer>>(1000);
    private boolean verbose = false;
    private transient MatcherList touchedMatchers = null;
    private static final List<String> CORE_SYSTEM_GENERATED_FIELDS = new ArrayList<String>();
    private final List<FieldCalculator> fieldCalculators = new ArrayList<FieldCalculator>();

    protected List<Matcher> getAllMatchers() {
        return this.allMatchers;
    }

    protected MatcherList getTouchedMatchers() {
        return this.touchedMatchers;
    }

    @Override
    public List<TestCase> getTestCases() {
        return this.testCases;
    }

    @Override
    public Map<String, Map<String, String>> getLookups() {
        return this.lookups;
    }

    @Override
    public Map<String, Set<String>> getLookupSets() {
        return this.lookupSets;
    }

    void addAnalyzerConfig(AnalyzerConfig analyzerConfig) {
        if (this.config == null) {
            this.config = analyzerConfig;
        } else {
            this.config.merge(analyzerConfig);
        }
        this.testCases = this.config.getTestCases();
        this.lookups = this.config.getLookups();
        this.lookupSets = this.config.getLookupSets();
    }

    void initTransientFields() {
        this.touchedMatchers = new MatcherList(32);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.initTransientFields();
        stream.defaultReadObject();
        this.showDeserializationStats();
    }

    public static void configureKryo(Object kryo) {
        KryoConfig.configureKryo((Kryo)kryo);
    }

    private void showDeserializationStats() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("This Analyzer instance was deserialized.");
        lines.add("");
        lines.add("Lookups      : " + (this.lookups == null ? 0 : this.lookups.size()));
        lines.add("LookupSets   : " + this.lookupSets.size());
        lines.add("Matchers     : " + this.allMatchers.size());
        lines.add("Hashmap size : " + this.informMatcherActions.size());
        lines.add("Ranges map   : " + this.informMatcherActionRanges.size());
        lines.add("Testcases    : " + this.testCases.size());
        YauaaVersion.logVersion(lines);
    }

    protected AbstractUserAgentAnalyzerDirect() {
    }

    void delayInitialization() {
        this.delayInitialization = true;
    }

    void immediateInitialization() {
        this.delayInitialization = false;
    }

    void setShowMatcherStats(boolean newShowMatcherStats) {
        this.showMatcherStats = newShowMatcherStats;
    }

    public boolean getShowMatcherStats() {
        return this.showMatcherStats;
    }

    public void dropTests() {
        this.loadTests = false;
        this.testCases.clear();
    }

    public void keepTests() {
        this.loadTests = true;
    }

    public boolean willKeepTests() {
        return this.loadTests;
    }

    public long getNumberOfTestCases() {
        return this.testCases.size();
    }

    public synchronized void destroy() {
        this.allMatchers.forEach(Matcher::destroy);
        this.allMatchers.clear();
        this.allMatchers.trimToSize();
        this.zeroInputMatchers.forEach(Matcher::destroy);
        this.zeroInputMatchers.clear();
        this.zeroInputMatchers.trimToSize();
        this.informMatcherActions.clear();
        this.config = null;
        if (this.wantedFieldNames != null) {
            this.wantedFieldNames.clear();
        }
        this.testCases = Collections.emptyList();
        this.lookups = Collections.emptyMap();
        this.lookupSets = Collections.emptyMap();
        this.flattener.clear();
        this.invalidateCaches();
    }

    private void invalidateCaches() {
        this.allPossibleFieldNamesCache = null;
        this.allPossibleFieldNamesSortedCache = null;
    }

    public void loadResources(String resourceString) {
        this.loadResources(resourceString, this.showMatcherStats, false);
    }

    public void loadResources(String resourceString, boolean showLoadMessages, boolean optionalResources) {
        if (this.matchersHaveBeenInitialized) {
            throw new IllegalStateException("Refusing to load additional resources after the datastructures have been initialized.");
        }
        AnalyzerConfig extraConfig = new ConfigLoader(showLoadMessages).addResource(resourceString, optionalResources).load();
        this.addAnalyzerConfig(extraConfig);
        this.invalidateCaches();
        this.finalizeLoadingRules();
    }

    protected void finalizeLoadingRules() {
        YauaaVersion.logVersion(new String[0]);
        this.flattener = new UserAgentTreeFlattener(this);
        if (this.wantedFieldNames != null) {
            int wantedSize = this.wantedFieldNames.size();
            if (this.wantedFieldNames.contains("__Set_ALL_Fields__")) {
                --wantedSize;
            }
            LOG.info("Building all needed matchers for the requested {} fields.", (Object)wantedSize);
        } else {
            LOG.info("Building all matchers for all possible fields.");
        }
        Map<String, MatcherConfig> matcherConfigs = this.config.getMatcherConfigs();
        if (matcherConfigs.isEmpty()) {
            throw new InvalidParserConfigurationException("No matchers were loaded at all.");
        }
        this.allMatchers.clear();
        for (Map.Entry<String, MatcherConfig> matcherConfigEntry : matcherConfigs.entrySet()) {
            MatcherConfig matcherConfig = matcherConfigEntry.getValue();
            try {
                this.allMatchers.add(new Matcher(this, this.wantedFieldNames, matcherConfig));
            }
            catch (UselessMatcherException uselessMatcherException) {}
        }
        this.verifyWeAreNotAskingForImpossibleFields();
        if (!this.delayInitialization) {
            this.initializeMatchers();
        }
    }

    private void verifyWeAreNotAskingForImpossibleFields() {
        if (this.wantedFieldNames == null) {
            return;
        }
        ArrayList<String> impossibleFields = new ArrayList<String>();
        List<String> allPossibleFields = this.getAllPossibleFieldNamesSorted();
        for (String wantedFieldName : this.wantedFieldNames) {
            if (UserAgent.MutableUserAgent.isSystemField(wantedFieldName) || allPossibleFields.contains(wantedFieldName)) continue;
            impossibleFields.add(wantedFieldName);
        }
        if (impossibleFields.isEmpty()) {
            return;
        }
        throw new InvalidParserConfigurationException("We cannot provide these fields:" + impossibleFields);
    }

    public synchronized void initializeMatchers() {
        if (this.matchersHaveBeenInitialized) {
            return;
        }
        LOG.info("Initializing Analyzer data structures");
        if (this.allMatchers.isEmpty()) {
            throw new InvalidParserConfigurationException("No matchers were loaded at all.");
        }
        long start = System.nanoTime();
        this.allMatchers.forEach(Matcher::initialize);
        long stop = System.nanoTime();
        this.matchersHaveBeenInitialized = true;
        LOG.info("Built in {} msec : Hashmap {}, Ranges map:{}", (Object)((stop - start) / 1000000L), (Object)this.informMatcherActions.size(), (Object)this.informMatcherActionRanges.size());
        for (Matcher matcher : this.allMatchers) {
            if (matcher.getActionsThatRequireInput() != 0L) continue;
            this.zeroInputMatchers.add(matcher);
        }
        for (Matcher matcher : this.allMatchers) {
            matcher.reset();
        }
        this.touchedMatchers = new MatcherList(32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllPossibleFieldNames() {
        if (this.allPossibleFieldNamesCache == null) {
            AbstractUserAgentAnalyzerDirect abstractUserAgentAnalyzerDirect = this;
            synchronized (abstractUserAgentAnalyzerDirect) {
                if (this.allPossibleFieldNamesCache == null) {
                    TreeSet<String> names = new TreeSet<String>(CORE_SYSTEM_GENERATED_FIELDS);
                    if (this.wantedFieldNames == null) {
                        for (Matcher matcher : this.allMatchers) {
                            names.addAll(matcher.getAllPossibleFieldNames());
                        }
                        for (FieldCalculator calculator : this.fieldCalculators) {
                            names.add(calculator.getCalculatedFieldName());
                        }
                    } else {
                        for (Matcher matcher : this.allMatchers) {
                            for (String possibleFieldName : matcher.getAllPossibleFieldNames()) {
                                if (!this.wantedFieldNames.contains(possibleFieldName)) continue;
                                names.add(possibleFieldName);
                            }
                        }
                        for (FieldCalculator calculator : this.fieldCalculators) {
                            String possibleFieldName = calculator.getCalculatedFieldName();
                            if (!this.wantedFieldNames.contains(possibleFieldName)) continue;
                            names.add(possibleFieldName);
                        }
                        names.remove("__Set_ALL_Fields__");
                    }
                    this.allPossibleFieldNamesCache = names;
                }
            }
        }
        return this.allPossibleFieldNamesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllPossibleFieldNamesSorted() {
        if (this.allPossibleFieldNamesSortedCache == null) {
            AbstractUserAgentAnalyzerDirect abstractUserAgentAnalyzerDirect = this;
            synchronized (abstractUserAgentAnalyzerDirect) {
                if (this.allPossibleFieldNamesSortedCache == null) {
                    ArrayList<String> fieldNames = new ArrayList<String>(this.getAllPossibleFieldNames());
                    Collections.sort(fieldNames);
                    ArrayList<String> names = new ArrayList<String>();
                    for (String fieldName : UserAgent.PRE_SORTED_FIELDS_LIST) {
                        fieldNames.remove(fieldName);
                        names.add(fieldName);
                    }
                    names.addAll(fieldNames);
                    this.allPossibleFieldNamesSortedCache = names;
                }
            }
        }
        return this.allPossibleFieldNamesSortedCache;
    }

    @Override
    public void lookingForRange(String treeName, WordRangeVisitor.Range range) {
        Set ranges = this.informMatcherActionRanges.computeIfAbsent(treeName, k -> new LinkedHashSet(4));
        ranges.add(range);
    }

    public static int firstCharactersForPrefixHashLength(String input, int maxChars) {
        return Math.min(maxChars, Math.min(3, input.length()));
    }

    public static String firstCharactersForPrefixHash(String input, int maxChars) {
        return input.substring(0, AbstractUserAgentAnalyzerDirect.firstCharactersForPrefixHashLength(input, maxChars));
    }

    @Override
    public void informMeAboutPrefix(MatcherAction matcherAction, String treeName, String prefix) {
        this.informMeAbout(matcherAction, treeName + "{\"" + AbstractUserAgentAnalyzerDirect.firstCharactersForPrefixHash(prefix, 3) + "\"");
        Set lengths = this.informMatcherActionPrefixesLengths.computeIfAbsent(treeName, k -> new LinkedHashSet(4));
        lengths.add(AbstractUserAgentAnalyzerDirect.firstCharactersForPrefixHashLength(prefix, 3));
    }

    @Override
    public Set<Integer> getRequiredPrefixLengths(String treeName) {
        return this.informMatcherActionPrefixesLengths.get(treeName);
    }

    @Override
    public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        String hashKey = keyPattern.toLowerCase(Locale.ROOT);
        Set analyzerSet = this.informMatcherActions.computeIfAbsent(hashKey, k -> new LinkedHashSet());
        analyzerSet.add(matcherAction);
    }

    public synchronized void setVerbose(boolean newVerbose) {
        this.verbose = newVerbose;
        this.flattener.setVerbose(newVerbose);
    }

    public void setUserAgentMaxLength(int newUserAgentMaxLength) {
        this.userAgentMaxLength = newUserAgentMaxLength <= 0 ? 2048 : newUserAgentMaxLength;
    }

    public int getUserAgentMaxLength() {
        return this.userAgentMaxLength;
    }

    private void setAsHacker(UserAgent.MutableUserAgent userAgent, int confidence) {
        userAgent.set("DeviceClass", "Hacker", confidence);
        userAgent.set("DeviceBrand", "Hacker", confidence);
        userAgent.set("DeviceName", "Hacker", confidence);
        userAgent.set("DeviceVersion", "Hacker", confidence);
        userAgent.set("OperatingSystemClass", "Hacker", confidence);
        userAgent.set("OperatingSystemName", "Hacker", confidence);
        userAgent.set("OperatingSystemVersion", "Hacker", confidence);
        userAgent.set("LayoutEngineClass", "Hacker", confidence);
        userAgent.set("LayoutEngineName", "Hacker", confidence);
        userAgent.set("LayoutEngineVersion", "Hacker", confidence);
        userAgent.set("LayoutEngineVersionMajor", "Hacker", confidence);
        userAgent.set("AgentClass", "Hacker", confidence);
        userAgent.set("AgentName", "Hacker", confidence);
        userAgent.set("AgentVersion", "Hacker", confidence);
        userAgent.set("AgentVersionMajor", "Hacker", confidence);
        userAgent.set("HackerToolkit", "Unknown", confidence);
        userAgent.set("HackerAttackVector", "Unknown", confidence);
    }

    @Override
    public void receivedInput(Matcher matcher) {
        if (this.zeroInputMatchers.contains(matcher)) {
            return;
        }
        this.touchedMatchers.add(matcher);
    }

    public synchronized void reset() {
        for (Matcher matcher : this.touchedMatchers) {
            matcher.reset();
        }
        this.touchedMatchers.clear();
        for (Matcher matcher : this.zeroInputMatchers) {
            matcher.reset();
        }
    }

    @Override
    public UserAgent.ImmutableUserAgent parse(String userAgentString) {
        UserAgent.MutableUserAgent userAgent = new UserAgent.MutableUserAgent(userAgentString, this.getAllPossibleFieldNames());
        return this.parse(userAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public UserAgent.ImmutableUserAgent parse(UserAgent.MutableUserAgent userAgent) {
        this.initializeMatchers();
        String useragentString = userAgent.getUserAgentString();
        if (useragentString != null && useragentString.length() > this.userAgentMaxLength) {
            this.setAsHacker(userAgent, 100);
            userAgent.setForced("HackerAttackVector", "Buffer overflow", 100L);
            return new UserAgent.ImmutableUserAgent(this.hardCodedPostProcessing(userAgent));
        }
        AbstractUserAgentAnalyzerDirect abstractUserAgentAnalyzerDirect = this;
        synchronized (abstractUserAgentAnalyzerDirect) {
            this.reset();
            if (userAgent.isDebug()) {
                for (Matcher matcher : this.allMatchers) {
                    matcher.setVerboseTemporarily(true);
                }
            }
            try {
                userAgent = this.flattener.parse(userAgent);
                this.inform("__SyntaxError__", userAgent.getValue("__SyntaxError__"), null);
                if (this.verbose) {
                    LOG.info("=========== Checking all Touched Matchers: {}", (Object)this.touchedMatchers.size());
                }
                for (Matcher matcher : this.touchedMatchers) {
                    matcher.analyze(userAgent);
                }
                if (this.verbose) {
                    LOG.info("=========== Checking all Zero Input Matchers: {}", (Object)this.zeroInputMatchers.size());
                }
                for (Matcher matcher : this.zeroInputMatchers) {
                    matcher.analyze(userAgent);
                }
                userAgent.processSetAll();
            }
            catch (RuntimeException rte) {
                userAgent.reset();
                this.setAsHacker(userAgent, 10000);
                userAgent.setForced("HackerAttackVector", "Yauaa Exploit", 10000L);
            }
        }
        return new UserAgent.ImmutableUserAgent(this.hardCodedPostProcessing(userAgent));
    }

    public boolean isWantedField(String fieldName) {
        if (this.wantedFieldNames == null) {
            return true;
        }
        return this.wantedFieldNames.contains(fieldName);
    }

    public Set<String> getWantedFieldNames() {
        return this.wantedFieldNames;
    }

    protected void setFieldCalculators(List<FieldCalculator> newFieldCalculators) {
        this.fieldCalculators.addAll(newFieldCalculators);
    }

    private UserAgent.MutableUserAgent hardCodedPostProcessing(UserAgent.MutableUserAgent userAgent) {
        if ("true".equals(userAgent.getValue("__SyntaxError__")) && userAgent.get("DeviceClass").getConfidence() == -1L) {
            this.setAsHacker(userAgent, 10);
        }
        for (FieldCalculator fieldCalculator : this.fieldCalculators) {
            if (this.verbose) {
                LOG.info("Running FieldCalculator: {}", (Object)fieldCalculator);
            }
            fieldCalculator.calculate(userAgent);
        }
        return userAgent;
    }

    @Override
    public Set<WordRangeVisitor.Range> getRequiredInformRanges(String treeName) {
        return this.informMatcherActionRanges.computeIfAbsent(treeName, k -> Collections.emptySet());
    }

    @Override
    public void inform(String key, String value, ParseTree ctx) {
        this.inform(key, key, value, ctx);
        this.inform(key + "=\"" + value + '\"', key, value, ctx);
        Set<Integer> lengths = this.getRequiredPrefixLengths(key);
        if (lengths != null) {
            int valueLength = value.length();
            for (Integer prefixLength : lengths) {
                if (valueLength < prefixLength) continue;
                this.inform(key + "{\"" + AbstractUserAgentAnalyzerDirect.firstCharactersForPrefixHash(value, prefixLength) + '\"', key, value, ctx);
            }
        }
    }

    private void inform(String match, String key, String value, ParseTree ctx) {
        Set<MatcherAction> relevantActions = this.informMatcherActions.get(match.toLowerCase(Locale.ROOT));
        if (this.verbose) {
            if (relevantActions == null) {
                LOG.info("--- Have (0): {}", (Object)match);
            } else {
                LOG.info("+++ Have ({}): {}", (Object)relevantActions.size(), (Object)match);
                int count = 1;
                for (MatcherAction action : relevantActions) {
                    LOG.info("+++ -------> ({}): {}", (Object)count, (Object)action);
                    ++count;
                }
            }
        }
        if (relevantActions != null) {
            for (MatcherAction matcherAction : relevantActions) {
                matcherAction.inform(key, value, ctx);
            }
        }
    }

    public static List<String> getAllPaths(String agent) {
        return new GetAllPathsAnalyzer(agent).getValues();
    }

    public static GetAllPathsAnalyzer getAllPathsAnalyzer(String agent) {
        return new GetAllPathsAnalyzer(agent);
    }

    public String toString() {
        return "UserAgentAnalyzerDirect{\nallMatchers=" + this.allMatchers + "\n, zeroInputMatchers=" + this.zeroInputMatchers + "\n, informMatcherActions=" + this.informMatcherActions + "\n, showMatcherStats=" + this.showMatcherStats + "\n, wantedFieldNames=" + this.wantedFieldNames + "\n, testCases=" + this.testCases + "\n, lookups=" + this.lookups + "\n, lookupSets=" + this.lookupSets + "\n, flattener=" + this.flattener + "\n, userAgentMaxLength=" + this.userAgentMaxLength + "\n, loadTests=" + this.loadTests + "\n, delayInitialization=" + this.delayInitialization + "\n, matchersHaveBeenInitialized=" + this.matchersHaveBeenInitialized + "\n, verbose=" + this.verbose + "\n, fieldCalculators=" + this.fieldCalculators + "\n}";
    }

    static {
        CORE_SYSTEM_GENERATED_FIELDS.add("__SyntaxError__");
    }

    public static abstract class AbstractUserAgentAnalyzerDirectBuilder<UAA extends AbstractUserAgentAnalyzerDirect, B extends AbstractUserAgentAnalyzerDirectBuilder<UAA, B>> {
        private final UAA uaa;
        private boolean didBuildStep = false;
        private int preheatIterations = 0;
        private final List<String> resources = new ArrayList<String>();
        private final List<String> optionalResources = new ArrayList<String>();
        private final List<String> yamlRules = new ArrayList<String>();
        private final List<FieldCalculator> fieldCalculators = new ArrayList<FieldCalculator>();
        protected final Set<String> allFieldsForWhichACalculatorExists = new HashSet<String>();
        protected final Set<String> dependenciesNeededByCalculators = new HashSet<String>();

        protected void failIfAlreadyBuilt() {
            if (this.didBuildStep) {
                throw new IllegalStateException("A builder can provide only a single instance. It is not allowed to set values after doing build()");
            }
        }

        protected AbstractUserAgentAnalyzerDirectBuilder(UAA newUaa) {
            this.uaa = newUaa;
            ((AbstractUserAgentAnalyzerDirect)this.uaa).setShowMatcherStats(false);
            this.resources.add("classpath*:UserAgents/**/*.yaml");
        }

        public B dropDefaultResources() {
            this.failIfAlreadyBuilt();
            this.resources.remove("classpath*:UserAgents/**/*.yaml");
            return (B)this;
        }

        public B addResources(String resourceString) {
            this.failIfAlreadyBuilt();
            this.resources.add(resourceString);
            return (B)this;
        }

        public B addOptionalResources(String resourceString) {
            this.failIfAlreadyBuilt();
            this.optionalResources.add(resourceString);
            return (B)this;
        }

        public B addYamlRule(String yamlRule) {
            this.failIfAlreadyBuilt();
            this.yamlRules.add(yamlRule);
            return (B)this;
        }

        public B preheat(int iterations) {
            this.failIfAlreadyBuilt();
            this.preheatIterations = iterations;
            return (B)this;
        }

        public B preheat() {
            this.failIfAlreadyBuilt();
            this.preheatIterations = -1;
            return (B)this;
        }

        public B withField(String fieldName) {
            this.failIfAlreadyBuilt();
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames == null) {
                ((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames = new TreeSet<String>();
            }
            ((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames.add(fieldName);
            return (B)this;
        }

        public B withFields(Collection<String> fieldNames) {
            for (String fieldName : fieldNames) {
                this.withField(fieldName);
            }
            return (B)this;
        }

        public B withFields(String ... fieldNames) {
            for (String fieldName : fieldNames) {
                this.withField(fieldName);
            }
            return (B)this;
        }

        public B withAllFields() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames = null;
            return (B)this;
        }

        public B showMatcherLoadStats() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).setShowMatcherStats(true);
            return (B)this;
        }

        public B hideMatcherLoadStats() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).setShowMatcherStats(false);
            return (B)this;
        }

        public B withUserAgentMaxLength(int newUserAgentMaxLength) {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).setUserAgentMaxLength(newUserAgentMaxLength);
            return (B)this;
        }

        public B keepTests() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).keepTests();
            return (B)this;
        }

        public B dropTests() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).dropTests();
            return (B)this;
        }

        public B delayInitialization() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).delayInitialization();
            return (B)this;
        }

        public B immediateInitialization() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).immediateInitialization();
            return (B)this;
        }

        private void registerFieldCalculator(FieldCalculator fieldCalculator) {
            String calculatedFieldName = fieldCalculator.getCalculatedFieldName();
            this.allFieldsForWhichACalculatorExists.add(calculatedFieldName);
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).isWantedField(calculatedFieldName) || this.dependenciesNeededByCalculators.contains(calculatedFieldName)) {
                this.fieldCalculators.add(fieldCalculator);
                this.dependenciesNeededByCalculators.addAll(fieldCalculator.getDependencies());
            }
        }

        protected void verifyCalculatorDependencyOrdering() {
            HashSet<String> seenCalculatedFields = new HashSet<String>();
            for (FieldCalculator fieldCalculator : this.fieldCalculators) {
                for (String dependency : fieldCalculator.getDependencies()) {
                    if (!this.allFieldsForWhichACalculatorExists.contains(dependency) || seenCalculatedFields.contains(dependency)) continue;
                    throw new InvalidParserConfigurationException("Calculator ordering is wrong:For " + fieldCalculator.getCalculatedFieldName() + " we need " + dependency + " which is a calculated field but it has not yet been calculated.");
                }
                seenCalculatedFields.add(fieldCalculator.getCalculatedFieldName());
            }
        }

        public UAA build() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).initTransientFields();
            CheckLoggingDependencies.verifyLoggingDependencies();
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames != null) {
                ((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames.add("__Set_ALL_Fields__");
                ((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames.add("DeviceClass");
            }
            this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("AgentNameVersionMajor", "AgentName", "AgentVersionMajor"));
            this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("AgentNameVersion", "AgentName", "AgentVersion"));
            this.registerFieldCalculator(new MajorVersionCalculator("AgentVersionMajor", "AgentVersion"));
            this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("WebviewAppNameVersionMajor", "WebviewAppName", "WebviewAppVersionMajor"));
            this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("WebviewAppNameVersion", "WebviewAppName", "WebviewAppVersion"));
            this.registerFieldCalculator(new MajorVersionCalculator("WebviewAppVersionMajor", "WebviewAppVersion"));
            this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("LayoutEngineNameVersionMajor", "LayoutEngineName", "LayoutEngineVersionMajor"));
            this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("LayoutEngineNameVersion", "LayoutEngineName", "LayoutEngineVersion"));
            this.registerFieldCalculator(new MajorVersionCalculator("LayoutEngineVersionMajor", "LayoutEngineVersion"));
            this.registerFieldCalculator(new MajorVersionCalculator("OperatingSystemNameVersionMajor", "OperatingSystemNameVersion"));
            this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("OperatingSystemNameVersion", "OperatingSystemName", "OperatingSystemVersion"));
            this.registerFieldCalculator(new MajorVersionCalculator("OperatingSystemVersionMajor", "OperatingSystemVersion"));
            this.registerFieldCalculator(new CalculateAgentClass());
            this.registerFieldCalculator(new CalculateAgentName());
            this.registerFieldCalculator(new CalculateNetworkType());
            this.registerFieldCalculator(new CalculateDeviceName());
            this.registerFieldCalculator(new CalculateDeviceBrand());
            this.registerFieldCalculator(new CalculateAgentEmail());
            Collections.reverse(this.fieldCalculators);
            ((AbstractUserAgentAnalyzerDirect)this.uaa).setFieldCalculators(this.fieldCalculators);
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames != null) {
                ((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames.addAll(this.dependenciesNeededByCalculators);
            }
            boolean showLoading = ((AbstractUserAgentAnalyzerDirect)this.uaa).getShowMatcherStats();
            ConfigLoader configLoader = new ConfigLoader(showLoading).addResource(this.resources, false).addResource(this.optionalResources, true);
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).willKeepTests()) {
                configLoader.keepTests();
            } else {
                configLoader.dropTests();
            }
            int yamlRuleCount = 1;
            for (String yamlRule : this.yamlRules) {
                configLoader.addYaml(yamlRule, "Manually Inserted Rules " + yamlRuleCount++);
            }
            ((AbstractUserAgentAnalyzerDirect)this.uaa).addAnalyzerConfig(configLoader.load());
            ((AbstractUserAgentAnalyzerDirect)this.uaa).finalizeLoadingRules();
            if (this.preheatIterations < 0) {
                this.uaa.preHeat();
            } else if (this.preheatIterations > 0) {
                this.uaa.preHeat(this.preheatIterations);
            }
            this.didBuildStep = true;
            return this.uaa;
        }
    }

    public static class GetAllPathsAnalyzer
    implements Analyzer {
        private final List<String> values = new ArrayList<String>(128);
        private final UserAgent result;

        GetAllPathsAnalyzer(String useragent) {
            UserAgentTreeFlattener flattener = new UserAgentTreeFlattener(this);
            this.result = flattener.parse(useragent);
        }

        public List<String> getValues() {
            return this.values;
        }

        public UserAgent getResult() {
            return this.result;
        }

        @Override
        public void inform(String path, String value, ParseTree ctx) {
            this.values.add(path);
            this.values.add(path + "=\"" + value + "\"");
            this.values.add(path + "{\"" + AbstractUserAgentAnalyzerDirect.firstCharactersForPrefixHash(value, 3) + "\"");
        }

        @Override
        public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        }

        @Override
        public void lookingForRange(String treeName, WordRangeVisitor.Range range) {
        }

        @Override
        public Set<WordRangeVisitor.Range> getRequiredInformRanges(String treeName) {
            return Collections.emptySet();
        }

        @Override
        public void informMeAboutPrefix(MatcherAction matcherAction, String treeName, String prefix) {
        }

        @Override
        public Set<Integer> getRequiredPrefixLengths(String treeName) {
            return Collections.emptySet();
        }

        @Override
        public Map<String, Map<String, String>> getLookups() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, Set<String>> getLookupSets() {
            return Collections.emptyMap();
        }

        @Override
        public List<TestCase> getTestCases() {
            return Collections.emptyList();
        }
    }

    public static class KryoSerializer
    extends FieldSerializer<AbstractUserAgentAnalyzerDirect> {
        public KryoSerializer(Kryo kryo, Class<?> type) {
            super(kryo, type);
        }

        public void write(Kryo kryo, Output output, AbstractUserAgentAnalyzerDirect object) {
            object.reset();
            super.write(kryo, output, (Object)object);
        }

        public AbstractUserAgentAnalyzerDirect read(Kryo kryo, Input input, Class<? extends AbstractUserAgentAnalyzerDirect> type) {
            AbstractUserAgentAnalyzerDirect uaa = (AbstractUserAgentAnalyzerDirect)super.read(kryo, input, type);
            uaa.initTransientFields();
            uaa.showDeserializationStats();
            return uaa;
        }
    }
}

