/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.people.biz.impl;

import com.mingsoft.base.biz.impl.BaseBizImpl;
import com.mingsoft.base.dao.IBaseDao;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.people.biz.IPeopleBiz;
import com.mingsoft.people.dao.IPeopleDao;
import com.mingsoft.people.entity.PeopleEntity;
import com.mingsoft.util.PageUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="peopleBiz")
public class PeopleBizImpl
extends BaseBizImpl
implements IPeopleBiz {
    @Autowired
    private IPeopleDao peopleDao;

    protected IBaseDao getDao() {
        return this.peopleDao;
    }

    public int savePeople(PeopleEntity people) {
        this.peopleDao.saveEntity((BaseEntity)people);
        return this.saveEntity((BaseEntity)people);
    }

    public void updatePeople(PeopleEntity people) {
        this.peopleDao.updateEntity((BaseEntity)people);
        this.updateEntity((BaseEntity)people);
    }

    public void deletePeople(int id) {
        this.peopleDao.deleteEntity(id);
        this.deleteEntity(id);
    }

    public PeopleEntity getEntityByUserName(String userName, int appId) {
        return this.peopleDao.getEntityByUserName(userName, appId);
    }

    public List<PeopleEntity> queryPageListByAppId(int appId, PageUtil page) {
        return this.peopleDao.queryPageListByAppId(appId, page);
    }

    public int queryCountByAppId(int appId) {
        return this.peopleDao.getCount(Integer.valueOf(appId), null);
    }

    public PeopleEntity getEntityByCode(String userName, String peopleCode, int appId) {
        return this.peopleDao.getEntityByCode(userName, peopleCode, appId);
    }

    public int getCountByDate(String peopleDateTime, Integer appId) {
        HashMap<String, String> where = new HashMap<String, String>();
        where.put("peopleDateTime", peopleDateTime);
        return this.peopleDao.getCount(appId, where);
    }

    public void deletePeople(int[] peopleIds) {
        if (peopleIds == null) {
            return;
        }
        this.peopleDao.deletePeoples(peopleIds);
        this.delete(peopleIds);
    }

    public List<PeopleEntity> queryByAppIdAndMap(int appId, Map whereMap, PageUtil page) {
        return this.peopleDao.queryByAppIdAndMap(appId, whereMap, page);
    }

    public int getCountByAppIdAndMap(int appId, Map whereMap) {
        return this.peopleDao.getCountByAppIdAndMap(appId, whereMap);
    }

    public PeopleEntity getByPeople(PeopleEntity people, int appId) {
        return this.peopleDao.getByPeople(people, appId);
    }

    public PeopleEntity getEntityByMailOrPhone(String userName, int appId) {
        return this.peopleDao.getEntityByMailOrPhone(userName, appId);
    }

    public List<PeopleEntity> query(int appId, Map where) {
        return this.peopleDao.query(appId, where);
    }
}

