/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.people.action.people;

import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.people.action.BaseAction;
import com.mingsoft.people.biz.IPeopleBiz;
import com.mingsoft.people.biz.IPeopleUserBiz;
import com.mingsoft.people.constant.Const;
import com.mingsoft.people.constant.ModelCode;
import com.mingsoft.people.entity.PeopleEntity;
import com.mingsoft.people.entity.PeopleUserEntity;
import com.mingsoft.util.FileUtil;
import com.mingsoft.util.ImageUtil;
import com.mingsoft.util.StringUtil;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="webPeopleUser")
@RequestMapping(value={"/people/user"})
public class PeopleUserAction
extends BaseAction {
    @Autowired
    private IPeopleUserBiz peopleUserBiz;
    @Autowired
    private IPeopleBiz peopleBiz;

    @RequestMapping(value={"/info"})
    public void info(HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession(request);
        PeopleUserEntity peopleUser = (PeopleUserEntity)this.peopleUserBiz.getEntity(people.getPeopleId());
        if (peopleUser == null) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_USER, false);
            return;
        }
        this.outJson(response, (Object)peopleUser, new String[]{"peopleOldPassword", "peoplePassword"});
    }

    @RequestMapping(value={"/update"})
    public void update(@ModelAttribute PeopleUserEntity peopleUser, HttpServletRequest request, HttpServletResponse response) {
        if (peopleUser == null) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_USER, false, this.getResString("err.empty", new String[]{this.getResString("people")}));
            return;
        }
        peopleUser.setPeopleId(this.getPeopleBySession(request).getPeopleId());
        peopleUser.setPuPeopleId(Integer.valueOf(this.getPeopleBySession(request).getPeopleId()));
        PeopleUserEntity pue = (PeopleUserEntity)this.peopleUserBiz.getEntity(peopleUser.getPeopleId());
        if (pue.getPuPeopleId() == 0) {
            this.peopleUserBiz.saveEntity((BaseEntity)peopleUser);
        } else {
            this.peopleUserBiz.updatePeople((PeopleEntity)peopleUser);
        }
        this.outJson(response, (BaseEnum)ModelCode.PEOPLE_USER, true, this.getResString("success"));
    }

    @RequestMapping(value={"/saveUserIcon"})
    public void saveUserIcon(@ModelAttribute PeopleUserEntity peopleUser, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession(request);
        if (people == null) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_USER, false, this.getResString("people.session.msg.null.error", Const.RESOURCES));
            return;
        }
        if (peopleUser == null) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_USER, false, this.getResString("people.user.msg.null.error", Const.RESOURCES));
            return;
        }
        String imgPath = this.getUserIcon(people.getPeopleId(), peopleUser.getPuIcon().trim(), request);
        if (!StringUtil.isBlank((String)imgPath)) {
            peopleUser.setPuIcon(imgPath);
        }
        peopleUser.setPeopleAppId(people.getPeopleAppId());
        peopleUser.setPeopleId(people.getPeopleId());
        this.peopleUserBiz.saveEntity((BaseEntity)peopleUser);
        if (!StringUtil.isBlank((String)peopleUser.getPeopleMail())) {
            people.setPeopleMail(peopleUser.getPeopleMail());
        }
        if (!StringUtil.isBlank((String)peopleUser.getPeoplePhone())) {
            people.setPeoplePhone(peopleUser.getPeoplePhone());
        }
        this.peopleBiz.updateEntity((BaseEntity)people);
        this.outJson(response, (BaseEnum)ModelCode.PEOPLE_USER, true, this.getResString("people.user.save.msg.success", Const.RESOURCES));
    }

    @RequestMapping(value={"/updateUserIcon"})
    public void updateUserIcon(@ModelAttribute PeopleUserEntity peopleUser, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession(request);
        if (people == null) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_USER, false, this.getResString("people.session.msg.null.error", Const.RESOURCES));
            return;
        }
        PeopleUserEntity oldPeopleUser = (PeopleUserEntity)this.peopleUserBiz.getEntity(people.getPeopleId());
        if (peopleUser == null) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_USER, false, this.getResString("people.user.msg.null.error", Const.RESOURCES));
            return;
        }
        String imgPath = this.getUserIcon(people.getPeopleId(), peopleUser.getPuIcon().trim(), request);
        if (!StringUtil.isBlank((String)imgPath)) {
            oldPeopleUser.setPuIcon(imgPath);
        }
        this.peopleUserBiz.updatePeople((PeopleEntity)oldPeopleUser);
        this.outJson(response, (BaseEnum)ModelCode.PEOPLE_USER, true, this.getResString("people.user.update.msg.success", Const.RESOURCES));
    }

    private String getUserIcon(int peopleId, String imgPath, HttpServletRequest request) {
        if (!StringUtil.isBlank((String)imgPath)) {
            int x1 = this.getInt(request, "x1", 0);
            int y1 = this.getInt(request, "y1", 0);
            int x2 = this.getInt(request, "x2", 0);
            int y2 = this.getInt(request, "y2", 0);
            Integer imgWidth = this.getInt(request, "imgWidth");
            if (StringUtil.isBlank((Object)imgWidth)) {
                return null;
            }
            String sufix = StringUtil.getFileFix((String)imgPath);
            String savePath = StringUtil.buildPath((Object[])new Object[]{"upload", "people", this.getAppId(request), StringUtil.getDateSimpleStr() + "_" + peopleId + sufix});
            String imgWidthStr = StringUtil.buildPath((Object[])new Object[]{this.getRealPath(request, File.separator), imgPath});
            String savePathStr = StringUtil.buildPath((Object[])new Object[]{this.getRealPath(request, File.separator), savePath});
            FileUtil.createFolder((String)savePathStr);
            int[] imgSiz = ImageUtil.getImageWidthHeight((String)imgWidthStr.trim());
            int saveImgWidth = imgSiz[0];
            int newX1 = x1 * saveImgWidth / imgWidth;
            int newY1 = y1 * saveImgWidth / imgWidth;
            ImageUtil.cut((int)newX1, (int)newY1, (int)((x2 - x1) * saveImgWidth / imgWidth), (int)((y2 - y1) * saveImgWidth / imgWidth), (String)imgWidthStr, (String)savePathStr.toString());
            new File(imgWidthStr).delete();
            return savePath;
        }
        return null;
    }
}

