/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.people.action;

import com.alibaba.fastjson.JSONObject;
import com.mingsoft.base.constant.e.BaseCookieEnum;
import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.basic.biz.ICategoryBiz;
import com.mingsoft.basic.biz.IModelBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.constant.e.CookieConstEnum;
import com.mingsoft.basic.entity.ModelEntity;
import com.mingsoft.people.action.BaseAction;
import com.mingsoft.people.biz.IPeopleStudentBiz;
import com.mingsoft.people.entity.PeopleStudentEntity;
import com.mingsoft.util.ExcelUtil;
import com.mingsoft.util.PageUtil;
import com.mingsoft.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/people/student"})
public class PeopleStudentAction
extends BaseAction {
    @Autowired
    private IPeopleStudentBiz peopleStudentBiz;
    @Autowired
    private ICategoryBiz categoryBiz;
    @Autowired
    private IModelBiz modelBiz;

    @RequestMapping(value={"/list"})
    public String list(ModelMap mode, HttpServletRequest request, HttpServletResponse response) {
        Map map = this.assemblyRequestMap(request);
        int appId = this.getAppId(request);
        int peopleCount = this.peopleStudentBiz.getCountByMap(Integer.valueOf(appId), map);
        int pageNo = 1;
        if (request.getParameter("pageNo") != null) {
            pageNo = Integer.parseInt(request.getParameter("pageNo").toString());
        }
        ModelEntity model = this.modelBiz.getEntityByModelCode((BaseEnum)ModelCode.CITY);
        int modelId = 0;
        if (model != null) {
            modelId = model.getModelId();
        }
        List listCategory = this.categoryBiz.queryByAppIdOrModelId(Integer.valueOf(appId), Integer.valueOf(modelId));
        JSONObject ja = new JSONObject();
        mode.addAttribute("listCategory", (Object)listCategory);
        PageUtil page = new PageUtil(pageNo, peopleCount, this.getUrl(request) + "/manager/people/student/list.do");
        List listPeopleStudent = this.peopleStudentBiz.queryByMap(Integer.valueOf(appId), page, map);
        mode.addAttribute("listPeopleStudent", (Object)listPeopleStudent);
        mode.addAttribute("page", (Object)page);
        return this.view("/people/student/people_student_list");
    }

    @RequestMapping(value={"/{peopleId}/query"})
    public void query(@PathVariable int peopleId, HttpServletRequest request, HttpServletResponse response) {
        PeopleStudentEntity peopleStudent = this.peopleStudentBiz.getPeopleStudent(peopleId);
        if (peopleStudent == null) {
            this.outJson(response, (BaseEnum)com.mingsoft.people.constant.ModelCode.PEOPLE, false, this.getResString("people.session.msg.null.error"));
            return;
        }
        this.outJson(response, (BaseEnum)com.mingsoft.people.constant.ModelCode.PEOPLE_USER, true, null, (Object)JSONObject.toJSONString((Object)peopleStudent));
    }

    @RequestMapping(value={"/{peopleId}/edit"})
    public String edit(@PathVariable int peopleId, HttpServletRequest request, HttpServletResponse response) {
        PeopleStudentEntity peopleStudent = this.peopleStudentBiz.getPeopleStudent(peopleId);
        request.setAttribute("peopleStudent", (Object)peopleStudent);
        return this.view("/people/student/people_student");
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute PeopleStudentEntity peopleStudent, HttpServletRequest request, HttpServletResponse response) {
        this.peopleStudentBiz.updatePeopleStudent(peopleStudent);
        String cookie = this.getCookie(request, (BaseCookieEnum)CookieConstEnum.BACK_COOKIE);
        this.outJson(response, null, true, String.valueOf(cookie));
    }

    @RequestMapping(value={"/exprotStudentsExcel"})
    public void exportSendExcel(HttpServletRequest request, HttpServletResponse response) {
        Map map = this.assemblyRequestMap(request);
        int appId = this.getAppId(request);
        List listPeopleStudent = this.peopleStudentBiz.queryByMap(Integer.valueOf(appId), null, map);
        String[] titles = new String[]{"\u7f16\u53f7", "\u59d3\u540d", "\u5b66\u6821", "\u7535\u8bdd", "\u6240\u5728\u7cfb"};
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (int i = 0; i < listPeopleStudent.size(); ++i) {
            PeopleStudentEntity peopleStudent = (PeopleStudentEntity)listPeopleStudent.get(i);
            Object[] objs = new Object[titles.length];
            objs[0] = i + 1;
            objs[1] = peopleStudent.getPuRealName();
            objs[2] = peopleStudent.getPeopleStudentSchool();
            objs[3] = peopleStudent.getPeoplePhone();
            objs[4] = peopleStudent.getPeopleStudentDepartment();
            values.add(objs);
        }
        ExcelUtil.exportExcel((String)("\u5b66\u751f\u4fe1\u606f" + StringUtil.getDateSimpleStr() + ".xls"), (String[])titles, values, (HttpServletResponse)response);
    }
}

