/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.propagation.CurrentTraceContext;
import javax.jms.CompletionListener;
import javax.jms.Message;

final class TracingCompletionListener
implements CompletionListener {
    final Span span;
    final CompletionListener delegate;
    final CurrentTraceContext current;

    static CompletionListener create(CompletionListener delegate, Span span, CurrentTraceContext current) {
        return new TracingCompletionListener(delegate, span, current);
    }

    TracingCompletionListener(CompletionListener delegate, Span span, CurrentTraceContext current) {
        this.span = span;
        this.delegate = delegate;
        this.current = current;
    }

    public void onCompletion(Message message) {
        CurrentTraceContext.Scope ws = this.current.maybeScope(this.span.context());
        try {
            this.delegate.onCompletion(message);
        }
        finally {
            this.span.finish();
            ws.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(Message message, Exception exception) {
        CurrentTraceContext.Scope ws = this.current.maybeScope(this.span.context());
        try {
            this.delegate.onException(message, exception);
        }
        finally {
            this.span.error((Throwable)exception);
            this.span.finish();
            ws.close();
        }
    }
}

