/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.Weighted;
import io.helidon.common.config.Config;
import io.helidon.http.HttpException;
import io.helidon.http.Status;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.observe.ObserveFeatureConfig;
import io.helidon.webserver.observe.spi.Observer;
import io.helidon.webserver.spi.ServerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@RuntimeType.PrototypedBy(value=ObserveFeatureConfig.class)
public class ObserveFeature
implements ServerFeature,
Weighted,
RuntimeType.Api<ObserveFeatureConfig> {
    static final String OBSERVE_ID = "observe";
    static final double WEIGHT = 80.0;
    private final List<Observer> observers;
    private final boolean enabled;
    private final String endpoint;
    private final double weight;
    private final ObserveFeatureConfig config;

    private ObserveFeature(ObserveFeatureConfig config, List<Observer> observers) {
        this.config = config;
        this.enabled = config.enabled();
        this.endpoint = config.endpoint();
        this.weight = config.weight();
        this.observers = observers;
    }

    public static ObserveFeatureConfig.Builder builder() {
        return ObserveFeatureConfig.builder();
    }

    public static ObserveFeature create(Consumer<ObserveFeatureConfig.Builder> consumer) {
        return ((ObserveFeatureConfig.Builder)ObserveFeatureConfig.builder().update(consumer)).build();
    }

    public static ObserveFeature create(ObserveFeatureConfig config) {
        List<Observer> observers = config.observers();
        HashMap<String, Map> uniqueObserversMap = new HashMap<String, Map>();
        ArrayList<Observer> uniqueObservers = new ArrayList<Observer>();
        for (Observer observer : observers) {
            if (uniqueObserversMap.computeIfAbsent(observer.type(), it -> new HashMap()).putIfAbsent(observer.name(), observer) != null) continue;
            uniqueObservers.add(observer);
        }
        return new ObserveFeature(config, uniqueObservers);
    }

    public static ObserveFeature just(Observer ... observers) {
        return ((ObserveFeatureConfig.Builder)((ObserveFeatureConfig.Builder)ObserveFeature.builder().observersDiscoverServices(false)).update(it -> {
            for (Observer observer : observers) {
                it.addObserver(observer);
            }
        })).build();
    }

    public static ObserveFeature create(Observer ... observers) {
        return ((ObserveFeatureConfig.Builder)ObserveFeature.builder().update(it -> {
            for (Observer observer : observers) {
                it.addObserver(observer);
            }
        })).build();
    }

    public static ObserveFeature create() {
        return ObserveFeature.builder().build();
    }

    public static ObserveFeature create(Config config) {
        return ((ObserveFeatureConfig.Builder)ObserveFeature.builder().config(config)).build();
    }

    public ObserveFeatureConfig prototype() {
        return this.config;
    }

    public String name() {
        return this.config.name();
    }

    public String type() {
        return OBSERVE_ID;
    }

    public void setup(ServerFeature.ServerFeatureContext featureContext) {
        List<String> sockets = this.config.sockets();
        List<HttpRouting.Builder> observeEndpointRouting = sockets.isEmpty() ? List.of(featureContext.socket("@default").httpRouting()) : sockets.stream().map(it -> featureContext.socket(it).httpRouting()).toList();
        if (this.enabled) {
            for (Observer observer : this.observers) {
                observer.register(featureContext, observeEndpointRouting, ObserveFeature.endpoint(this.config.endpoint()));
            }
        } else {
            for (HttpRouting.Builder builder : observeEndpointRouting) {
                builder.any(this.endpoint + "/*", new Handler[]{(req, res) -> {
                    throw new HttpException("Observe endpoint is disabled", Status.SERVICE_UNAVAILABLE_503, true);
                }});
            }
        }
    }

    public double weight() {
        return this.weight;
    }

    private static UnaryOperator<String> endpoint(String observeEndpoint) {
        return observerEndpoint -> {
            if (observerEndpoint.startsWith("/")) {
                return observerEndpoint;
            }
            if (observeEndpoint.endsWith("/")) {
                return observeEndpoint + observerEndpoint;
            }
            return observeEndpoint + "/" + observerEndpoint;
        };
    }
}

