/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt.jwk;

import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.JwtUtil;
import io.helidon.security.jwt.jwk.JwkPki;
import jakarta.json.JsonObject;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import java.util.Map;

public class JwkRSA
extends JwkPki {
    public static final String SECURITY_ALGORITHM = "RSA";
    public static final String ALG_RS256 = "RS256";
    public static final String ALG_RS384 = "RS384";
    public static final String ALG_RS512 = "RS512";
    public static final String PARAM_PUB_MODULUS = "n";
    public static final String PARAM_PUB_EXP = "e";
    public static final String PARAM_EXP = "d";
    public static final String PARAM_FIRST_PRIME_FACTOR = "p";
    public static final String PARAM_SECOND_PRIME_FACTOR = "q";
    public static final String PARAM_FIRST_FACTOR_CRT_EXP = "dp";
    public static final String PARAM_SECOND_FACTOR_CRT_EXP = "dq";
    public static final String PARAM_FIRST_CRT_COEFF = "qi";
    public static final String PARAM_OTHER_PRIMES = "oth";
    private static final Map<String, String> ALG_MAP = new HashMap<String, String>();

    private JwkRSA(Builder builder) {
        super(builder, builder.privateKey, builder.publicKey, ALG_RS256);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JwkRSA create(JsonObject json) {
        return JwkRSA.builder().fromJson(json).build();
    }

    @Override
    String signatureAlgorithm() {
        String jwkAlg = this.algorithm();
        String javaAlg = ALG_MAP.get(jwkAlg);
        if (null == javaAlg) {
            throw new JwtException("Unsupported algorithm for RSA: " + jwkAlg);
        }
        return javaAlg;
    }

    static {
        ALG_MAP.put(ALG_RS256, "SHA256withRSA");
        ALG_MAP.put(ALG_RS384, "SHA384withRSA");
        ALG_MAP.put(ALG_RS512, "SHA512withRSA");
        ALG_MAP.put("none", "none");
    }

    public static final class Builder
    extends JwkPki.Builder<Builder>
    implements io.helidon.common.Builder<Builder, JwkRSA> {
        private PrivateKey privateKey;
        private PublicKey publicKey;

        private Builder() {
        }

        private static PublicKey toPublicKey(KeyFactory kf, BigInteger modulus, BigInteger publicExponent) {
            try {
                return kf.generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
            }
            catch (InvalidKeySpecException e) {
                throw new JwtException("Failed to generate RSA public key", e);
            }
        }

        private static PrivateKey toPrivateKey(KeyFactory kf, BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, JsonObject json) {
            return JwtUtil.getBigInteger(json, JwkRSA.PARAM_FIRST_PRIME_FACTOR, "RSA first prime factor").map(firstPrimeFactor -> {
                JwtUtil.getBigInteger(json, JwkRSA.PARAM_OTHER_PRIMES, "RSA other primes info").ifPresent(it -> {
                    throw new JwtException("Other primes info for RSA private key is not (yet) supported");
                });
                BigInteger secondPrimeFactor = JwtUtil.asBigInteger(json, JwkRSA.PARAM_SECOND_PRIME_FACTOR, "RSA second prime factor");
                BigInteger firstFactorCrtExp = JwtUtil.asBigInteger(json, JwkRSA.PARAM_FIRST_FACTOR_CRT_EXP, "RSA first factor CRT exponent");
                BigInteger secondFactorCrtExp = JwtUtil.asBigInteger(json, JwkRSA.PARAM_SECOND_FACTOR_CRT_EXP, "RSA second factor CRT exponent");
                BigInteger firstCrtCoeff = JwtUtil.asBigInteger(json, JwkRSA.PARAM_FIRST_CRT_COEFF, "RSA first CRT coefficient");
                try {
                    return kf.generatePrivate(new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, (BigInteger)firstPrimeFactor, secondPrimeFactor, firstFactorCrtExp, secondFactorCrtExp, firstCrtCoeff));
                }
                catch (Exception e) {
                    throw new JwtException("Failed to generate private key", e);
                }
            }).orElseGet(() -> {
                try {
                    return kf.generatePrivate(new RSAPrivateKeySpec(modulus, privateExponent));
                }
                catch (InvalidKeySpecException e) {
                    throw new JwtException("Failed to generate private key based on modulus and private exponent");
                }
            });
        }

        public Builder privateKey(RSAPrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder publicKey(RSAPublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public Builder fromJson(JsonObject json) {
            super.fromJson(json);
            BigInteger modulus = JwtUtil.asBigInteger(json, JwkRSA.PARAM_PUB_MODULUS, "RSA modulus");
            BigInteger publicExponent = JwtUtil.asBigInteger(json, JwkRSA.PARAM_PUB_EXP, "RSA exponent");
            KeyFactory kf = JwtUtil.getKeyFactory(JwkRSA.SECURITY_ALGORITHM);
            this.privateKey = JwtUtil.getBigInteger(json, JwkRSA.PARAM_EXP, "RSA private exponent").map(d -> Builder.toPrivateKey(kf, modulus, publicExponent, d, json)).orElse(null);
            this.publicKey = Builder.toPublicKey(kf, modulus, publicExponent);
            return this;
        }

        public JwkRSA build() {
            return new JwkRSA(this);
        }
    }
}

