/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.JwtHeaders;
import io.helidon.security.jwt.JwtUtil;
import io.helidon.security.jwt.Validator;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class Jwt {
    static final String CRITICAL = "crit";
    static final String ISSUER = "iss";
    static final String SUBJECT = "sub";
    static final String AUDIENCE = "aud";
    static final String EXPIRATION = "exp";
    static final String NOT_BEFORE = "nbf";
    static final String ISSUED_AT = "iat";
    static final String USER_PRINCIPAL = "upn";
    static final String USER_GROUPS = "groups";
    static final String JWT_ID = "jti";
    static final String EMAIL = "email";
    static final String EMAIL_VERIFIED = "email_verified";
    static final String FULL_NAME = "name";
    static final String GIVEN_NAME = "given_name";
    static final String MIDDLE_NAME = "middle_name";
    static final String FAMILY_NAME = "family_name";
    static final String LOCALE = "locale";
    static final String NICKNAME = "nickname";
    static final String PREFERRED_USERNAME = "preferred_username";
    static final String PROFILE = "profile";
    static final String PICTURE = "picture";
    static final String WEBSITE = "website";
    static final String GENDER = "gender";
    static final String BIRTHDAY = "birthday";
    static final String ZONE_INFO = "zoneinfo";
    static final String PHONE_NUMBER = "phone_number";
    static final String PHONE_NUMBER_VERIFIED = "phone_number_verified";
    static final String UPDATED_AT = "updated_at";
    static final String ADDRESS = "address";
    static final String AT_HASH = "at_hash";
    static final String C_HASH = "c_hash";
    static final String NONCE = "nonce";
    static final String SCOPE = "scope";
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private final JwtHeaders headers;
    private final Map<String, JsonValue> payloadClaims;
    private final Optional<String> issuer;
    private final Optional<Instant> expirationTime;
    private final Optional<Instant> issueTime;
    private final Optional<Instant> notBefore;
    private final Optional<String> subject;
    private final Optional<String> userPrincipal;
    private final Optional<List<String>> userGroups;
    private final Optional<List<String>> audience;
    private final Optional<String> jwtId;
    private final Optional<String> email;
    private final Optional<Boolean> emailVerified;
    private final Optional<String> fullName;
    private final Optional<String> givenName;
    private final Optional<String> middleName;
    private final Optional<String> familyName;
    private final Optional<Locale> locale;
    private final Optional<String> nickname;
    private final Optional<String> preferredUsername;
    private final Optional<URI> profile;
    private final Optional<URI> picture;
    private final Optional<URI> website;
    private final Optional<String> gender;
    private final Optional<LocalDate> birthday;
    private final Optional<ZoneId> timeZone;
    private final Optional<String> phoneNumber;
    private final Optional<Boolean> phoneNumberVerified;
    private final Optional<Instant> updatedAt;
    private final Optional<JwtUtil.Address> address;
    private final Optional<List<String>> scopes;
    private final Optional<byte[]> atHash;
    private final Optional<byte[]> cHash;
    private final Optional<String> nonce;

    Jwt(JwtHeaders headers, JsonObject payloadJson) {
        this.headers = headers;
        this.payloadClaims = this.getClaims(payloadJson);
        this.issuer = JwtUtil.getString(payloadJson, ISSUER);
        this.expirationTime = JwtUtil.toInstant(payloadJson, EXPIRATION);
        this.issueTime = JwtUtil.toInstant(payloadJson, ISSUED_AT);
        this.notBefore = JwtUtil.toInstant(payloadJson, NOT_BEFORE);
        this.subject = JwtUtil.getString(payloadJson, SUBJECT);
        JsonValue groups = (JsonValue)payloadJson.get((Object)USER_GROUPS);
        this.userGroups = groups instanceof JsonArray ? JwtUtil.getStrings(payloadJson, USER_GROUPS) : JwtUtil.getString(payloadJson, USER_GROUPS).map(List::of);
        JsonValue aud = (JsonValue)payloadJson.get((Object)AUDIENCE);
        this.audience = aud instanceof JsonArray ? JwtUtil.getStrings(payloadJson, AUDIENCE) : JwtUtil.getString(payloadJson, AUDIENCE).map(List::of);
        this.jwtId = JwtUtil.getString(payloadJson, JWT_ID);
        this.email = JwtUtil.getString(payloadJson, EMAIL);
        this.emailVerified = JwtUtil.toBoolean(payloadJson, EMAIL_VERIFIED);
        this.fullName = JwtUtil.getString(payloadJson, FULL_NAME);
        this.givenName = JwtUtil.getString(payloadJson, GIVEN_NAME);
        this.middleName = JwtUtil.getString(payloadJson, MIDDLE_NAME);
        this.familyName = JwtUtil.getString(payloadJson, FAMILY_NAME);
        this.locale = JwtUtil.toLocale(payloadJson, LOCALE);
        this.nickname = JwtUtil.getString(payloadJson, NICKNAME);
        this.preferredUsername = JwtUtil.getString(payloadJson, PREFERRED_USERNAME);
        this.profile = JwtUtil.toUri(payloadJson, PROFILE);
        this.picture = JwtUtil.toUri(payloadJson, PICTURE);
        this.website = JwtUtil.toUri(payloadJson, WEBSITE);
        this.gender = JwtUtil.getString(payloadJson, GENDER);
        this.birthday = JwtUtil.toDate(payloadJson, BIRTHDAY);
        this.timeZone = JwtUtil.toTimeZone(payloadJson, ZONE_INFO);
        this.phoneNumber = JwtUtil.getString(payloadJson, PHONE_NUMBER);
        this.phoneNumberVerified = JwtUtil.toBoolean(payloadJson, PHONE_NUMBER_VERIFIED);
        this.updatedAt = JwtUtil.toInstant(payloadJson, UPDATED_AT);
        this.address = JwtUtil.toAddress(payloadJson, ADDRESS);
        this.atHash = JwtUtil.getByteArray(payloadJson, AT_HASH, "at_hash value");
        this.cHash = JwtUtil.getByteArray(payloadJson, C_HASH, "c_hash value");
        this.nonce = JwtUtil.getString(payloadJson, NONCE);
        this.scopes = JwtUtil.toScopes(payloadJson);
        this.userPrincipal = JwtUtil.getString(payloadJson, USER_PRINCIPAL).or(() -> this.preferredUsername).or(() -> this.subject);
    }

    private Jwt(Builder builder) {
        this.payloadClaims = new HashMap<String, JsonValue>();
        this.payloadClaims.putAll(JwtUtil.transformToJson(builder.payloadClaims));
        this.headers = builder.headerBuilder.build();
        this.issuer = builder.issuer;
        this.expirationTime = builder.expirationTime;
        this.issueTime = builder.issueTime;
        this.notBefore = builder.notBefore;
        this.subject = builder.subject.or(() -> Jwt.toOptionalString(builder.payloadClaims, SUBJECT));
        this.audience = Optional.ofNullable(builder.audience);
        this.jwtId = builder.jwtId;
        this.email = builder.email.or(() -> Jwt.toOptionalString(builder.payloadClaims, EMAIL));
        this.emailVerified = builder.emailVerified.or(() -> Jwt.getClaim(builder.payloadClaims, EMAIL_VERIFIED));
        this.fullName = builder.fullName.or(() -> Jwt.toOptionalString(builder.payloadClaims, FULL_NAME));
        this.givenName = builder.givenName.or(() -> Jwt.toOptionalString(builder.payloadClaims, GIVEN_NAME));
        this.middleName = builder.middleName.or(() -> Jwt.toOptionalString(builder.payloadClaims, MIDDLE_NAME));
        this.familyName = builder.familyName.or(() -> Jwt.toOptionalString(builder.payloadClaims, FAMILY_NAME));
        this.locale = builder.locale.or(() -> Jwt.getClaim(builder.payloadClaims, LOCALE));
        this.nickname = builder.nickname.or(() -> Jwt.toOptionalString(builder.payloadClaims, NICKNAME));
        this.preferredUsername = builder.preferredUsername.or(() -> Jwt.toOptionalString(builder.payloadClaims, PREFERRED_USERNAME));
        this.profile = builder.profile.or(() -> Jwt.getClaim(builder.payloadClaims, PROFILE));
        this.picture = builder.picture.or(() -> Jwt.getClaim(builder.payloadClaims, PICTURE));
        this.website = builder.website.or(() -> Jwt.getClaim(builder.payloadClaims, WEBSITE));
        this.gender = builder.gender.or(() -> Jwt.toOptionalString(builder.payloadClaims, GENDER));
        this.birthday = builder.birthday.or(() -> Jwt.getClaim(builder.payloadClaims, BIRTHDAY));
        this.timeZone = builder.timeZone.or(() -> Jwt.getClaim(builder.payloadClaims, ZONE_INFO));
        this.phoneNumber = builder.phoneNumber.or(() -> Jwt.toOptionalString(builder.payloadClaims, PHONE_NUMBER));
        this.phoneNumberVerified = builder.phoneNumberVerified.or(() -> Jwt.getClaim(builder.payloadClaims, PHONE_NUMBER_VERIFIED));
        this.updatedAt = builder.updatedAt;
        this.address = builder.address;
        this.atHash = builder.atHash;
        this.cHash = builder.cHash;
        this.nonce = builder.nonce;
        this.scopes = builder.scopes;
        this.userPrincipal = builder.userPrincipal.or(() -> Jwt.toOptionalString(builder.payloadClaims, USER_PRINCIPAL)).or(() -> this.preferredUsername).or(() -> this.subject);
        this.userGroups = builder.userGroups;
    }

    private static <T> Optional<T> getClaim(Map<String, Object> claims, String claim) {
        return Optional.ofNullable(claims.get(claim));
    }

    private static Optional<String> toOptionalString(Map<String, Object> claims, String claim) {
        Object value = claims.get(claim);
        if (null == value) {
            return Optional.empty();
        }
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        return Optional.of(String.valueOf(value));
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public static List<Validator<Jwt>> defaultTimeValidators() {
        LinkedList<Validator<Jwt>> validators = new LinkedList<Validator<Jwt>>();
        validators.add(new ExpirationValidator(false));
        validators.add(new IssueTimeValidator());
        validators.add(new NotBeforeValidator());
        return validators;
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public static List<Validator<Jwt>> defaultTimeValidators(Instant now, int timeSkewAmount, ChronoUnit timeSkewUnit, boolean mandatory) {
        LinkedList<Validator<Jwt>> validators = new LinkedList<Validator<Jwt>>();
        validators.add(new ExpirationValidator(now, timeSkewAmount, timeSkewUnit, mandatory));
        validators.add(new IssueTimeValidator(now, timeSkewAmount, timeSkewUnit, mandatory));
        validators.add(new NotBeforeValidator(now, timeSkewAmount, timeSkewUnit, mandatory));
        return validators;
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public static void addIssuerValidator(Collection<Validator<Jwt>> validators, String issuer, boolean mandatory) {
        validators.add(FieldValidator.create(Jwt::issuer, "Issuer", issuer, mandatory));
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public static void addAudienceValidator(Collection<Validator<Jwt>> validators, String audience, boolean mandatory) {
        Jwt.addAudienceValidator(validators, Set.of(audience), mandatory);
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public static void addAudienceValidator(Collection<Validator<Jwt>> validators, Set<String> audience, boolean mandatory) {
        validators.add((jwt, collector) -> {
            Optional<List<String>> jwtAudiences = jwt.audience();
            if (jwtAudiences.isPresent()) {
                if (audience.stream().anyMatch(jwtAudiences.get()::contains)) {
                    return;
                }
                collector.fatal(jwt, "Audience must contain " + String.valueOf(audience) + ", yet it is: " + String.valueOf(jwtAudiences));
            } else if (mandatory) {
                collector.fatal(jwt, "Audience is expected to be: " + String.valueOf(audience) + ", yet no audience in JWT");
            }
        });
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public static void addMaxTokenAgeValidator(Collection<Validator<Jwt>> validators, Duration expectedMaxTokenAge, Duration clockSkew, boolean iatRequired) {
        validators.add((jwt, collector) -> {
            Optional<Instant> maybeIssueTime = jwt.issueTime();
            if (maybeIssueTime.isPresent()) {
                Instant now = Instant.now();
                Instant issueTime = maybeIssueTime.get().minus(clockSkew);
                Instant maxValidTime = issueTime.plus(expectedMaxTokenAge).plus(clockSkew);
                if (issueTime.isBefore(now) && maxValidTime.isAfter(now)) {
                    return;
                }
                collector.fatal(jwt, "Current time need to be between " + String.valueOf(issueTime) + " and " + String.valueOf(maxValidTime) + ", but was " + String.valueOf(now));
            } else if (iatRequired) {
                collector.fatal(jwt, "Claim iat is required to be present in JWT when validating token max allowed age.");
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    private Map<String, JsonValue> getClaims(JsonObject headerJson) {
        return Collections.unmodifiableMap(headerJson);
    }

    public Optional<List<String>> scopes() {
        return this.scopes.map(Collections::unmodifiableList);
    }

    public Optional<JsonValue> headerClaim(String claim) {
        return this.headers.headerClaim(claim);
    }

    public Optional<JsonValue> payloadClaim(String claim) {
        JsonValue rawValue = this.payloadClaims.get(claim);
        if (claim.equals(AUDIENCE)) {
            return Optional.ofNullable(this.ensureJsonArray(rawValue));
        }
        return Optional.ofNullable(rawValue);
    }

    private JsonValue ensureJsonArray(JsonValue rawValue) {
        if (rawValue instanceof JsonArray) {
            return rawValue;
        }
        return JSON.createArrayBuilder().add(rawValue).build();
    }

    public JwtHeaders headers() {
        return this.headers;
    }

    public Map<String, JsonValue> payloadClaims() {
        return Collections.unmodifiableMap(this.payloadClaims);
    }

    public Optional<String> algorithm() {
        return this.headers.algorithm();
    }

    public Optional<String> keyId() {
        return this.headers.keyId();
    }

    public Optional<String> type() {
        return this.headers.type();
    }

    public Optional<String> contentType() {
        return this.headers.contentType();
    }

    public Optional<String> issuer() {
        return this.issuer;
    }

    public Optional<Instant> expirationTime() {
        return this.expirationTime;
    }

    public Optional<Instant> issueTime() {
        return this.issueTime;
    }

    public Optional<Instant> notBefore() {
        return this.notBefore;
    }

    public Optional<String> subject() {
        return this.subject;
    }

    public Optional<String> userPrincipal() {
        return this.userPrincipal;
    }

    public Optional<List<String>> userGroups() {
        return this.userGroups.map(Collections::unmodifiableList);
    }

    public Optional<List<String>> audience() {
        return this.audience;
    }

    public Optional<String> jwtId() {
        return this.jwtId;
    }

    public Optional<String> email() {
        return this.email;
    }

    public Optional<Boolean> emailVerified() {
        return this.emailVerified;
    }

    public Optional<String> fullName() {
        return this.fullName;
    }

    public Optional<String> givenName() {
        return this.givenName;
    }

    public Optional<String> middleName() {
        return this.middleName;
    }

    public Optional<String> familyName() {
        return this.familyName;
    }

    public Optional<Locale> locale() {
        return this.locale;
    }

    public Optional<String> nickname() {
        return this.nickname;
    }

    public Optional<String> preferredUsername() {
        return this.preferredUsername;
    }

    public Optional<URI> profile() {
        return this.profile;
    }

    public Optional<URI> picture() {
        return this.picture;
    }

    public Optional<URI> website() {
        return this.website;
    }

    public Optional<String> gender() {
        return this.gender;
    }

    public Optional<LocalDate> birthday() {
        return this.birthday;
    }

    public Optional<ZoneId> timeZone() {
        return this.timeZone;
    }

    public Optional<String> phoneNumber() {
        return this.phoneNumber;
    }

    public Optional<Boolean> phoneNumberVerified() {
        return this.phoneNumberVerified;
    }

    public Optional<Instant> updatedAt() {
        return this.updatedAt;
    }

    public Optional<JwtUtil.Address> address() {
        return this.address;
    }

    public Optional<byte[]> atHash() {
        return this.atHash;
    }

    public Optional<byte[]> cHash() {
        return this.cHash;
    }

    public Optional<String> nonce() {
        return this.nonce;
    }

    public JsonObject headerJson() {
        return this.headers.headerJson();
    }

    public JsonObject payloadJson() {
        JsonObjectBuilder objectBuilder = JSON.createObjectBuilder();
        this.payloadClaims.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)objectBuilder).add(arg_0, arg_1));
        this.issuer.ifPresent(it -> objectBuilder.add(ISSUER, it));
        this.expirationTime.ifPresent(it -> objectBuilder.add(EXPIRATION, it.getEpochSecond()));
        this.issueTime.ifPresent(it -> objectBuilder.add(ISSUED_AT, it.getEpochSecond()));
        this.notBefore.ifPresent(it -> objectBuilder.add(NOT_BEFORE, it.getEpochSecond()));
        this.subject.ifPresent(it -> objectBuilder.add(SUBJECT, it));
        this.userPrincipal.ifPresent(it -> objectBuilder.add(USER_PRINCIPAL, it));
        this.userGroups.ifPresent(it -> {
            JsonArrayBuilder jab = JSON.createArrayBuilder();
            it.forEach(arg_0 -> ((JsonArrayBuilder)jab).add(arg_0));
            objectBuilder.add(USER_GROUPS, jab);
        });
        this.audience.ifPresent(it -> {
            JsonArrayBuilder jab = JSON.createArrayBuilder();
            it.forEach(arg_0 -> ((JsonArrayBuilder)jab).add(arg_0));
            objectBuilder.add(AUDIENCE, jab);
        });
        this.jwtId.ifPresent(it -> objectBuilder.add(JWT_ID, it));
        this.email.ifPresent(it -> objectBuilder.add(EMAIL, it));
        this.emailVerified.ifPresent(it -> objectBuilder.add(EMAIL_VERIFIED, it.booleanValue()));
        this.fullName.ifPresent(it -> objectBuilder.add(FULL_NAME, it));
        this.givenName.ifPresent(it -> objectBuilder.add(GIVEN_NAME, it));
        this.middleName.ifPresent(it -> objectBuilder.add(MIDDLE_NAME, it));
        this.familyName.ifPresent(it -> objectBuilder.add(FAMILY_NAME, it));
        this.locale.ifPresent(it -> objectBuilder.add(LOCALE, it.toLanguageTag()));
        this.nickname.ifPresent(it -> objectBuilder.add(NICKNAME, it));
        this.preferredUsername.ifPresent(it -> objectBuilder.add(PREFERRED_USERNAME, it));
        this.profile.ifPresent(it -> objectBuilder.add(PROFILE, it.toASCIIString()));
        this.picture.ifPresent(it -> objectBuilder.add(PICTURE, it.toASCIIString()));
        this.website.ifPresent(it -> objectBuilder.add(WEBSITE, it.toASCIIString()));
        this.gender.ifPresent(it -> objectBuilder.add(GENDER, it));
        this.birthday.ifPresent(it -> objectBuilder.add(BIRTHDAY, JwtUtil.toDate(it)));
        this.timeZone.ifPresent(it -> objectBuilder.add(ZONE_INFO, it.getId()));
        this.phoneNumber.ifPresent(it -> objectBuilder.add(PHONE_NUMBER, it));
        this.phoneNumberVerified.ifPresent(it -> objectBuilder.add(PHONE_NUMBER_VERIFIED, it.booleanValue()));
        this.updatedAt.ifPresent(it -> objectBuilder.add(UPDATED_AT, it.getEpochSecond()));
        this.address.ifPresent(it -> objectBuilder.add(ADDRESS, (JsonValue)it.getJson()));
        this.atHash.ifPresent(it -> objectBuilder.add(AT_HASH, JwtUtil.base64Url(it)));
        this.cHash.ifPresent(it -> objectBuilder.add(C_HASH, JwtUtil.base64Url(it)));
        this.nonce.ifPresent(it -> objectBuilder.add(NONCE, it));
        this.scopes.ifPresent(it -> {
            String scopesString = String.join((CharSequence)" ", it);
            objectBuilder.add(SCOPE, scopesString);
        });
        return objectBuilder.build();
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public Errors validate(List<Validator<Jwt>> validators) {
        Errors.Collector collector = Errors.collector();
        validators.forEach(it -> it.validate(this, collector));
        return collector.collect();
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public Errors validate(String issuer, String audience) {
        return this.validate(issuer, audience == null ? Set.of() : Set.of(audience));
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public Errors validate(String issuer, String audience, boolean checkAudience) {
        return this.validate(issuer, audience == null ? Set.of() : Set.of(audience), checkAudience);
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public Errors validate(String issuer, Set<String> audience, boolean checkAudience) {
        List<Validator<Jwt>> validators = Jwt.defaultTimeValidators();
        if (null != issuer) {
            Jwt.addIssuerValidator(validators, issuer, true);
        }
        if (checkAudience && null != audience) {
            audience.stream().filter(Objects::nonNull).findAny().ifPresent(it -> Jwt.addAudienceValidator((Collection<Validator<Jwt>>)validators, audience, true));
        }
        Jwt.addUserPrincipalValidator(validators);
        return this.validate(validators);
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public Errors validate(String issuer, Set<String> audience) {
        return this.validate(issuer, audience, true);
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public static void addUserPrincipalValidator(Collection<Validator<Jwt>> validators) {
        validators.add(new UserPrincipalValidator());
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, Jwt> {
        private final JwtHeaders.Builder headerBuilder = JwtHeaders.builder();
        private final Map<String, Object> payloadClaims = new HashMap<String, Object>();
        private Optional<String> issuer = Optional.empty();
        private Optional<Instant> expirationTime = Optional.empty();
        private Optional<Instant> issueTime = Optional.empty();
        private Optional<Instant> notBefore = Optional.empty();
        private Optional<String> subject = Optional.empty();
        private Optional<String> userPrincipal = Optional.empty();
        private Optional<List<String>> userGroups = Optional.empty();
        private List<String> audience;
        private Optional<String> jwtId = Optional.empty();
        private Optional<String> email = Optional.empty();
        private Optional<Boolean> emailVerified = Optional.empty();
        private Optional<String> fullName = Optional.empty();
        private Optional<String> givenName = Optional.empty();
        private Optional<String> middleName = Optional.empty();
        private Optional<String> familyName = Optional.empty();
        private Optional<Locale> locale = Optional.empty();
        private Optional<String> nickname = Optional.empty();
        private Optional<String> preferredUsername = Optional.empty();
        private Optional<URI> profile = Optional.empty();
        private Optional<URI> picture = Optional.empty();
        private Optional<URI> website = Optional.empty();
        private Optional<String> gender = Optional.empty();
        private Optional<LocalDate> birthday = Optional.empty();
        private Optional<ZoneId> timeZone = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<Boolean> phoneNumberVerified = Optional.empty();
        private Optional<Instant> updatedAt = Optional.empty();
        private Optional<JwtUtil.Address> address = Optional.empty();
        private Optional<byte[]> atHash = Optional.empty();
        private Optional<byte[]> cHash = Optional.empty();
        private Optional<String> nonce = Optional.empty();
        private Optional<List<String>> scopes = Optional.empty();

        private Builder() {
        }

        public Builder keyId(String keyId) {
            this.headerBuilder.keyId(keyId);
            return this;
        }

        public Builder type(String type) {
            this.headerBuilder.type(type);
            return this;
        }

        public Builder scopes(List<String> scopes) {
            LinkedList<String> list = new LinkedList<String>(scopes);
            this.scopes = Optional.of(list);
            return this;
        }

        public Builder addScope(String scope) {
            this.scopes = this.scopes.or(() -> Optional.of(new LinkedList()));
            this.scopes.ifPresent(it -> it.add(scope));
            return this;
        }

        public Builder addUserGroup(String group) {
            this.userGroups = this.userGroups.or(() -> Optional.of(new LinkedList()));
            this.userGroups.ifPresent(it -> it.add(group));
            return this;
        }

        public Builder contentType(String contentType) {
            this.headerBuilder.contentType(contentType);
            return this;
        }

        public Builder addHeaderClaim(String claim, Object value) {
            this.headerBuilder.addHeaderClaim(claim, value);
            return this;
        }

        private void addClaim(Map<String, Object> claims, String claim, Object value) {
            claims.put(claim, value);
        }

        public Builder addPayloadClaim(String claim, Object value) {
            this.addClaim(this.payloadClaims, claim, value);
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.headerBuilder.algorithm(algorithm);
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = Optional.ofNullable(issuer);
            return this;
        }

        public Builder expirationTime(Instant expirationTime) {
            this.expirationTime = Optional.ofNullable(expirationTime);
            return this;
        }

        public Builder issueTime(Instant issueTime) {
            this.issueTime = Optional.ofNullable(issueTime);
            return this;
        }

        public Builder notBefore(Instant notBefore) {
            this.notBefore = Optional.ofNullable(notBefore);
            return this;
        }

        public Builder subject(String subject) {
            this.subject = Optional.ofNullable(subject);
            return this;
        }

        public Builder userPrincipal(String principal) {
            this.userPrincipal = Optional.ofNullable(principal);
            return this;
        }

        public Builder addAudience(String audience) {
            if (this.audience == null) {
                this.audience = new LinkedList<String>();
            }
            this.audience.add(audience);
            return this;
        }

        public Builder audience(List<String> audience) {
            this.audience = new LinkedList<String>(audience);
            return this;
        }

        public Builder jwtId(String jwtId) {
            this.jwtId = Optional.ofNullable(jwtId);
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        public Builder emailVerified(Boolean emailVerified) {
            this.emailVerified = Optional.ofNullable(emailVerified);
            return this;
        }

        public Builder fullName(String fullName) {
            this.fullName = Optional.ofNullable(fullName);
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = Optional.ofNullable(givenName);
            return this;
        }

        public Builder middleName(String middleName) {
            this.middleName = Optional.ofNullable(middleName);
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = Optional.ofNullable(familyName);
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = Optional.ofNullable(locale);
            return this;
        }

        public Builder nickname(String nickname) {
            this.nickname = Optional.ofNullable(nickname);
            return this;
        }

        public Builder preferredUsername(String preferredUsername) {
            this.preferredUsername = Optional.ofNullable(preferredUsername);
            return this;
        }

        public Builder profile(URI profile) {
            this.profile = Optional.ofNullable(profile);
            return this;
        }

        public Builder picture(URI picture) {
            this.picture = Optional.ofNullable(picture);
            return this;
        }

        public Builder website(URI website) {
            this.website = Optional.ofNullable(website);
            return this;
        }

        public Builder gender(String gender) {
            this.gender = Optional.ofNullable(gender);
            return this;
        }

        public Builder birthday(LocalDate birthday) {
            this.birthday = Optional.ofNullable(birthday);
            return this;
        }

        public Builder timeZone(ZoneId timeZone) {
            this.timeZone = Optional.ofNullable(timeZone);
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        public Builder phoneNumberVerified(Boolean phoneNumberVerified) {
            this.phoneNumberVerified = Optional.ofNullable(phoneNumberVerified);
            return this;
        }

        public Builder updatedAt(Instant updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public Builder address(JwtUtil.Address address) {
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Builder atHash(byte[] atHash) {
            this.atHash = Optional.ofNullable(atHash);
            return this;
        }

        public Builder cHash(byte[] cHash) {
            this.cHash = Optional.ofNullable(cHash);
            return this;
        }

        public Builder nonce(String nonce) {
            this.nonce = Optional.ofNullable(nonce);
            return this;
        }

        public Builder headerBuilder(Consumer<JwtHeaders.Builder> consumer) {
            consumer.accept(this.headerBuilder);
            return this;
        }

        public Jwt build() {
            return new Jwt(this);
        }

        public Builder removePayloadClaim(String name) {
            this.payloadClaims.remove(name);
            return this;
        }
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public static final class ExpirationValidator
    extends InstantValidator
    implements Validator<Jwt> {
        private ExpirationValidator(boolean mandatory) {
            super(mandatory);
        }

        private ExpirationValidator(Instant now, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            super(now, allowedTimeSkew, allowedTimeSkewUnit, mandatory);
        }

        public static ExpirationValidator create() {
            return new ExpirationValidator(false);
        }

        public static ExpirationValidator create(boolean mandatory) {
            return new ExpirationValidator(mandatory);
        }

        public static ExpirationValidator create(Instant now, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            return new ExpirationValidator(now, allowedTimeSkew, allowedTimeSkewUnit, mandatory);
        }

        @Override
        public void validate(Jwt token, Errors.Collector collector) {
            Optional<Instant> expirationTime = token.expirationTime();
            expirationTime.ifPresent(it -> {
                if (this.earliest().isAfter((Instant)it)) {
                    collector.fatal((Object)token, "Token no longer valid, expiration: " + String.valueOf(it));
                }
                token.issueTime().ifPresent(issued -> {
                    if (issued.isAfter((Instant)it)) {
                        collector.fatal((Object)token, "Token issue date is after its expiration, issue: " + String.valueOf(it) + ", expiration: " + String.valueOf(it));
                    }
                });
            });
            super.validate("expirationTime", expirationTime, collector);
        }
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public static final class IssueTimeValidator
    extends InstantValidator
    implements Validator<Jwt> {
        private IssueTimeValidator() {
        }

        private IssueTimeValidator(Instant now, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            super(now, allowedTimeSkew, allowedTimeSkewUnit, mandatory);
        }

        public static IssueTimeValidator create() {
            return new IssueTimeValidator();
        }

        public static IssueTimeValidator create(Instant now, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            return new IssueTimeValidator(now, allowedTimeSkew, allowedTimeSkewUnit, mandatory);
        }

        @Override
        public void validate(Jwt token, Errors.Collector collector) {
            Optional<Instant> issueTime = token.issueTime();
            issueTime.ifPresent(it -> {
                if (this.latest().isBefore((Instant)it)) {
                    collector.fatal((Object)token, "Token was not issued in the past: " + String.valueOf(it));
                }
            });
            super.validate("issueTime", issueTime, collector);
        }
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public static final class NotBeforeValidator
    extends InstantValidator
    implements Validator<Jwt> {
        private NotBeforeValidator() {
        }

        private NotBeforeValidator(Instant now, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            super(now, allowedTimeSkew, allowedTimeSkewUnit, mandatory);
        }

        public static NotBeforeValidator create() {
            return new NotBeforeValidator();
        }

        public static NotBeforeValidator create(Instant now, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            return new NotBeforeValidator(now, allowedTimeSkew, allowedTimeSkewUnit, mandatory);
        }

        @Override
        public void validate(Jwt token, Errors.Collector collector) {
            Optional<Instant> notBefore = token.notBefore();
            notBefore.ifPresent(it -> {
                if (this.latest().isBefore((Instant)it)) {
                    collector.fatal((Object)token, "Token not yet valid, not before: " + String.valueOf(it));
                }
            });
            super.validate("notBefore", notBefore, collector);
        }
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public static final class FieldValidator
    extends OptionalValidator
    implements Validator<Jwt> {
        private final Function<Jwt, Optional<String>> fieldAccessor;
        private final String expectedValue;
        private final String fieldName;

        private FieldValidator(Function<Jwt, Optional<String>> fieldAccessor, String fieldName, String expectedValue, boolean mandatory) {
            super(mandatory);
            this.fieldAccessor = fieldAccessor;
            this.fieldName = fieldName;
            this.expectedValue = expectedValue;
        }

        public static FieldValidator create(Function<Jwt, Optional<String>> fieldAccessor, String name, String expectedValue) {
            return FieldValidator.create(fieldAccessor, name, expectedValue, false);
        }

        public static FieldValidator create(Function<Jwt, Optional<String>> fieldAccessor, String name, String expectedValue, boolean mandatory) {
            return new FieldValidator(fieldAccessor, name, expectedValue, mandatory);
        }

        public static FieldValidator createForHeader(String fieldKey, String name, String expectedValue) {
            return FieldValidator.createForHeader(fieldKey, name, expectedValue, false);
        }

        public static FieldValidator createForHeader(String fieldKey, String name, String expectedValue, boolean mandatory) {
            return FieldValidator.create(jwt -> jwt.headerClaim(fieldKey).map(it -> ((JsonString)it).getString()), name, expectedValue, mandatory);
        }

        public static FieldValidator createForPayload(String fieldKey, String name, String expectedValue) {
            return FieldValidator.createForPayload(fieldKey, name, expectedValue, false);
        }

        public static FieldValidator createForPayload(String fieldKey, String name, String expectedValue, boolean mandatory) {
            return FieldValidator.create(jwt -> jwt.payloadClaim(fieldKey).map(it -> ((JsonString)it).getString()), name, expectedValue, false);
        }

        @Override
        public void validate(Jwt token, Errors.Collector collector) {
            super.validate(this.fieldName, this.fieldAccessor.apply(token), collector).ifPresent(it -> {
                if (!this.expectedValue.equals(it)) {
                    collector.fatal((Object)token, "Expected value of field \"" + this.fieldName + "\" was \"" + this.expectedValue + "\", but actual value is: \"" + it);
                }
            });
        }
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    private static final class UserPrincipalValidator
    extends OptionalValidator
    implements Validator<Jwt> {
        private UserPrincipalValidator() {
            super(true);
        }

        @Override
        public void validate(Jwt object, Errors.Collector collector) {
            super.validate("User Principal", object.userPrincipal(), collector);
        }
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    private static abstract class InstantValidator
    extends OptionalValidator {
        private final Instant instant;
        private final long allowedTimeSkewAmount;
        private final TemporalUnit allowedTimeSkewUnit;

        private InstantValidator() {
            this.instant = null;
            this.allowedTimeSkewAmount = 5L;
            this.allowedTimeSkewUnit = ChronoUnit.SECONDS;
        }

        private InstantValidator(boolean mandatory) {
            super(mandatory);
            this.instant = null;
            this.allowedTimeSkewAmount = 5L;
            this.allowedTimeSkewUnit = ChronoUnit.SECONDS;
        }

        private InstantValidator(Instant instant, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            super(mandatory);
            this.instant = instant;
            this.allowedTimeSkewAmount = allowedTimeSkew;
            this.allowedTimeSkewUnit = allowedTimeSkewUnit;
        }

        Instant latest() {
            return this.instant().plus(this.allowedTimeSkewAmount, this.allowedTimeSkewUnit);
        }

        Instant earliest() {
            return this.instant().minus(this.allowedTimeSkewAmount, this.allowedTimeSkewUnit);
        }

        Instant instant() {
            return this.instant == null ? Instant.now() : this.instant;
        }
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    private static abstract class OptionalValidator {
        private final boolean mandatory;

        OptionalValidator() {
            this.mandatory = false;
        }

        OptionalValidator(boolean mandatory) {
            this.mandatory = mandatory;
        }

        <T> Optional<T> validate(String name, Optional<T> optional, Errors.Collector collector) {
            if (this.mandatory && optional.isEmpty()) {
                collector.fatal("Field " + name + " is mandatory, yet not defined in JWT");
            }
            return optional;
        }
    }
}

