/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.providers.openai;

import dev.langchain4j.model.Tokenizer;
import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.integrations.langchain4j.providers.openai.OpenAiLanguageModelConfigBlueprint;
import java.net.Proxy;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.integrations.langchain4j.providers.openai.OpenAiLanguageModelConfigBlueprint")
public interface OpenAiLanguageModelConfig
extends OpenAiLanguageModelConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OpenAiLanguageModelConfig instance) {
        return (Builder)OpenAiLanguageModelConfig.builder().from(instance);
    }

    public static OpenAiLanguageModelConfig create(Config config) {
        return ((Builder)OpenAiLanguageModelConfig.builder().config(config)).buildPrototype();
    }

    public static OpenAiLanguageModelConfig create() {
        return OpenAiLanguageModelConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, OpenAiLanguageModelConfig>
    implements io.helidon.common.Builder<Builder, OpenAiLanguageModelConfig> {
        private Builder() {
        }

        public OpenAiLanguageModelConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OpenAiLanguageModelConfigImpl(this);
        }

        public OpenAiLanguageModelConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OpenAiLanguageModelConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Map<String, String> customHeaders = new LinkedHashMap<String, String>();
        private Boolean logRequests;
        private Boolean logResponses;
        private boolean enabled;
        private Config config;
        private Double temperature;
        private Duration timeout;
        private Integer maxRetries;
        private Proxy proxy;
        private String apiKey;
        private String baseUrl;
        private String modelName;
        private String organizationId;
        private Tokenizer tokenizer;

        protected BuilderBase() {
        }

        public BUILDER from(OpenAiLanguageModelConfig prototype) {
            this.maxRetries(prototype.maxRetries());
            this.temperature(prototype.temperature());
            this.tokenizer(prototype.tokenizer());
            this.enabled(prototype.enabled());
            this.baseUrl(prototype.baseUrl());
            this.apiKey(prototype.apiKey());
            this.logRequests(prototype.logRequests());
            this.logResponses(prototype.logResponses());
            this.addCustomHeaders(prototype.customHeaders());
            this.timeout(prototype.timeout());
            this.proxy(prototype.proxy());
            this.organizationId(prototype.organizationId());
            this.modelName(prototype.modelName());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.maxRetries().ifPresent(this::maxRetries);
            builder.temperature().ifPresent(this::temperature);
            builder.tokenizer().ifPresent(this::tokenizer);
            this.enabled(builder.enabled());
            builder.baseUrl().ifPresent(this::baseUrl);
            builder.apiKey().ifPresent(this::apiKey);
            builder.logRequests().ifPresent(this::logRequests);
            builder.logResponses().ifPresent(this::logResponses);
            this.addCustomHeaders(builder.customHeaders);
            builder.timeout().ifPresent(this::timeout);
            builder.proxy().ifPresent(this::proxy);
            builder.organizationId().ifPresent(this::organizationId);
            builder.modelName().ifPresent(this::modelName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("max-retries").as(Integer.class).ifPresent(this::maxRetries);
            config.get("temperature").as(Double.class).ifPresent(this::temperature);
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("base-url").as(String.class).ifPresent(this::baseUrl);
            config.get("api-key").as(String.class).ifPresent(this::apiKey);
            config.get("log-requests").as(Boolean.class).ifPresent(this::logRequests);
            config.get("log-responses").as(Boolean.class).ifPresent(this::logResponses);
            config.get("custom-headers").detach().asMap().ifPresent(this::customHeaders);
            config.get("timeout").as(Duration.class).ifPresent(this::timeout);
            config.get("organization-id").as(String.class).ifPresent(this::organizationId);
            config.get("model-name").as(String.class).ifPresent(this::modelName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMaxRetries() {
            this.maxRetries = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxRetries(int maxRetries) {
            Objects.requireNonNull(maxRetries);
            this.maxRetries = maxRetries;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTemperature() {
            this.temperature = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER temperature(double temperature) {
            Objects.requireNonNull(temperature);
            this.temperature = temperature;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTokenizer() {
            this.tokenizer = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tokenizer(Tokenizer tokenizer) {
            Objects.requireNonNull(tokenizer);
            this.tokenizer = tokenizer;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearBaseUrl() {
            this.baseUrl = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER baseUrl(String baseUrl) {
            Objects.requireNonNull(baseUrl);
            this.baseUrl = baseUrl;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearApiKey() {
            this.apiKey = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER apiKey(String apiKey) {
            Objects.requireNonNull(apiKey);
            this.apiKey = apiKey;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearLogRequests() {
            this.logRequests = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER logRequests(boolean logRequests) {
            Objects.requireNonNull(logRequests);
            this.logRequests = logRequests;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearLogResponses() {
            this.logResponses = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER logResponses(boolean logResponses) {
            Objects.requireNonNull(logResponses);
            this.logResponses = logResponses;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER customHeaders(Map<String, String> customHeaders) {
            Objects.requireNonNull(customHeaders);
            this.customHeaders.clear();
            this.customHeaders.putAll(customHeaders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCustomHeaders(Map<String, String> customHeaders) {
            Objects.requireNonNull(customHeaders);
            this.customHeaders.putAll(customHeaders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putCustomHeader(String key, String customHeader) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(customHeader);
            this.customHeaders.put(key, customHeader);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTimeout() {
            this.timeout = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER timeout(Duration timeout) {
            Objects.requireNonNull(timeout);
            this.timeout = timeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProxy() {
            this.proxy = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER proxy(Proxy proxy) {
            Objects.requireNonNull(proxy);
            this.proxy = proxy;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearOrganizationId() {
            this.organizationId = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER organizationId(String organizationId) {
            Objects.requireNonNull(organizationId);
            this.organizationId = organizationId;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearModelName() {
            this.modelName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER modelName(String modelName) {
            Objects.requireNonNull(modelName);
            this.modelName = modelName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Integer> maxRetries() {
            return Optional.ofNullable(this.maxRetries);
        }

        public Optional<Double> temperature() {
            return Optional.ofNullable(this.temperature);
        }

        public Optional<Tokenizer> tokenizer() {
            return Optional.ofNullable(this.tokenizer);
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Optional<String> baseUrl() {
            return Optional.ofNullable(this.baseUrl);
        }

        public Optional<String> apiKey() {
            return Optional.ofNullable(this.apiKey);
        }

        public Optional<Boolean> logRequests() {
            return Optional.ofNullable(this.logRequests);
        }

        public Optional<Boolean> logResponses() {
            return Optional.ofNullable(this.logResponses);
        }

        public Map<String, String> customHeaders() {
            return this.customHeaders;
        }

        public Optional<Duration> timeout() {
            return Optional.ofNullable(this.timeout);
        }

        public Optional<Proxy> proxy() {
            return Optional.ofNullable(this.proxy);
        }

        public Optional<String> organizationId() {
            return Optional.ofNullable(this.organizationId);
        }

        public Optional<String> modelName() {
            return Optional.ofNullable(this.modelName);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "OpenAiLanguageModelConfigBuilder{maxRetries=" + this.maxRetries + ",temperature=" + this.temperature + ",tokenizer=" + String.valueOf(this.tokenizer) + ",enabled=" + this.enabled + ",baseUrl=" + this.baseUrl + ",apiKey=" + this.apiKey + ",logRequests=" + this.logRequests + ",logResponses=" + this.logResponses + ",customHeaders=" + String.valueOf(this.customHeaders) + ",timeout=" + String.valueOf(this.timeout) + ",proxy=" + String.valueOf(this.proxy) + ",organizationId=" + this.organizationId + ",modelName=" + this.modelName + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER maxRetries(Optional<Integer> maxRetries) {
            Objects.requireNonNull(maxRetries);
            this.maxRetries = maxRetries.map(Integer.class::cast).orElse(this.maxRetries);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER temperature(Optional<Double> temperature) {
            Objects.requireNonNull(temperature);
            this.temperature = temperature.map(Double.class::cast).orElse(this.temperature);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER tokenizer(Optional<? extends Tokenizer> tokenizer) {
            Objects.requireNonNull(tokenizer);
            this.tokenizer = tokenizer.map(Tokenizer.class::cast).orElse(this.tokenizer);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER baseUrl(Optional<String> baseUrl) {
            Objects.requireNonNull(baseUrl);
            this.baseUrl = baseUrl.map(String.class::cast).orElse(this.baseUrl);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER apiKey(Optional<String> apiKey) {
            Objects.requireNonNull(apiKey);
            this.apiKey = apiKey.map(String.class::cast).orElse(this.apiKey);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER logRequests(Optional<Boolean> logRequests) {
            Objects.requireNonNull(logRequests);
            this.logRequests = logRequests.map(Boolean.class::cast).orElse(this.logRequests);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER logResponses(Optional<Boolean> logResponses) {
            Objects.requireNonNull(logResponses);
            this.logResponses = logResponses.map(Boolean.class::cast).orElse(this.logResponses);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER timeout(Optional<? extends Duration> timeout) {
            Objects.requireNonNull(timeout);
            this.timeout = timeout.map(Duration.class::cast).orElse(this.timeout);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER proxy(Optional<? extends Proxy> proxy) {
            Objects.requireNonNull(proxy);
            this.proxy = proxy.map(Proxy.class::cast).orElse(this.proxy);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER organizationId(Optional<String> organizationId) {
            Objects.requireNonNull(organizationId);
            this.organizationId = organizationId.map(String.class::cast).orElse(this.organizationId);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER modelName(Optional<String> modelName) {
            Objects.requireNonNull(modelName);
            this.modelName = modelName.map(String.class::cast).orElse(this.modelName);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class OpenAiLanguageModelConfigImpl
        implements OpenAiLanguageModelConfig {
            private final boolean enabled;
            private final Map<String, String> customHeaders;
            private final Optional<Tokenizer> tokenizer;
            private final Optional<Boolean> logRequests;
            private final Optional<Boolean> logResponses;
            private final Optional<Double> temperature;
            private final Optional<Integer> maxRetries;
            private final Optional<String> apiKey;
            private final Optional<String> baseUrl;
            private final Optional<String> modelName;
            private final Optional<String> organizationId;
            private final Optional<Proxy> proxy;
            private final Optional<Duration> timeout;

            protected OpenAiLanguageModelConfigImpl(BuilderBase<?, ?> builder) {
                this.maxRetries = builder.maxRetries();
                this.temperature = builder.temperature();
                this.tokenizer = builder.tokenizer();
                this.enabled = builder.enabled();
                this.baseUrl = builder.baseUrl();
                this.apiKey = builder.apiKey();
                this.logRequests = builder.logRequests();
                this.logResponses = builder.logResponses();
                this.customHeaders = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.customHeaders()));
                this.timeout = builder.timeout();
                this.proxy = builder.proxy();
                this.organizationId = builder.organizationId();
                this.modelName = builder.modelName();
            }

            @Override
            public Optional<Integer> maxRetries() {
                return this.maxRetries;
            }

            @Override
            public Optional<Double> temperature() {
                return this.temperature;
            }

            @Override
            public Optional<Tokenizer> tokenizer() {
                return this.tokenizer;
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public Optional<String> baseUrl() {
                return this.baseUrl;
            }

            @Override
            public Optional<String> apiKey() {
                return this.apiKey;
            }

            @Override
            public Optional<Boolean> logRequests() {
                return this.logRequests;
            }

            @Override
            public Optional<Boolean> logResponses() {
                return this.logResponses;
            }

            @Override
            public Map<String, String> customHeaders() {
                return this.customHeaders;
            }

            @Override
            public Optional<Duration> timeout() {
                return this.timeout;
            }

            @Override
            public Optional<Proxy> proxy() {
                return this.proxy;
            }

            @Override
            public Optional<String> organizationId() {
                return this.organizationId;
            }

            @Override
            public Optional<String> modelName() {
                return this.modelName;
            }

            public String toString() {
                return "OpenAiLanguageModelConfig{maxRetries=" + String.valueOf(this.maxRetries) + ",temperature=" + String.valueOf(this.temperature) + ",tokenizer=" + String.valueOf(this.tokenizer) + ",enabled=" + this.enabled + ",baseUrl=" + String.valueOf(this.baseUrl) + ",apiKey=" + String.valueOf(this.apiKey) + ",logRequests=" + String.valueOf(this.logRequests) + ",logResponses=" + String.valueOf(this.logResponses) + ",customHeaders=" + String.valueOf(this.customHeaders) + ",timeout=" + String.valueOf(this.timeout) + ",proxy=" + String.valueOf(this.proxy) + ",organizationId=" + String.valueOf(this.organizationId) + ",modelName=" + String.valueOf(this.modelName) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OpenAiLanguageModelConfig)) {
                    return false;
                }
                OpenAiLanguageModelConfig other = (OpenAiLanguageModelConfig)o;
                return Objects.equals(this.maxRetries, other.maxRetries()) && Objects.equals(this.temperature, other.temperature()) && Objects.equals(this.tokenizer, other.tokenizer()) && this.enabled == other.enabled() && Objects.equals(this.baseUrl, other.baseUrl()) && Objects.equals(this.apiKey, other.apiKey()) && Objects.equals(this.logRequests, other.logRequests()) && Objects.equals(this.logResponses, other.logResponses()) && Objects.equals(this.customHeaders, other.customHeaders()) && Objects.equals(this.timeout, other.timeout()) && Objects.equals(this.proxy, other.proxy()) && Objects.equals(this.organizationId, other.organizationId()) && Objects.equals(this.modelName, other.modelName());
            }

            public int hashCode() {
                return Objects.hash(this.maxRetries, this.temperature, this.tokenizer, this.enabled, this.baseUrl, this.apiKey, this.logRequests, this.logResponses, this.customHeaders, this.timeout, this.proxy, this.organizationId, this.modelName);
            }
        }
    }
}

