/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.providers.openai;

import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.openai.OpenAiChatModel;
import io.helidon.common.Weight;
import io.helidon.common.config.Config;
import io.helidon.integrations.langchain4j.providers.openai.OpenAi;
import io.helidon.integrations.langchain4j.providers.openai.OpenAiChatModelConfig;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.net.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@Service.Named(value="*")
@Weight(value=90.0)
@Service.Singleton
public class OpenAiChatModelFactory
implements Service.ServicesFactory<OpenAiChatModel> {
    private final Supplier<Optional<OpenAiChatModel>> model;

    OpenAiChatModelFactory(@Service.Named(value="open-ai.chat-model") Supplier<Optional<Tokenizer>> openAiChatModelTokenizer, @Service.Named(value="open-ai") Supplier<Optional<Tokenizer>> openAiTokenizer, Supplier<Optional<Tokenizer>> tokenizer, @Service.Named(value="open-ai.chat-model") Supplier<Optional<Proxy>> openAiChatModelProxy, @Service.Named(value="open-ai") Supplier<Optional<Proxy>> openAiProxy, Supplier<Optional<Proxy>> proxy, Config config) {
        OpenAiChatModelConfig.Builder configBuilder = (OpenAiChatModelConfig.Builder)OpenAiChatModelConfig.builder().config(config.get("langchain4j.open-ai.chat-model"));
        this.model = () -> OpenAiChatModelFactory.buildModel(configBuilder, openAiChatModelTokenizer, openAiTokenizer, tokenizer, openAiChatModelProxy, openAiProxy, proxy);
    }

    public static OpenAiChatModel create(OpenAiChatModelConfig config) {
        if (!config.enabled()) {
            throw new IllegalStateException("Cannot create a model when the configuration is disabled.");
        }
        OpenAiChatModel.OpenAiChatModelBuilder builder = OpenAiChatModel.builder();
        config.baseUrl().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).baseUrl(arg_0));
        config.apiKey().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).apiKey(arg_0));
        config.organizationId().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).organizationId(arg_0));
        config.modelName().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).modelName(arg_0));
        config.temperature().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).temperature(arg_0));
        config.topP().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).topP(arg_0));
        if (!config.stop().isEmpty()) {
            builder.stop(config.stop());
        }
        config.maxTokens().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).maxTokens(arg_0));
        config.maxCompletionTokens().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).maxCompletionTokens(arg_0));
        config.presencePenalty().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).presencePenalty(arg_0));
        config.frequencyPenalty().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).frequencyPenalty(arg_0));
        if (!config.logitBias().isEmpty()) {
            builder.logitBias(config.logitBias());
        }
        config.responseFormat().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).responseFormat(arg_0));
        config.strictJsonSchema().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).strictJsonSchema(arg_0));
        config.seed().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).seed(arg_0));
        config.user().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).user(arg_0));
        config.strictTools().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).strictTools(arg_0));
        config.parallelToolCalls().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).parallelToolCalls(arg_0));
        config.timeout().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).timeout(arg_0));
        config.maxRetries().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).maxRetries(arg_0));
        config.logRequests().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).logRequests(arg_0));
        config.logResponses().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).logResponses(arg_0));
        config.tokenizer().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).tokenizer(arg_0));
        config.proxy().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).proxy(arg_0));
        if (!config.customHeaders().isEmpty()) {
            builder.customHeaders(config.customHeaders());
        }
        return builder.build();
    }

    public List<Service.QualifiedInstance<OpenAiChatModel>> services() {
        Optional<OpenAiChatModel> modelOptional = this.model.get();
        if (modelOptional.isEmpty()) {
            return List.of();
        }
        OpenAiChatModel theModel = modelOptional.get();
        return List.of(Service.QualifiedInstance.create((Object)theModel, (Qualifier[])new Qualifier[0]), Service.QualifiedInstance.create((Object)theModel, (Qualifier[])new Qualifier[]{OpenAi.OPEN_AI_QUALIFIER}));
    }

    private static Optional<OpenAiChatModel> buildModel(OpenAiChatModelConfig.Builder configBuilder, Supplier<Optional<Tokenizer>> openAiModelTokenizer, Supplier<Optional<Tokenizer>> openAiTokenizer, Supplier<Optional<Tokenizer>> tokenizer, Supplier<Optional<Proxy>> openAiModelProxy, Supplier<Optional<Proxy>> openAiProxy, Supplier<Optional<Proxy>> proxy) {
        if (!configBuilder.enabled()) {
            return Optional.empty();
        }
        openAiModelTokenizer.get().or(openAiTokenizer).or(tokenizer).ifPresent(configBuilder::tokenizer);
        openAiModelProxy.get().or(openAiProxy).or(proxy).ifPresent(configBuilder::proxy);
        return Optional.of(OpenAiChatModelFactory.create(configBuilder.build()));
    }
}

