/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.testing.junit5;

import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class OptionalMatcher {
    private OptionalMatcher() {
    }

    public static <T> Matcher<Optional<T>> optionalValue(Matcher<? super T> matcher) {
        return new WithValue<T>(matcher);
    }

    public static <T> Matcher<Optional<T>> optionalEmpty() {
        return new Empty();
    }

    public static <T> Matcher<Optional<T>> optionalPresent() {
        return new WithValue(Matchers.any(Object.class));
    }

    private static class WithValue<T>
    extends TypeSafeMatcher<Optional<T>> {
        private final Matcher<? super T> matcher;

        WithValue(Matcher<? super T> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Optional<T> item) {
            return item.map(arg_0 -> this.matcher.matches(arg_0)).orElse(false);
        }

        public void describeTo(Description description) {
            description.appendText("not empty Optional, and value ");
            description.appendDescriptionOf(this.matcher);
        }

        protected void describeMismatchSafely(Optional<T> item, Description mismatchDescription) {
            if (item.isPresent()) {
                mismatchDescription.appendText("not empty Optional, and value ");
                this.matcher.describeMismatch(item.get(), mismatchDescription);
            } else {
                mismatchDescription.appendText("is empty");
            }
        }
    }

    private static class Empty<T>
    extends TypeSafeMatcher<Optional<T>> {
        private Empty() {
        }

        protected boolean matchesSafely(Optional<T> item) {
            return item.isEmpty();
        }

        public void describeTo(Description description) {
            description.appendText("empty Optional");
        }

        protected void describeMismatchSafely(Optional<T> item, Description mismatchDescription) {
            if (item.isPresent()) {
                mismatchDescription.appendText("not empty Optional, and value is ");
                mismatchDescription.appendValue(item.get());
            }
        }
    }
}

