/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.testing.junit5;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class LogRecordMatcher {
    private static final Formatter SIMPLE_LOG_FORMATTER = new SimpleFormatter();

    public static Matcher<LogRecord> withThrown(Matcher<? super Throwable> matcher) {
        return new WithThrown(matcher);
    }

    public static Matcher<LogRecord> withMessage(Matcher<? super String> matcher) {
        return new WithMessage(matcher);
    }

    private LogRecordMatcher() {
    }

    private static String logRecordToString(LogRecord logRecord) {
        return SIMPLE_LOG_FORMATTER.format(logRecord);
    }

    private static class WithThrown
    extends TypeSafeMatcher<LogRecord> {
        private final Matcher<? super Throwable> matcher;

        WithThrown(Matcher<? super Throwable> matcher) {
            this.matcher = matcher;
        }

        protected void describeMismatchSafely(LogRecord item, Description mismatchDescription) {
            mismatchDescription.appendText("log record ");
            this.matcher.describeMismatch((Object)LogRecordMatcher.logRecordToString(item), mismatchDescription);
        }

        public void describeTo(Description description) {
            description.appendText("log record with thrown ");
            description.appendDescriptionOf(this.matcher);
        }

        protected boolean matchesSafely(LogRecord item) {
            return this.matcher.matches((Object)item.getThrown());
        }
    }

    private static class WithMessage
    extends TypeSafeMatcher<LogRecord> {
        private final Matcher<? super String> matcher;

        WithMessage(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(LogRecord item) {
            return this.matcher.matches((Object)item.getMessage());
        }

        protected void describeMismatchSafely(LogRecord item, Description mismatchDescription) {
            mismatchDescription.appendText("log record ");
            this.matcher.describeMismatch((Object)LogRecordMatcher.logRecordToString(item), mismatchDescription);
        }

        public void describeTo(Description description) {
            description.appendText("log record with message ");
            description.appendDescriptionOf(this.matcher);
        }
    }
}

