/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UserServlet
extends HttpServlet {
    private static final long serialVersionUID = -1239510748236245667L;
    private static final String DEFAULT_USER = "public";
    protected AuthenticationConfiguration authConfiguration;

    public void init() throws ServletException {
        this.authConfiguration = AuthenticationConfiguration.getConfiguration(this.getServletContext());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.authConfiguration.isEnabled()) {
            ServletHelpers.sendJSONResponse(response, this.wrapQuote(DEFAULT_USER));
            return;
        }
        String username = this.getUsername(request, response);
        if (username == null) {
            ServletHelpers.doForbidden(response);
            return;
        }
        ServletHelpers.sendJSONResponse(response, this.wrapQuote(username));
    }

    private String wrapQuote(String str) {
        return "\"" + str + "\"";
    }

    protected String getUsername(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        if (AuthSessionHelpers.isSpringSecurityEnabled()) {
            return request.getRemoteUser();
        }
        return (String)session.getAttribute("user");
    }
}

