/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.xhtml.internal.styles;

import fr.opensagres.poi.xwpf.converter.core.Color;
import fr.opensagres.poi.xwpf.converter.core.TableHeight;
import fr.opensagres.poi.xwpf.converter.core.TableWidth;
import fr.opensagres.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import fr.opensagres.poi.xwpf.converter.core.utils.StringUtils;
import fr.opensagres.poi.xwpf.converter.core.utils.XWPFUtils;
import fr.opensagres.poi.xwpf.converter.xhtml.internal.styles.CSSStyle;
import fr.opensagres.poi.xwpf.converter.xhtml.internal.utils.SAXHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTextDirection;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CSSStylesDocument
extends XWPFStylesDocument {
    private static final String CR = "\n";
    private static final String PT_UNIT = "pt";
    private static final Object PERCENT_UNIT = "%";
    private List<CSSStyle> cssStyles;
    private final boolean ignoreStylesIfUnused;
    private final Integer indent;

    public CSSStylesDocument(XWPFDocument document, boolean ignoreStylesIfUnused, Integer indent) throws XmlException, IOException {
        super(document, false);
        this.ignoreStylesIfUnused = ignoreStylesIfUnused;
        this.indent = indent;
        this.initialize();
    }

    protected void initialize() throws XmlException, IOException {
        CSSStyle defaultPStyle = new CSSStyle("p", null);
        defaultPStyle.addProperty("margin-top", "0pt");
        defaultPStyle.addProperty("margin-bottom", "1pt");
        this.getCSSStyles().add(defaultPStyle);
        super.initialize();
    }

    protected void visitStyle(CTStyle style, boolean defaultStyle) {
        String styleId = style.getStyleId();
        if (StringUtils.isNotEmpty((String)styleId)) {
            String className = this.getClassName(styleId);
            this.visitStyle(className, style.getPPr(), defaultStyle);
            this.visitStyle(className, style.getRPr(), defaultStyle);
            this.visitStyle(className, style.getTblPr(), defaultStyle);
            this.visitStyle(className, style.getTrPr(), defaultStyle);
            this.visitStyle(className, style.getTcPr(), defaultStyle);
        }
    }

    private void visitStyle(String className, CTPPr pPr, boolean defaultStyle) {
        CSSStyle style = this.createCSSStyle(pPr, className);
        if (style != null) {
            this.getCSSStyles().add(style);
        }
    }

    public CSSStyle createCSSStyle(CTPPr pPr) {
        return this.createCSSStyle(pPr, null);
    }

    public CSSStyle createCSSStyle(CTPPr pPr, String className) {
        if (pPr != null) {
            Color backgroundColor;
            Float spacingAfter;
            Float spacingBefore;
            ParagraphAlignment alignment;
            Float indentationFirstLine;
            Float indentationRight;
            String tagName = "p";
            CSSStyle style = this.ignoreStylesIfUnused ? null : this.getOrCreateStyle(null, tagName, className);
            Float indentationLeft = super.getIndentationLeft(pPr);
            if (indentationLeft != null) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("margin-left", this.getValueAsPoint(indentationLeft.floatValue()));
            }
            if ((indentationRight = super.getIndentationRight(pPr)) != null) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("margin-right", this.getValueAsPoint(indentationRight.floatValue()));
            }
            if ((indentationFirstLine = super.getIndentationFirstLine(pPr)) != null) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("text-indent", this.getValueAsPoint(indentationFirstLine.floatValue()));
            }
            if ((alignment = super.getParagraphAlignment(pPr)) != null) {
                switch (alignment) {
                    case LEFT: {
                        style = this.getOrCreateStyle(style, tagName, className);
                        style.addProperty("text-align", "left");
                        break;
                    }
                    case RIGHT: {
                        style = this.getOrCreateStyle(style, tagName, className);
                        style.addProperty("text-align", "right");
                        break;
                    }
                    case CENTER: {
                        style = this.getOrCreateStyle(style, tagName, className);
                        style.addProperty("text-align", "center");
                        break;
                    }
                    case BOTH: {
                        style = this.getOrCreateStyle(style, tagName, className);
                        style.addProperty("text-align", "justified");
                    }
                }
            }
            if ((spacingBefore = super.getSpacingBefore(pPr)) != null) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("margin-top", this.getValueAsPoint(spacingBefore.floatValue()));
            }
            if ((spacingAfter = super.getSpacingAfter(pPr)) != null) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("margin-bottom", this.getValueAsPoint(spacingAfter.floatValue()));
            }
            if ((backgroundColor = super.getBackgroundColor(pPr)) != null) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("background-color", XWPFUtils.toHexString((Color)backgroundColor));
            }
            return style;
        }
        return null;
    }

    private void visitStyle(String className, CTRPr rPr, boolean defaultStyle) {
        CSSStyle style = this.createCSSStyle(rPr, className);
        if (style != null) {
            this.getCSSStyles().add(style);
        }
    }

    public CSSStyle createCSSStyle(CTRPr rPr) {
        return this.createCSSStyle(rPr, null);
    }

    public CSSStyle createCSSStyle(CTRPr rPr, String className) {
        if (rPr != null) {
            Color backgroundColor;
            UnderlinePatterns underlinePatterns;
            Color fontColor;
            Boolean italic;
            Boolean bold;
            Float fontSize;
            String tagName = "span";
            CSSStyle style = this.ignoreStylesIfUnused ? null : this.getOrCreateStyle(null, tagName, className);
            String fontFamily = super.getFontFamilyAscii(rPr);
            if (StringUtils.isNotEmpty((String)fontFamily)) {
                fontFamily = "'" + fontFamily + "'";
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("font-family", fontFamily);
            }
            if ((fontSize = super.getFontSize(rPr)) != null) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("font-size", this.getValueAsPoint(fontSize.floatValue()));
            }
            if ((bold = super.getFontStyleBold(rPr)) != null && bold.booleanValue()) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("font-weight", "bold");
            }
            if ((italic = super.getFontStyleItalic(rPr)) != null && italic.booleanValue()) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("font-style", "italic");
            }
            if ((fontColor = super.getFontColor(rPr)) != null) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("color", XWPFUtils.toHexString((Color)fontColor));
            }
            if ((underlinePatterns = super.getUnderline(rPr)) != null) {
                switch (underlinePatterns) {
                    case SINGLE: {
                        style = this.getOrCreateStyle(style, tagName, className);
                        style.addProperty("text-decoration", "underline");
                        break;
                    }
                }
            }
            if ((backgroundColor = super.getBackgroundColor(rPr)) != null) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("background-color", XWPFUtils.toHexString((Color)backgroundColor));
            }
            return style;
        }
        return null;
    }

    private void visitStyle(String className, CTTblPrBase tblPr, boolean defaultStyle) {
        CSSStyle style = this.createCSSStyle(tblPr, className);
        if (style != null) {
            this.getCSSStyles().add(style);
        }
    }

    public CSSStyle createCSSStyle(CTTblPrBase tblPr) {
        return this.createCSSStyle(tblPr, null);
    }

    public CSSStyle createCSSStyle(CTTblPrBase tblPr, String className) {
        if (tblPr != null) {
            String tagName = "table";
            CSSStyle style = this.ignoreStylesIfUnused ? null : this.getOrCreateStyle(null, tagName, className);
            TableWidth tableWidth = super.getTableWidth(tblPr);
            if (tableWidth != null && tableWidth.width > 0.0f) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("width", this.getStyleWidth(tableWidth));
            }
            return style;
        }
        return null;
    }

    private String getStyleWidth(TableWidth tableWidth) {
        return tableWidth.percentUnit ? this.getValueAsPercent(tableWidth.width) : this.getValueAsPoint(tableWidth.width);
    }

    private void visitStyle(String className, CTTrPr trPr, boolean defaultStyle) {
        CSSStyle style = this.createCSSStyle(trPr, className);
        if (style != null) {
            this.getCSSStyles().add(style);
        }
    }

    public CSSStyle createCSSStyle(CTTrPr trPr) {
        return this.createCSSStyle(trPr, null);
    }

    public CSSStyle createCSSStyle(CTTrPr trPr, String className) {
        if (trPr != null) {
            String tagName = "tr";
            CSSStyle style = this.ignoreStylesIfUnused ? null : this.getOrCreateStyle(null, tagName, className);
            TableHeight tableHeight = super.getTableRowHeight(trPr);
            if (tableHeight != null) {
                if (tableHeight.minimum) {
                    style = this.getOrCreateStyle(style, tagName, className);
                    style.addProperty("min-height", this.getValueAsPoint(tableHeight.height));
                } else {
                    style = this.getOrCreateStyle(style, tagName, className);
                    style.addProperty("height", this.getValueAsPoint(tableHeight.height));
                }
            }
            return style;
        }
        return null;
    }

    private void visitStyle(String className, CTTcPr tcPr, boolean defaultStyle) {
        CSSStyle style = this.createCSSStyle(tcPr, className);
        if (style != null) {
            this.getCSSStyles().add(style);
        }
    }

    public CSSStyle createCSSStyle(CTTcPr tcPr) {
        return this.createCSSStyle(tcPr, null);
    }

    public CSSStyle createCSSStyle(CTTcPr tcPr, String className) {
        if (tcPr != null) {
            CTTextDirection direction;
            Color backgroundColor;
            String tagName = "td";
            CSSStyle style = this.ignoreStylesIfUnused ? null : this.getOrCreateStyle(null, tagName, className);
            TableWidth cellWidth = super.getTableCellWith(tcPr);
            if (cellWidth != null) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("width", this.getStyleWidth(cellWidth));
            }
            if ((backgroundColor = super.getTableCellBackgroundColor(tcPr)) != null) {
                style = this.getOrCreateStyle(style, tagName, className);
                style.addProperty("background-color", XWPFUtils.toHexString((Color)backgroundColor));
            }
            if ((direction = super.getTextDirection(tcPr)) != null) {
                int dir = direction.getVal().intValue();
                switch (dir) {
                    case 3: {
                        style = this.getOrCreateStyle(style, tagName, className);
                        style.addProperty("-webkit-transform", "rotate(270deg)");
                        style.addProperty("-moz-transform", "rotate(270deg)");
                        style.addProperty("-o-transform", "rotate(270deg)");
                        style.addProperty("writing-mode", "bt-lr");
                        break;
                    }
                    case 2: {
                        style = this.getOrCreateStyle(style, tagName, className);
                        style.addProperty("-webkit-transform", "rotate(90deg)");
                        style.addProperty("-moz-transform", "rotate(90deg)");
                        style.addProperty("-o-transform", "rotate(90deg)");
                        style.addProperty("writing-mode", "tb-rl");
                    }
                }
            }
            return style;
        }
        return null;
    }

    public List<CSSStyle> getCSSStyles() {
        if (this.cssStyles == null) {
            this.cssStyles = new ArrayList<CSSStyle>();
        }
        return this.cssStyles;
    }

    public void save(ContentHandler contentHandler) throws SAXException {
        List<CSSStyle> cssStyles = this.getCSSStyles();
        if (this.ignoreStylesIfUnused && cssStyles.size() < 1) {
            return;
        }
        SAXHelper.startElement(contentHandler, "style", null);
        for (CSSStyle style : cssStyles) {
            if (this.indent != null) {
                SAXHelper.characters(contentHandler, CR);
            }
            style.save(contentHandler);
        }
        SAXHelper.endElement(contentHandler, "style");
    }

    public String getValueAsPoint(float value) {
        return String.valueOf(value) + PT_UNIT;
    }

    private String getValueAsPercent(float value) {
        return String.valueOf(value) + PERCENT_UNIT;
    }

    public String getClassNames(String styleID) {
        if (StringUtils.isEmpty((String)styleID)) {
            return null;
        }
        StringBuilder classNames = new StringBuilder(this.getClassName(styleID));
        CTStyle style = super.getStyle(styleID);
        while (style != null) {
            if ((style = super.getStyle(style.getBasedOn())) == null) continue;
            classNames.insert(0, this.getClassName(style.getStyleId(), true));
        }
        return classNames.toString();
    }

    private String getClassName(String styleId) {
        return this.getClassName(styleId, false);
    }

    private String getClassName(String styleId, boolean spaceAfter) {
        StringBuilder className = new StringBuilder();
        char firstChar = styleId.charAt(0);
        if (Character.isDigit(firstChar)) {
            className.append('X').toString();
        }
        if (spaceAfter) {
            return className.append(styleId).append(' ').toString();
        }
        return className.append(styleId).toString();
    }

    private CSSStyle getOrCreateStyle(CSSStyle style, String tagName, String className) {
        if (style != null) {
            return style;
        }
        return new CSSStyle(tagName, className);
    }
}

