/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.rpc.mgr.icbc;

import com.google.gson.Gson;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.suwell.rpc.mgr.icbc.ICBCResult;
import com.suwell.rpc.mgr.icbc.InParams;
import com.suwell.rpc.mgr.model.api.ApiParams;
import com.suwell.rpc.mgr.model.api.Signature;
import com.suwell.rpc.mgr.utils.CustomJsonParser;
import com.suwell.rpc.mgr.utils.Utils;
import com.suwell.sdk.invoice.Consumer;
import com.suwell.sdk.invoice.Extend;
import com.suwell.sdk.invoice.InvoiceHelper;
import com.suwell.sdk.invoice.Reply;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuwellOfdFileUtils {
    private static final int NOT_FOUND = -1;
    public static final char EXTENSION_SEPARATOR = '.';
    public static final char UNIX_SEPARATOR = '/';
    public static final char WINDOWS_SEPARATOR = '\\';
    private static SAXParserFactory factory = SAXParserFactory.newInstance();
    private static Logger log = LoggerFactory.getLogger(SuwellOfdFileUtils.class);
    private static final String FINFO_TPL = "!CDATA<Item Font=\"\u5b8b\u4f53\" FontSize=\"9\" Weight=\"900\">{0}</Item><Item>{1}</Item>";
    private static URL url;
    private static final String ENVELOPE = "envelope";
    static final String X2Y_URL = "x2y/convert";
    static final String UP_EAP = "tpl/icbc";
    static final String ACTION = "tpl/icbc/compound";
    public static final String SSI = "sealInfo";
    private static Consumer consumer;
    static Gson gson;

    private SuwellOfdFileUtils() {
    }

    public static void init(URL serverURL, int maxLockCount) {
        url = serverURL;
        consumer = new Consumer(serverURL.toString(), maxLockCount);
    }

    public static void destroy() {
        if (consumer != null) {
            consumer.shutdown();
        }
    }

    private static void check(InParams inParams) {
        if (inParams == null) {
            throw new NullPointerException("inParams = null");
        }
        if (inParams.datas == null || inParams.datas.isEmpty()) {
            throw new NullPointerException("inParams.datas = null");
        }
        if (inParams.tplId == null) {
            throw new NullPointerException("inParams.tplId = null");
        }
    }

    private static List<NameValuePair> assemble(InParams inParams, String methodName) {
        ArrayList<NameValuePair> bnvps = new ArrayList<NameValuePair>();
        String[] datas = new String[inParams.datas.size()];
        int i = 0;
        for (Map<String, Object> map : inParams.datas) {
            SuwellOfdFileUtils.revise(map);
            datas[i++] = gson.toJson(map);
        }
        Extend eel = new Extend();
        if (inParams.es != null && inParams.es.size() > 0) {
            for (Extend.EleSeal e : inParams.es) {
                eel.setEleSeals(e);
            }
        }
        if (inParams.envelope != null) {
            eel.setEnvelope(inParams.envelope);
        }
        eel.setMethod(methodName);
        for (String data : datas) {
            bnvps.add((NameValuePair)new BasicNameValuePair("data", new CustomJsonParser().parse(data).asXML()));
        }
        if (datas.length == 1) {
            bnvps.add((NameValuePair)new BasicNameValuePair("data", ""));
        }
        bnvps.add((NameValuePair)new BasicNameValuePair("id", inParams.tplId));
        if ("pdf".equals(inParams.format.toLowerCase())) {
            eel.setResultType(Extend.createPDFResultType());
        }
        bnvps.add((NameValuePair)new BasicNameValuePair("extend", gson.toJson((Object)eel)));
        return bnvps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICBCResult create(InParams inParams, String fileName) {
        try {
            SuwellOfdFileUtils.check(inParams);
            List<NameValuePair> bnvps = SuwellOfdFileUtils.assemble(inParams, "create");
            String[] ret = consumer.post(ACTION, bnvps);
            Reply reply = (Reply)gson.fromJson(ret[0], Reply.class);
            if (reply.getCode() != 0) {
                log.error(reply.getMsg());
                return new ICBCResult(1, reply.getMsg());
            }
            log.info("name = {}", (Object)reply.getName());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName));
            try {
                InvoiceHelper.copy(consumer.down(ACTION, reply.getName(), ret[1]), out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return new ICBCResult(1, e.getMessage());
        }
        return new ICBCResult(0, "succeed");
    }

    public static ICBCResult batchCreateUpEAP(InParams inParams, String fileName, boolean pkg, String ... params) {
        if (params == null || params.length == 0) {
            return new ICBCResult(1, "params = null");
        }
        try {
            SuwellOfdFileUtils.check(inParams);
            List<NameValuePair> bnvps = SuwellOfdFileUtils.assemble(inParams, "batchCreateUpEAP");
            bnvps.add((NameValuePair)new BasicNameValuePair("target", fileName));
            bnvps.add((NameValuePair)new BasicNameValuePair("pkg", String.valueOf(pkg)));
            for (String param : params) {
                bnvps.add((NameValuePair)new BasicNameValuePair("params", param));
            }
            String[] ret = consumer.post(UP_EAP, bnvps);
            Reply reply = (Reply)gson.fromJson(ret[0], Reply.class);
            if (reply.getCode() != 0) {
                log.error(reply.getMsg());
                return new ICBCResult(1, reply.getMsg());
            }
            return new ICBCResult(0, reply.getMsg());
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return new ICBCResult(1, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICBCResult batchCreatePack(InParams inParams, String filePath) {
        try {
            SuwellOfdFileUtils.check(inParams);
            List<NameValuePair> bnvps = SuwellOfdFileUtils.assemble(inParams, "batchCreatePack");
            bnvps.add((NameValuePair)new BasicNameValuePair("target", "pack.zip"));
            bnvps.add((NameValuePair)new BasicNameValuePair("pkg", String.valueOf(true)));
            bnvps.add((NameValuePair)new BasicNameValuePair("up", String.valueOf(false)));
            String[] ret = consumer.post(UP_EAP, bnvps);
            Reply reply = (Reply)gson.fromJson(ret[0], Reply.class);
            if (reply.getCode() != 0) {
                log.error(reply.getMsg());
                return new ICBCResult(1, reply.getMsg());
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filePath));
            try {
                InvoiceHelper.copy(consumer.down(UP_EAP, reply.getName(), ret[1]), out);
            }
            finally {
                ((OutputStream)out).close();
            }
            return new ICBCResult(0, "succeed");
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return new ICBCResult(1, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICBCResult batchCollectCreatePack(InParams inParams, String filePath, String itemPath) {
        try {
            SuwellOfdFileUtils.check(inParams);
            List<NameValuePair> bnvps = SuwellOfdFileUtils.assemble(inParams, "batchCollectCreatePack");
            bnvps.add((NameValuePair)new BasicNameValuePair("pkg", String.valueOf(true)));
            bnvps.add((NameValuePair)new BasicNameValuePair("target", "pack.zip"));
            bnvps.add((NameValuePair)new BasicNameValuePair("itemPath", itemPath));
            bnvps.add((NameValuePair)new BasicNameValuePair("up", String.valueOf(false)));
            bnvps.add((NameValuePair)new BasicNameValuePair("collect", "true"));
            String[] ret = consumer.post(UP_EAP, bnvps);
            Reply reply = (Reply)gson.fromJson(ret[0], Reply.class);
            if (reply.getCode() != 0) {
                log.error(reply.getMsg());
                return new ICBCResult(1, reply.getMsg());
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filePath));
            try {
                InvoiceHelper.copy(consumer.down(UP_EAP, reply.getName(), ret[1]), out);
            }
            finally {
                ((OutputStream)out).close();
            }
            return new ICBCResult(0, "succeed");
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return new ICBCResult(1, e.getMessage());
        }
    }

    public static ICBCResult batchCollectCreateUpEap(InParams inParams, boolean pkg, String fileName, String itemPath, String ... params) {
        if (params == null || params.length == 0) {
            return new ICBCResult(1, "params = null");
        }
        try {
            SuwellOfdFileUtils.check(inParams);
            List<NameValuePair> bnvps = SuwellOfdFileUtils.assemble(inParams, "batchCollectCreateUpEap");
            bnvps.add((NameValuePair)new BasicNameValuePair("pkg", String.valueOf(pkg)));
            bnvps.add((NameValuePair)new BasicNameValuePair("target", fileName));
            bnvps.add((NameValuePair)new BasicNameValuePair("itemPath", itemPath));
            for (String param : params) {
                bnvps.add((NameValuePair)new BasicNameValuePair("params", param));
            }
            bnvps.add((NameValuePair)new BasicNameValuePair("collect", "true"));
            String[] ret = consumer.post(UP_EAP, bnvps);
            Reply reply = (Reply)gson.fromJson(ret[0], Reply.class);
            if (reply.getCode() != 0) {
                log.error(reply.getMsg());
                return new ICBCResult(1, reply.getMsg());
            }
            return new ICBCResult(0, reply.getMsg());
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return new ICBCResult(1, e.getMessage());
        }
    }

    public static ICBCResult encryptCreate(InParams inParams, String qrPath) {
        try {
            SuwellOfdFileUtils.check(inParams);
            List<NameValuePair> bnvps = SuwellOfdFileUtils.assemble(inParams, "encryptCreate");
            bnvps.add((NameValuePair)new BasicNameValuePair("target", ENVELOPE));
            String[] ret = consumer.post(ACTION, bnvps);
            Reply reply = (Reply)gson.fromJson(ret[0], Reply.class);
            if (reply.getCode() != 0) {
                log.error(reply.getMsg());
                return new ICBCResult(1, reply.getMsg());
            }
            log.info("name = {}", (Object)reply.getName());
            String path = url + "/".concat("tpl/compound").concat("/envelope") + "?delete=false&name=" + reply.getName();
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            hints.put(EncodeHintType.MARGIN, 1);
            BitMatrix bitMatrix = new QRCodeWriter().encode(path, BarcodeFormat.QR_CODE, 128, 128, hints);
            MatrixToImageWriter.writeToFile((BitMatrix)bitMatrix, (String)"png", (File)new File(qrPath));
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return new ICBCResult(1, e.getMessage());
        }
        return new ICBCResult(0, "succeed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICBCResult ofdSealAndEncrypt(String ofd, String targetFilePath, Extend.Envelope envelope, Extend.EleSeal seal) {
        Reply reply;
        String[] ret;
        FileInputStream in;
        block9: {
            log.info("start ofdSealAndEncrypt template = {}", (Object)ofd);
            in = null;
            Extend eel = new Extend();
            eel.setMethod("ofdSealAndEncrypt");
            eel.setEleSeals(seal);
            MultipartEntityBuilder meb = MultipartEntityBuilder.create();
            in = new FileInputStream(ofd);
            meb.addPart("file", (ContentBody)new InputStreamBody((InputStream)in, ContentType.DEFAULT_BINARY, "file"));
            eel.setEnvelope(envelope);
            meb.addTextBody("extend", gson.toJson((Object)eel));
            ret = consumer.post(X2Y_URL.concat("/".concat("operate")), meb.build());
            reply = (Reply)gson.fromJson(ret[0], Reply.class);
            if (reply.getCode() == 0) break block9;
            log.error(reply.getMsg());
            ICBCResult iCBCResult = new ICBCResult(1, reply.getMsg());
            IOUtils.closeQuietly((Closeable)in);
            return iCBCResult;
        }
        try {
            log.info("name = {}", (Object)reply.getName());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFilePath));
            try {
                InvoiceHelper.copy(consumer.down(ACTION, reply.getName(), ret[1]), out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Throwable e) {
            try {
                log.error(e.getMessage(), e);
                ICBCResult iCBCResult = new ICBCResult(1, e.getMessage());
                return iCBCResult;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        return new ICBCResult(0, "succeed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICBCResult transfer(String originFilePath, String targetFilePath) {
        String souFormat = SuwellOfdFileUtils.getExtension(originFilePath).toLowerCase().trim();
        String tarFormat = SuwellOfdFileUtils.getExtension(targetFilePath).toLowerCase().trim();
        try {
            Extend.ResultType ert = null;
            boolean zip = false;
            if ("ofd".equals(tarFormat)) {
                ert = Extend.createOFDResultType();
            } else if ("pdf".equals(tarFormat)) {
                ert = Extend.createPDFResultType();
            } else if ("jpg".contains(tarFormat)) {
                ert = Extend.createImageResultType(Extend.ImageType.jpg);
                zip = true;
            } else if ("html".equals(tarFormat)) {
                ert = Extend.createImageResultType(Extend.ImageType.html);
                zip = true;
            } else {
                log.warn("target type {} inoperative !", (Object)tarFormat);
            }
            String[] ret = originFilePath.startsWith("http") ? SuwellOfdFileUtils.x2y(null, originFilePath, "transfer", ert) : SuwellOfdFileUtils.x2y(new FileInputStream(originFilePath), souFormat, "transfer", ert);
            if (ret == null) {
                log.error("result is null ");
                return new ICBCResult(1, "result is null ");
            }
            Reply reply = (Reply)gson.fromJson(ret[0], Reply.class);
            if (reply.getCode() != 0) {
                log.error(reply.getMsg());
                return new ICBCResult(1, reply.getMsg());
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFilePath + (zip ? ".zip" : "")));
            try {
                InvoiceHelper.copy(consumer.down(ACTION, reply.getName(), ret[1]), out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new ICBCResult(1, e.getMessage());
        }
        return new ICBCResult(0, "succeed");
    }

    private static void revise(Map<String, Object> data) {
        Object ebillKeyImg;
        String finfo = String.valueOf(data.remove("finfo"));
        if (finfo != null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            SuwellOfdFileUtils.parseXML(finfo, map);
            int i = 1;
            for (Map.Entry entry : map.entrySet()) {
                data.put("finfo" + i++, MessageFormat.format(FINFO_TPL, ((String)entry.getKey()).concat(":"), entry.getValue()));
            }
        }
        if ((ebillKeyImg = data.get("ebillKeyImg")) != null && ebillKeyImg instanceof byte[]) {
            byte[] bs = (byte[])ebillKeyImg;
            String base64 = Base64.encode(bs);
            data.put("ebillKeyImg", base64);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] x2y(InputStream in, String sf, String method, Extend.ResultType ... formats) throws Exception {
        if (sf == null || sf.length() == 0) {
            log.error("src file format is null !");
            return null;
        }
        try {
            MultipartEntityBuilder meb = MultipartEntityBuilder.create();
            if (in != null) {
                meb.addPart("file", (ContentBody)new InputStreamBody(in, ContentType.DEFAULT_BINARY, "file"));
            } else {
                meb.addPart("file", (ContentBody)new InputStreamBody((InputStream)new ByteArrayInputStream(new byte[]{1}), ContentType.DEFAULT_BINARY, "file"));
            }
            meb.addTextBody("sFormat", sf);
            meb.addTextBody("extend", gson.toJson((Object)new Extend().setMethod(method).setResultType(formats)));
            String[] stringArray = consumer.post(X2Y_URL, meb.build());
            return stringArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    static void parseXML(String str, Map<String, String> map) {
        String SIGNL = "<";
        String SIGNR = ">";
        String SPLI = "/";
        int startSignL = str.indexOf(SIGNL);
        int startSignR = str.indexOf(SIGNR);
        int endSignL = str.indexOf(SIGNL + SPLI, startSignR);
        int endSignR = str.indexOf(SIGNR, endSignL);
        int spli = str.indexOf(SPLI);
        if (startSignL != -1 && startSignR != -1 && endSignL != -1 && endSignR != -1 && startSignL + 1 != spli) {
            String head = str.substring(startSignL + 1, startSignR);
            String value = str.substring(startSignR + 1, endSignL);
            if (value.indexOf(SIGNL) != -1 && value.indexOf(SIGNR) != -1) {
                SuwellOfdFileUtils.parseXML(str.substring(startSignR + 1), map);
            } else {
                map.put(head, value.trim());
                SuwellOfdFileUtils.parseXML(str.substring(endSignR + 1), map);
            }
        }
    }

    static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = SuwellOfdFileUtils.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = SuwellOfdFileUtils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICBCResult signature(String file, String targetFilePath, Signature ... signature) {
        String[] ret;
        Reply reply;
        FileInputStream in;
        block13: {
            in = null;
            Extend eel = new Extend();
            eel.setMethod("signature");
            MultipartEntityBuilder meb = MultipartEntityBuilder.create();
            in = new FileInputStream(file);
            meb.addPart("file", (ContentBody)new InputStreamBody((InputStream)in, ContentType.DEFAULT_BINARY, "file"));
            String format = "ofd";
            try {
                format = file.substring(file.lastIndexOf(".")).toLowerCase();
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
            meb.addTextBody("sFormat", format);
            if (signature != null && signature.length > 0) {
                ApiParams apiParams = new ApiParams();
                for (Signature s : signature) {
                    apiParams.addParams(s);
                }
                meb.addTextBody("extend", gson.toJson((Object)apiParams));
            }
            if ((reply = (Reply)gson.fromJson((ret = consumer.post("api", meb.build()))[0], Reply.class)).getCode() == 0) break block13;
            log.error(reply.getMsg());
            ICBCResult iCBCResult = new ICBCResult(1, reply.getMsg());
            IOUtils.closeQuietly((Closeable)in);
            return iCBCResult;
        }
        try {
            log.info("name = {}", (Object)reply.getName());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFilePath));
            try {
                InvoiceHelper.copy(consumer.down(X2Y_URL, reply.getName(), ret[1]), out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Throwable e) {
            try {
                log.error(e.getMessage(), e);
                ICBCResult iCBCResult = new ICBCResult(1, e.getMessage());
                return iCBCResult;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        return new ICBCResult(0, "succeed");
    }

    static {
        gson = Utils.gainGson();
    }
}

