/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.rpc.mgr.common;

import com.google.gson.Gson;
import com.suwell.rpc.mgr.common.CompoundResult;
import com.suwell.rpc.mgr.common.TemplateInfo;
import com.suwell.rpc.mgr.utils.Utils;
import com.suwell.sdk.invoice.Consumer;
import com.suwell.sdk.invoice.Extend;
import com.suwell.sdk.invoice.InvoiceHelper;
import com.suwell.sdk.invoice.Reply;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUtils {
    private static final int NOT_FOUND = -1;
    public static final char EXTENSION_SEPARATOR = '.';
    public static final char UNIX_SEPARATOR = '/';
    public static final char WINDOWS_SEPARATOR = '\\';
    private static SAXParserFactory factory = SAXParserFactory.newInstance();
    private static Logger log = LoggerFactory.getLogger(TemplateUtils.class);
    private static final String FINFO_TPL = "!CDATA<Item Font=\"\u5b8b\u4f53\" FontSize=\"9\" Weight=\"900\">{0}</Item><Item>{1}</Item>";
    private static URL url;
    private static final String ENVELOPE = "envelope";
    static final String DOWN = "/tpl/compound";
    static final String PATH = "/tpl/compound/multiple";
    private static Consumer consumer;
    static Gson gson;

    private TemplateUtils() {
    }

    public static void init(URL serverURL, int maxLockCount) {
        url = serverURL;
        consumer = new Consumer(serverURL.toString(), maxLockCount);
    }

    public static void destroy() {
        if (consumer != null) {
            consumer.shutdown();
        }
    }

    private static void check(List<TemplateInfo> info) {
        if (info == null || info.size() == 0) {
            throw new NullPointerException("inParams = null");
        }
    }

    private static List<NameValuePair> assemble(List<TemplateInfo> infos, String format, String methodName) {
        ArrayList<NameValuePair> bnvps = new ArrayList<NameValuePair>();
        Extend eel = new Extend();
        eel.setMethod(methodName);
        bnvps.add((NameValuePair)new BasicNameValuePair("templateInfo", gson.toJson(infos)));
        if ("pdf".equals(format.toLowerCase())) {
            eel.setResultType(Extend.createPDFResultType());
        }
        bnvps.add((NameValuePair)new BasicNameValuePair("extend", gson.toJson((Object)eel)));
        return bnvps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompoundResult compound(List<NameValuePair> bnvps, String fileName) {
        try {
            String[] ret = consumer.post(PATH, bnvps);
            Reply reply = (Reply)gson.fromJson(ret[0], Reply.class);
            if (reply.getCode() != 0) {
                log.error(reply.getMsg());
                return new CompoundResult(1, reply.getMsg());
            }
            log.info("name = {}", (Object)reply.getName());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName));
            try {
                InvoiceHelper.copy(consumer.down(DOWN, reply.getName(), ret[1]), out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return new CompoundResult(1, e.getMessage());
        }
        return new CompoundResult(0, "succeed");
    }

    public static CompoundResult multipleTemplates(List<TemplateInfo> infos, String fileName) {
        TemplateUtils.check(infos);
        List<NameValuePair> bnvps = TemplateUtils.assemble(infos, "ofd", "multipleTemplates");
        return TemplateUtils.compound(bnvps, fileName);
    }

    public static CompoundResult oneTemplates(TemplateInfo infos, String fileName) {
        if (infos == null) {
            throw new NullPointerException("TemplateInfo = null");
        }
        ArrayList<TemplateInfo> list = new ArrayList<TemplateInfo>();
        list.add(infos);
        List<NameValuePair> bnvps = TemplateUtils.assemble(list, "ofd", "multipleTemplates");
        return TemplateUtils.compound(bnvps, fileName);
    }

    static {
        gson = Utils.gainGson();
    }
}

