/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.wrapper.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SafeMaskInfo<T> {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private EncryptType encryptType;
    private EncryptMode encryptMode;
    private String password;
    private T[] EncryptModeValue;
    private Map<String, String> permissions = new HashMap<String, String>();

    public SafeMaskInfo() {
        this.encryptMode = EncryptMode.Default;
    }

    public SafeMaskInfo(String password) {
        this.password = password;
        this.encryptMode = EncryptMode.Pin;
    }

    public SafeMaskInfo(T ... encryptModeValue) {
        this.EncryptModeValue = encryptModeValue;
        this.encryptMode = EncryptMode.Cert;
    }

    public EncryptType getEncryptType() {
        return this.encryptType;
    }

    public EncryptMode getEncryptMode() {
        return this.encryptMode;
    }

    public T[] getEncryptModeValue() {
        return this.EncryptModeValue;
    }

    public String getPassword() {
        return this.password;
    }

    public SafeMaskInfo<T> setEdit(Boolean edit) {
        this.permissions.put("Edit", edit + "");
        return this;
    }

    public SafeMaskInfo<T> setAnnot(Boolean annot) {
        this.permissions.put("Annot", annot + "");
        return this;
    }

    public SafeMaskInfo<T> setAutoDestroy(Boolean autoDestroy) {
        this.permissions.put("AutoDestroy", autoDestroy + "");
        return this;
    }

    public SafeMaskInfo<T> setCopy(Boolean copy) {
        this.permissions.put("Copy", copy + "");
        return this;
    }

    public SafeMaskInfo<T> setPrintable(Boolean printable) {
        this.permissions.put("Printable", printable + "");
        return this;
    }

    public SafeMaskInfo<T> setPrintCopies(Integer printCopies) {
        this.permissions.put("PrintCopies", printCopies + "");
        return this;
    }

    public SafeMaskInfo<T> setExport(Boolean export) {
        this.permissions.put("Export", export + "");
        return this;
    }

    public SafeMaskInfo<T> setSaveAs(Boolean saveAs) {
        this.permissions.put("SaveAs", saveAs + "");
        return this;
    }

    public SafeMaskInfo<T> setSignature(Boolean signature) {
        this.permissions.put("Signature", signature + "");
        return this;
    }

    public SafeMaskInfo<T> setDecryptSeal(Boolean decryptSeal) {
        this.permissions.put("DecryptSeal", decryptSeal + "");
        return this;
    }

    public SafeMaskInfo<T> setCancelSeal(Boolean cancelSeal) {
        this.permissions.put("CancelSeal", cancelSeal + "");
        return this;
    }

    public SafeMaskInfo<T> setPrintScreen(Boolean printScreen) {
        this.permissions.put("PrintScreen", printScreen + "");
        return this;
    }

    public SafeMaskInfo<T> setContentRegist(Boolean contentRegist) {
        this.permissions.put("ContentRegist", contentRegist + "");
        return this;
    }

    public SafeMaskInfo<T> setAuthorize(Boolean authorize) {
        this.permissions.put("Authorize", authorize + "");
        return this;
    }

    public SafeMaskInfo<T> setOpenCount(Integer openCount) {
        this.permissions.put("OpenCount", openCount + "");
        return this;
    }

    public SafeMaskInfo<T> setStartDate(Date startDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        this.permissions.put("StartDate", dateFormat.format(startDate));
        return this;
    }

    public SafeMaskInfo<T> setEndDate(Date endDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        this.permissions.put("EndDate", dateFormat.format(endDate));
        return this;
    }

    public Map<String, String> getPermissions() {
        return this.permissions;
    }

    public static enum EncryptMode {
        Pin,
        Default,
        Cert;

    }

    public static enum EncryptType {
        TakeAwayFiles,
        Block;

    }
}

