/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.wrapper.model;

import com.suwell.ofd.custom.wrapper.PackEntry;
import com.suwell.ofd.custom.wrapper.model.GetTogether;
import com.suwell.ofd.custom.wrapper.model.IArgs;
import com.suwell.ofd.custom.wrapper.model.Pair;
import java.io.InputStream;
import java.net.URI;

public final class Common {
    private String title;
    private String format;
    private int dpi;
    private float width;
    private float height;
    private URI uri;
    private PackEntry data;
    private IArgs argument;
    private GetTogether together;
    private Pair<String, String> decryptInfo;

    private Common(String title, String format) {
        this.title = title;
        this.format = format == null ? null : format.toLowerCase();
    }

    public Common(String title, String format, URI uri) {
        this(title, format);
        this.uri = uri;
    }

    public Common(String title, String format, InputStream data) {
        this(title, format);
        this.data = PackEntry.wrap(data);
    }

    public Common(String title, String format, int dpi, URI uri) {
        this(title, format);
        this.dpi = dpi;
        this.uri = uri;
    }

    public Common(String title, String format, float width, URI uri) {
        this(title, format);
        this.width = width;
        this.uri = uri;
    }

    public Common(String title, String format, int dpi, InputStream data) {
        this(title, format);
        this.dpi = dpi;
        this.data = PackEntry.wrap(data);
    }

    public Common(String title, String format, int dpi, PackEntry data) {
        this(title, format);
        this.dpi = dpi;
        this.data = data;
    }

    public Common(String title, String format, float width, InputStream data) {
        this(title, format);
        this.width = width;
        this.data = PackEntry.wrap(data);
    }

    public Common(String title, String format, float width, float height, InputStream data) {
        this(title, format);
        this.width = width;
        this.height = height;
        this.data = PackEntry.wrap(data);
    }

    public Common(String title, String format, float width, PackEntry data) {
        this(title, format);
        this.width = width;
        this.data = data;
    }

    public Common(String title, String format, GetTogether together) {
        this(title, format);
        this.together = together;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFormat() {
        return this.format;
    }

    public int getDPI() {
        return this.dpi;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public URI getURI() {
        return this.uri;
    }

    public PackEntry getData() {
        return this.data;
    }

    public IArgs getArgument() {
        return this.argument;
    }

    public Common setArgument(IArgs argument) {
        this.argument = argument;
        return this;
    }

    public Common setDecryptInfo(String name, String parameter) {
        this.decryptInfo = new Pair<String, String>(name, parameter);
        return this;
    }

    public Pair<String, String> getDecryptInfo() {
        return this.decryptInfo;
    }

    public GetTogether getTogether() {
        return this.together;
    }
}

