/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.wrapper.model;

import com.suwell.ofd.custom.wrapper.model.IArgs;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Argument
implements IArgs {
    private static final String INSERT = "insert";
    private static final String QUOTE = "quote";
    protected Map<String, String> map = new LinkedHashMap<String, String>();

    public Argument put(String key, String val) {
        if (key == null) {
            return this;
        }
        this.map.put(key, val);
        return this;
    }

    public Argument put(Map<String, String> map) {
        if (map == null) {
            return this;
        }
        this.map.putAll(map);
        return this;
    }

    public Argument retain(Set<Integer> index) {
        if (index == null || index.isEmpty()) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        for (Integer i : index) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(i);
        }
        this.put("retain", sb.toString());
        return this;
    }

    public Argument quote(String ... ns) {
        if (ns == null || ns.length == 0) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        for (String i : ns) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(i);
        }
        this.put(QUOTE, sb.toString());
        return this;
    }

    public Argument insert(int i) {
        this.put(INSERT, String.valueOf(i));
        return this;
    }

    @Override
    public String value() {
        if (this.map == null || this.map.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String key : this.map.keySet()) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            String val = this.map.get(key);
            sb.append(key);
            if (val == null) continue;
            sb.append("=").append(val);
        }
        return sb.toString();
    }
}

