/*
 * Decompiled with CFR 0.152.
 */
package cpcns.xml.selector;

import cpcns.xml.selector.AttributeSpecifier;
import cpcns.xml.selector.PseudoClassSpecifier;
import cpcns.xml.selector.PseudoNthSpecifier;
import cpcns.xml.selector.Scanner;
import cpcns.xml.selector.Selector;
import cpcns.xml.selector.Specifier;
import java.util.List;

public final class CSS2XPath {
    public static final String css2xpath(String css) {
        return CSS2XPath.css2xpath(css, true);
    }

    public static final String css2xpath(String css, boolean isRoot) {
        Scanner scanner = new Scanner(css);
        List<List<Selector>> selectors = scanner.scan();
        StringBuilder sb = new StringBuilder();
        String selectorSeparator = "";
        for (List<Selector> selector : selectors) {
            sb.append(selectorSeparator);
            if (!isRoot) {
                sb.append(".");
            }
            for (Selector s : selector) {
                switch (s.getCombinator()) {
                    case CHILD: {
                        sb.append("/");
                        break;
                    }
                    case DESCENDANT: {
                        sb.append("//");
                        break;
                    }
                    case ADJACENT_SIBLING: {
                        sb.append("?????");
                        break;
                    }
                    case GENERAL_SIBLING: {
                        sb.append("?????");
                    }
                }
                sb.append(s.getTagName());
                if (!s.hasSpecifiers()) continue;
                block21: for (Specifier specifier : s.getSpecifiers()) {
                    switch (specifier.getType()) {
                        case ATTRIBUTE: {
                            AttributeSpecifier a = (AttributeSpecifier)specifier;
                            sb.append("[");
                            if (a.getMatch() == null) {
                                sb.append("@");
                                sb.append(a.getName());
                            } else {
                                switch (a.getMatch()) {
                                    case EXACT: {
                                        sb.append("@");
                                        sb.append(a.getName());
                                        sb.append("='");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append("'");
                                        break;
                                    }
                                    case CONTAINS: {
                                        sb.append("contains(@");
                                        sb.append(a.getName());
                                        sb.append(", '");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append("')");
                                        break;
                                    }
                                    case HYPHEN: {
                                        sb.append("@");
                                        sb.append(a.getName());
                                        sb.append("='");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append("' or starts-with(@");
                                        sb.append(a.getName());
                                        sb.append(", '");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append("-')");
                                        break;
                                    }
                                    case PREFIX: {
                                        sb.append("starts-with(@");
                                        sb.append(a.getName());
                                        sb.append(", '");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append("')");
                                        break;
                                    }
                                    case SUFFIX: {
                                        CSS2XPath.endsWith(sb, a.getName(), a.getValue());
                                        break;
                                    }
                                    case LIST: {
                                        sb.append("@");
                                        sb.append(a.getName());
                                        sb.append("='");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append("' or starts-with(@");
                                        sb.append(a.getName());
                                        sb.append(", '");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append(" ')");
                                        sb.append(" or ");
                                        CSS2XPath.endsWith(sb, a.getName(), " " + a.getValue());
                                        sb.append(" or contains(@");
                                        sb.append(a.getName());
                                        sb.append(", ' ");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append(" ')");
                                    }
                                }
                            }
                            sb.append("]");
                            break;
                        }
                        case NEGATION: {
                            sb.append("[not(");
                            sb.append(")]");
                            break;
                        }
                        case PSEUDO: {
                            String value;
                            Specifier p;
                            if (specifier instanceof PseudoClassSpecifier) {
                                p = (PseudoClassSpecifier)specifier;
                                value = ((PseudoClassSpecifier)p).getValue();
                                if ("empty".equals(value)) {
                                    sb.append("[not(*|@*|node())]");
                                    break;
                                }
                                if ("first-child".equals(value)) {
                                    sb.append("[not(preceding-sibling::*)]");
                                    break;
                                }
                                if ("last-child".equals(value)) {
                                    sb.append("[not(following-sibling::*)]");
                                    break;
                                }
                                if ("only-child".equals(value)) {
                                    sb.append("[not(preceding-sibling::*) and not(following-sibling::*)]");
                                    break;
                                }
                                if (!"root".equals(value)) continue block21;
                                sb.append("[not(parent::*)]");
                                break;
                            }
                            if (!(specifier instanceof PseudoNthSpecifier) || !"nth-child".equals(value = ((PseudoNthSpecifier)(p = (PseudoNthSpecifier)specifier)).getValue())) break;
                            sb.append("[position() = ");
                            sb.append(((PseudoNthSpecifier)p).getArgument());
                            sb.append("]");
                        }
                    }
                }
            }
            selectorSeparator = " | ";
        }
        return sb.toString();
    }

    private static void endsWith(StringBuilder sb, String attr, String value) {
        sb.append("'");
        sb.append(value.replace("'", "\\'"));
        sb.append("' = substring(@");
        sb.append(attr);
        sb.append(", string-length(@");
        sb.append(attr);
        sb.append(") - string-length('");
        sb.append(value.replace("'", "\\'"));
        sb.append("') + 1)");
    }
}

