/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import cpcns.xml.JOOX;
import cpcns.xml.Match;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XMLVisitor {
    public static Document parse(File xml, boolean deleteNamespace) throws SAXException, IOException, TransformerException {
        Match $ = JOOX.$(xml);
        if (deleteNamespace) {
            $ = $.transform(XMLVisitor.dnst());
        }
        return $.document();
    }

    public static Document parse(InputStream is, boolean deleteNamespace) throws SAXException, IOException, TransformerException {
        Match $ = JOOX.$(is);
        if (deleteNamespace) {
            $ = $.transform(XMLVisitor.dnst());
        }
        return $.document();
    }

    public static void store(OutputStream os, Document doc) throws IOException {
        JOOX.$(doc).write(os);
    }

    public static void each(Element ele, boolean deep, Handler handler) {
        if (ele == null || handler == null) {
            return;
        }
        Match $ = JOOX.$(ele);
        if ($.isEmpty()) {
            return;
        }
        for (Element e : $.children()) {
            if (!handler.handle(e) || !deep) continue;
            XMLVisitor.each(e, deep, handler);
        }
    }

    public static List<Element> children(Element e) {
        return JOOX.$(e).children().get();
    }

    public static List<Element> listByXPath(Element e, String xpath) {
        return JOOX.$(e).xpath(xpath).get();
    }

    public static Element findByXPath(Element e, String xpath) {
        if (xpath == null || xpath.length() == 0) {
            return null;
        }
        return JOOX.$(e).xpath(xpath).get(0);
    }

    public static String toXPath(Element e) {
        return JOOX.$(e).xpath();
    }

    public static boolean isLeaf(Element e) {
        return JOOX.$(e).children().isEmpty();
    }

    private static Transformer dnst() throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslt = new StreamSource(XMLVisitor.class.getResourceAsStream("DNS.xslt"));
        Transformer transformer = factory.newTransformer(xslt);
        return transformer;
    }

    public static Element deleteNamespace(Element e) throws TransformerException {
        return JOOX.$(e).transform(XMLVisitor.dnst()).get(0);
    }

    public static void deleteNamespace(File src, File out) throws TransformerException {
        XMLVisitor.dnst().transform(new StreamSource(src), new StreamResult(out));
    }

    public static String nsURI(Element e) {
        return JOOX.$(e).namespaceURI();
    }

    public static String nsPrefix(Element e) {
        return JOOX.$(e).namespacePrefix();
    }

    public static void delete(Element e) {
        JOOX.$(e).remove();
    }

    public static void main(String[] args) {
        try {
            Document doc = XMLVisitor.parse(new File("D:/test/\u53d1\u7968\u8bed\u4e49\u6570\u636e(\u4e2d\u6587).xml"), false);
            Element root = doc.getDocumentElement();
            System.out.println(JOOX.$(root).namespaceURI());
            System.out.println(JOOX.$(root).namespacePrefix());
            System.out.println(XMLVisitor.findByXPath(root, "/\u7a0e\u52a1\u603b\u5c40\u7535\u5b50\u7968\u636e[1]/\u589e\u503c\u7a0e\u901a\u7528\u53d1\u7968[1]").getTagName());
            XMLVisitor.each(XMLVisitor.deleteNamespace(root), true, new Handler(){

                @Override
                public boolean handle(Element e) {
                    String xPath = XMLVisitor.toXPath(e);
                    System.out.println(e.getLocalName() + " -> " + xPath);
                    return true;
                }
            });
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e1) {
            e1.printStackTrace();
        }
    }

    public static interface Handler {
        public boolean handle(Element var1);
    }
}

