/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import cpcns.http.HttpConnection;
import cpcns.http.HttpMethod;
import cpcns.http.HttpResponse;
import cpcns.io.ReleasableInputStream;
import cpcns.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class WebMocker {
    private String host;

    public WebMocker(String host) {
        this.host = host;
    }

    private String makeURL(String action) {
        String url = this.host;
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url + action;
    }

    public String query(String ticket) throws IOException {
        return WebMocker.toString(WebMocker.doGet(this.makeURL("query?ticket=" + ticket)));
    }

    private static String toString(ReleasableInputStream in) {
        try {
            if (in.inMemory()) {
                return IOUtils.toString(in, "UTF-8");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public InputStream down(String url) throws IOException {
        if (url == null) {
            return null;
        }
        return WebMocker.doGet(url);
    }

    public String upload(File file) throws IOException {
        return this.upload(file, null);
    }

    public String upload(File file, Map<String, ?> data) throws IOException {
        if (file == null) {
            return null;
        }
        String url = this.makeURL("upload");
        return WebMocker.doUpload(url, file, data);
    }

    public static String upload(String url, File file, Map<String, ?> data) throws IOException {
        if (file == null) {
            return null;
        }
        return WebMocker.doUpload(url, file, data);
    }

    public static String post(String url, Map<String, ?> data) throws IOException {
        HttpConnection con = HttpConnection.connect(url);
        if (data != null) {
            con = con.data(data);
        }
        con = con.method(HttpMethod.POST);
        HttpResponse res = con.execute();
        return WebMocker.toString(res.bodyAsStream());
    }

    private static String doUpload(String url, File v, Map<String, ?> data) throws IOException {
        HttpConnection con = HttpConnection.connect(url);
        con.timeout(30000);
        con = con.data("file", v);
        if (data != null) {
            con = con.data(data);
        }
        con = con.method(HttpMethod.UPLOAD);
        HttpResponse res = con.execute();
        return WebMocker.toString(res.bodyAsStream());
    }

    private static ReleasableInputStream doGet(String url) throws IOException {
        HttpConnection con = HttpConnection.connect(url);
        con = con.method(HttpMethod.GET);
        HttpResponse res = con.execute();
        return res.bodyAsStream();
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "test.ofd");
        try {
            System.out.println(WebMocker.upload("http://localhost:8080/cpcns-convert-server/template", new File("D:/ofd/R17.ofd"), map));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

