/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import cpcns.io.DigestOutputStream;
import cpcns.util.Base64;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import java.util.regex.Pattern;

public class StringTool {
    private static int A = 65;
    private static int Z = 90;
    private static int a = 97;
    private static int z = 122;
    private static String BASE64_REG = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
    private static DecimalFormat nformat = new DecimalFormat();
    private static DateFormat dformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static DateFormat dformat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static DateFormat dformat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DateFormat dformat3 = new SimpleDateFormat("yyyy-MM-dd");
    private static DateFormat tformat = new SimpleDateFormat("HH:mm:ss");

    public static String toSingle(String str) throws UnsupportedEncodingException {
        String s = "";
        String sinstr = "";
        for (int i = 1; i <= str.length(); ++i) {
            s = str.substring(i - 1, i);
            byte[] b = s.getBytes("unicode");
            if (b[3] == -1) {
                b[2] = (byte)(b[2] + 32);
                b[3] = 0;
                sinstr = sinstr + new String(b, "unicode");
                continue;
            }
            sinstr = sinstr + s;
        }
        return sinstr;
    }

    public static String toDouble(String str) throws UnsupportedEncodingException {
        String s = "";
        String doustr = "";
        for (int i = 1; i <= str.length(); ++i) {
            s = str.substring(i - 1, i);
            byte[] b = s.getBytes("unicode");
            if (b[3] == 0) {
                b[2] = (byte)(b[2] - 32);
                b[3] = -1;
                doustr = doustr + new String(b, "unicode");
                continue;
            }
            doustr = doustr + s;
        }
        return doustr;
    }

    public static String toUp(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String toLow(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    @Deprecated
    public static String toBig5(String str) throws Exception {
        throw new Exception("\u8f6c\u5316\u529f\u80fd\u8fd8\u6ca1\u6709\u5b8c\u6210");
    }

    public static String toSimple(String str) throws Exception {
        throw new Exception("\u8f6c\u5316\u529f\u80fd\u8fd8\u6ca1\u6709\u5b8c\u6210");
    }

    public static byte[] hexStrToBytes(String hexString) {
        if (StringTool.isEmpty(hexString)) {
            throw new IllegalArgumentException("this hexString must not be empty");
        }
        if (hexString.startsWith("0x")) {
            hexString = hexString.substring(2);
        }
        hexString = hexString.toLowerCase();
        byte[] byteArray = new byte[hexString.length() / 2];
        int k = 0;
        for (int i = 0; i < byteArray.length; ++i) {
            byte high = (byte)(Character.digit(hexString.charAt(k), 16) & 0xFF);
            byte low = (byte)(Character.digit(hexString.charAt(k + 1), 16) & 0xFF);
            byteArray[i] = (byte)(high << 4 | low);
            k += 2;
        }
        return byteArray;
    }

    public static String bytesToHexStr(byte[] byteArray) {
        return StringTool.bytesToHexStr(byteArray, true);
    }

    public static String bytesToHexStr(byte[] byteArray, boolean prev) {
        if (byteArray == null || byteArray.length < 1) {
            throw new IllegalArgumentException("this byteArray must not be null or empty");
        }
        StringBuilder hexString = new StringBuilder();
        if (prev) {
            hexString.append("0x");
        }
        for (int i = 0; i < byteArray.length; ++i) {
            if ((byteArray[i] & 0xFF) < 16) {
                hexString.append("0");
            }
            hexString.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return hexString.toString().toUpperCase();
    }

    public static String join(Collection<?> strings, String sep) {
        return StringTool.join(strings.iterator(), sep);
    }

    public static String join(Iterator<?> strings, String sep) {
        String start = "";
        if (!strings.hasNext()) {
            return start;
        }
        Object obj = strings.next();
        if (obj != null) {
            start = obj.toString();
        }
        if (!strings.hasNext()) {
            return start;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(start);
        while (strings.hasNext()) {
            sb.append(sep);
            sb.append(strings.next());
        }
        return sb.toString();
    }

    public static String isFrontPartOf(String str1, String str2) {
        int offset = 0;
        int s1 = str1.length();
        int s2 = str2.length();
        for (int i = 0; i < s1 && i < s2; ++i) {
            String str = str2.substring(s2 - i - 1);
            if (!str1.startsWith(str)) continue;
            offset = i + 1;
        }
        if (offset == 0) {
            return "";
        }
        return str2.substring(s2 - offset);
    }

    public static String isBackPartOf(String str1, String str2) {
        int offset = 0;
        int s1 = str1.length();
        int s2 = str2.length();
        for (int i = 0; i < s1 && i < s2; ++i) {
            String str = str2.substring(0, i + 1);
            if (!str1.endsWith(str)) continue;
            offset = i + 1;
        }
        if (offset == 0) {
            return "";
        }
        return str2.substring(0, offset);
    }

    public static String toRawText(String txt, boolean caSense, boolean cbSense) throws UnsupportedEncodingException {
        if (caSense) {
            txt = txt.toLowerCase();
        }
        if (cbSense) {
            txt = StringTool.toSingle(txt);
        }
        return txt;
    }

    public static String getRandomString(int length) {
        char[] num = new char[length];
        for (int i = 0; i < length; ++i) {
            double d = Math.random();
            num[i] = d >= 0.5 ? (char)((double)((A - Z) * 2) * (d - 0.5) + (double)Z) : (char)((double)((a - z) * 2) * d + (double)z);
        }
        return String.valueOf(num);
    }

    public static String getRandomString(int length, boolean upcase) {
        char[] num = new char[length];
        for (int i = 0; i < length; ++i) {
            num[i] = upcase ? (char)((double)(A - Z) * Math.random() + (double)Z) : (char)((double)(a - z) * Math.random() + (double)z);
        }
        return String.valueOf(num);
    }

    public static String getUniqueId(String[] items, String text) {
        String par = text;
        int i = 0;
        while (StringTool.contains(items, par)) {
            par = text + "_" + ++i;
        }
        return par;
    }

    public static boolean contains(String[] items, String text) {
        for (String item : items) {
            if (!item.trim().equals(text.trim())) continue;
            return true;
        }
        return false;
    }

    public static String deleteChar(String str, char ch) {
        StringBuffer sb = new StringBuffer("");
        if (str == null) {
            return null;
        }
        char[] tmp = str.toCharArray();
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] == ch) continue;
            sb.append(tmp[i]);
        }
        str = sb.toString();
        return str;
    }

    public static String[] splitBlank(String str) {
        char[] chars = str.trim().toCharArray();
        String tmp = "";
        ArrayList<String> list = new ArrayList<String>();
        int strLength = chars.length;
        for (int i = 0; i < strLength; ++i) {
            char c = chars[i];
            if (' ' != c) {
                tmp = tmp + c;
            } else {
                list.add(tmp);
                tmp = "";
                for (int j = i; j < strLength; ++j) {
                    c = chars[j];
                    if (' ' == c) {
                        ++i;
                        continue;
                    }
                    --i;
                    break;
                }
            }
            if (i != strLength - 1) continue;
            list.add(tmp);
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static String getStrValue(boolean bool) {
        return String.valueOf(bool).toLowerCase();
    }

    public static String getStrValue(double number) {
        return StringTool.getStrValue(number, 2);
    }

    public static String getStrValue(double number, int flips) {
        if (flips < 0) {
            flips = 0;
        }
        nformat.setGroupingUsed(false);
        nformat.setMaximumFractionDigits(flips);
        return nformat.format(number);
    }

    public static String get6StrValue(int val) {
        return String.format("%06d", val);
    }

    public static String get5StrValue(int val) {
        return String.format("%05d", val);
    }

    public static String getStrValue(int val) {
        return nformat.format(val);
    }

    public static boolean isAllBlank(String text) {
        if (text == null) {
            return true;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (StringTool.isWhitespace(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isDigit(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13;
    }

    public static Date getDateFromString(String dataStr) throws Exception {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(dataStr);
        }
        catch (ParseException parseException) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dataStr);
            }
            catch (ParseException parseException2) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(dataStr);
                }
                catch (ParseException parseException3) {
                    try {
                        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS").parse(dataStr);
                    }
                    catch (ParseException parseException4) {
                        try {
                            return new SimpleDateFormat("yyyyMMddHHmmssS'Z'").parse(dataStr);
                        }
                        catch (ParseException parseException5) {
                            throw new Exception("\u4e0d\u80fd\u8bc6\u522b\u7684\u65e5\u671f\u683c\u5f0f");
                        }
                    }
                }
            }
        }
    }

    public static String getStringFromDate(Date date) {
        return dformat.format(date);
    }

    public static String getStringFromDateWithout(Date date) {
        return dformat2.format(date);
    }

    public static String getStringFromDateDebug(Date date) {
        return dformat1.format(date);
    }

    public static String getCurrentDateTimeString() {
        return StringTool.getStringFromDateWithout(new Date());
    }

    public static String getCurrentDateTimeStringD() {
        return StringTool.getStringFromDateDebug(new Date());
    }

    public static String getCurrentDateString() {
        return StringTool.getDateStrFromDate(new Date());
    }

    public static String getDateStrFromDate(Date date) {
        return dformat3.format(date);
    }

    public static String getTimeStrFromDate(Date date) {
        return tformat.format(date);
    }

    public static String intArrayToStr(int[] vals) {
        return StringTool.intArrayToStr(vals, false);
    }

    public static String intArrayToStr(int[] vals, boolean withbrackets) {
        StringBuffer sb = new StringBuffer();
        if (withbrackets) {
            sb.append("[");
        }
        for (int i = 0; i < vals.length; ++i) {
            sb.append(vals[i] + " ");
        }
        sb.delete(sb.length() - 1, sb.length());
        if (withbrackets) {
            sb.append("]");
        }
        return sb.toString();
    }

    public static int[] getIntegerArray(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("[", "");
        str = str.replace("]", "");
        str = str.replace(",", " ");
        String[] args = str.split("\\s+");
        int[] fs = new int[args.length];
        for (int i = 0; i < args.length; ++i) {
            fs[i] = Integer.valueOf(args[i]);
        }
        return fs;
    }

    public static String floatArrayToStr(float[] vals) {
        return StringTool.floatArrayToStr(vals, false);
    }

    public static String floatArrayToStr(float[] vals, int idx, int len) {
        StringBuffer sb = new StringBuffer();
        int l = Math.min(idx + len, vals.length);
        for (int i = idx; i < l; ++i) {
            sb.append(StringTool.getStrValue(vals[i], 2) + " ");
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    public static String floatArrayToStr(float[] vals, boolean withbrackets) {
        return StringTool.floatArrayToStr(vals, withbrackets, 2);
    }

    public static String floatArrayToStr(float[] vals, boolean withbrackets, int flips) {
        StringBuffer sb = new StringBuffer();
        if (withbrackets) {
            sb.append("[");
        }
        for (int i = 0; i < vals.length; ++i) {
            sb.append(StringTool.getStrValue(vals[i], flips) + " ");
        }
        sb.delete(sb.length() - 1, sb.length());
        if (withbrackets) {
            sb.append("]");
        }
        return sb.toString();
    }

    public static float[] getFloatArray(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("[", "");
        str = str.replace("]", "");
        str = str.replace(",", " ");
        String[] args = str.split("\\s+");
        float[] fs = new float[args.length];
        for (int i = 0; i < args.length; ++i) {
            fs[i] = Float.valueOf(args[i]).floatValue();
        }
        return fs;
    }

    public static String doubleArrayToStr(double[] vals) {
        return StringTool.doubleArrayToStr(vals, false, 2);
    }

    public static String doubleArrayToStr(double[] vals, boolean withbrackets) {
        return StringTool.doubleArrayToStr(vals, withbrackets, 2);
    }

    public static String doubleArrayToStr(double[] vals, boolean withbrackets, int flips) {
        StringBuffer sb = new StringBuffer();
        if (withbrackets) {
            sb.append("[");
        }
        for (int i = 0; i < vals.length; ++i) {
            sb.append(StringTool.getStrValue(vals[i], flips) + " ");
        }
        sb.delete(sb.length() - 1, sb.length());
        if (withbrackets) {
            sb.append("]");
        }
        return sb.toString();
    }

    public static boolean isBase64Str(String text) {
        boolean b = Pattern.matches(BASE64_REG, text);
        return b;
    }

    public static double[] getDoubleArray(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("[", "");
        str = str.replace("]", "");
        str = str.replace(",", " ");
        String[] args = str.split("\\s+");
        double[] fs = new double[args.length];
        for (int i = 0; i < args.length; ++i) {
            fs[i] = Double.valueOf(args[i]);
        }
        return fs;
    }

    public static String bytesToBase64Str(byte[] bs) {
        return Base64.encodeToString(bs, false);
    }

    public static byte[] base64StrToBytes(String str) {
        return Base64.decodeFast(str);
    }

    public static String getGuidStr() {
        UUID uuid = UUID.randomUUID();
        String result = uuid.toString().replaceAll("-", "");
        return result;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringTool.isEmpty(str);
    }

    public static String formatParagraph(String oneParagraph) {
        StringBuffer formatP = new StringBuffer();
        if (null != oneParagraph && !"".equals(oneParagraph)) {
            oneParagraph = oneParagraph.replaceAll("  ", " ").trim();
            String[] elements = oneParagraph.split(" ");
            int len = elements.length;
            String start = null;
            boolean isFirst = true;
            int startPos = 0;
            for (int i = 0; i < len - 1; ++i) {
                if (isFirst) {
                    start = elements[i].trim();
                    isFirst = false;
                    startPos = i;
                }
                Long current = new Long(elements[i].trim());
                Long next = new Long(elements[i + 1].trim());
                if (next - current != 1L) {
                    if (startPos == i) {
                        formatP.append(" " + elements[i]);
                    } else if (current - Long.valueOf(start) == 1L) {
                        formatP.append(" " + start + " " + elements[i]);
                    } else {
                        formatP.append(" " + start + "-" + elements[i]);
                    }
                    start = elements[i].trim();
                    isFirst = true;
                    startPos = i;
                }
                if (i != len - 2) continue;
                if (next - current == 1L) {
                    formatP.append(" " + start + "-" + elements[i + 1]);
                    continue;
                }
                formatP.append(" " + elements[i + 1]);
            }
            formatP = len > 1 ? formatP : formatP.append(oneParagraph);
        }
        return formatP.toString();
    }

    public static String join(String[] paths, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            sb.append(paths[i]);
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String getFileSizeByFloat(float size) {
        if (size < 1024.0f) {
            return StringTool.getStrValue(size) + "B";
        }
        if (size / 1024.0f < 1024.0f) {
            return StringTool.getStrValue(size /= 1024.0f) + "KB";
        }
        if (size / 1024.0f / 1024.0f < 1024.0f) {
            size = size / 1024.0f / 1024.0f;
            return StringTool.getStrValue(size) + "MB";
        }
        if (size / 1012.0f / 1012.0f / 1024.0f < 1024.0f) {
            size = size / 1024.0f / 1024.0f / 1024.0f;
            return StringTool.getStrValue(size) + "GB";
        }
        return StringTool.getStrValue(size);
    }

    public static float getFloatByFileSize(String str) {
        if (str.toUpperCase().endsWith("KB")) {
            str = str.replaceAll("KB", "");
        } else if (str.toUpperCase().endsWith("MB")) {
            str = str.replaceAll("MB", "");
        } else if (str.toUpperCase().endsWith("GB")) {
            str = str.replaceAll("GB", "");
        } else if (str.toUpperCase().endsWith("B")) {
            str = str.replaceAll("B", "");
        }
        return Float.parseFloat(str);
    }

    public static String getMD5Text(String str) throws NoSuchAlgorithmException, UnsupportedEncodingException, IOException {
        if (str == null) {
            return null;
        }
        DigestOutputStream dos = new DigestOutputStream("MD5");
        dos.write(str.getBytes("UTF-8"));
        dos.close();
        return dos.getDigestText();
    }
}

