/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import cpcns.io.MappedBufferInputStream;
import cpcns.io.RandomAccessFileInputStream;
import cpcns.io.ReleasableInputStream;
import cpcns.io.WisdomOutputStream;
import cpcns.util.FileUtils;
import cpcns.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class StreamUtils {
    public static final int CHUNK = 8192;

    public static ReleasableInputStream duplicate(InputStream is, long max) throws IOException {
        if (is instanceof ReleasableInputStream) {
            return (ReleasableInputStream)is;
        }
        if (max <= 0L) {
            max = 0xA00000L;
        }
        WisdomOutputStream wos = new WisdomOutputStream(max, true);
        IOUtils.copy(is, (OutputStream)wos);
        return wos.toInputStream();
    }

    public static MappedBufferInputStream mapped(File file, boolean delete) throws IOException {
        return new MappedBufferInputStream(file, delete);
    }

    public static RandomAccessFileInputStream access(File file, boolean delete) throws IOException {
        return new RandomAccessFileInputStream(file, delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean store(InputStream is, File file) {
        if (is == null || file == null) {
            return false;
        }
        BufferedOutputStream fos = null;
        try {
            file.getParentFile().mkdirs();
            fos = new BufferedOutputStream(new FileOutputStream(file));
            boolean bl = IOUtils.copy(is, (OutputStream)fos) > 0;
            IOUtils.closeQuietly(fos);
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File file, OutputStream os) {
        boolean bl;
        if (file == null || os == null) {
            return false;
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(FileUtils.openInputStream(file));
            int r = IOUtils.copy((InputStream)is, os);
            os.flush();
            bl = r > 0;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly(is);
            return bl2;
        }
        IOUtils.closeQuietly(is);
        return bl;
    }

    public static byte[] read(InputStream is, int max) {
        if (max <= 0) {
            return null;
        }
        try {
            byte[] b = new byte[max];
            int l = is.read(b);
            if (l < max) {
                return Arrays.copyOf(b, l);
            }
            return b;
        }
        catch (IOException e) {
            return null;
        }
    }
}

