/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NumberFormater {
    private static final String[] CHINESE_UPPER_DIGITS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CHINESE_LOWER_DIGITS = new String[]{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] CHINESE_UPPER_UNITS = new String[]{"\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf"};
    private static final String[] CHINESE_LOWER_UNITS = new String[]{"\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf"};
    private static final DecimalFormat generalWholeNumFormat = new DecimalFormat("#");
    private static final DecimalFormat generalDecimalNumFormat = new DecimalFormat("#.##########");
    private static final Pattern specialPatternGroup = Pattern.compile("(\\[\\$[^-\\]]*-[0-9A-Z]+\\])");

    private NumberFormater() {
    }

    public static String commonConvert(int source, boolean upperCase) {
        String s = String.valueOf(source);
        return NumberFormater.commonConvert(s, upperCase);
    }

    public static String commonConvert(String source, boolean upperCase) {
        StringBuilder sb = new StringBuilder();
        for (char c : source.toCharArray()) {
            int v = c - 48;
            if (v < 0 || v > 9) {
                sb.append(c);
                continue;
            }
            if (upperCase) {
                sb.append(CHINESE_UPPER_DIGITS[v]);
                continue;
            }
            sb.append(CHINESE_LOWER_DIGITS[v]);
        }
        return sb.toString();
    }

    public static String convertWithUnit(int source, boolean upperCase) {
        return NumberFormater.convertWithUnit((long)source + 0L, upperCase);
    }

    public static String convertWithUnit(double source, boolean upperCase) {
        if ((double)((long)source) == source) {
            return NumberFormater.convertWithUnit((long)source, upperCase);
        }
        long whole = (long)source;
        String result = NumberFormater.convertWithUnit(whole, upperCase);
        result = result + "\u70b9" + NumberFormater.commonConvert(String.valueOf(source).split("\\.")[1], upperCase);
        return result;
    }

    public static String convertWithUnit(long source, boolean upperCase) {
        String[] units = CHINESE_LOWER_UNITS;
        String[] numeric = CHINESE_LOWER_DIGITS;
        if (upperCase) {
            units = CHINESE_UPPER_UNITS;
            numeric = CHINESE_UPPER_DIGITS;
        }
        String temp = String.valueOf(source);
        String result = "";
        if (null != temp) {
            int k = -1;
            while (temp.length() > 0) {
                int j = Integer.parseInt(temp.substring(temp.length() - 1, temp.length()));
                String rtemp = numeric[j];
                if (j != 0 && k != -1 || k % 8 == 3 || k % 8 == 7) {
                    rtemp = rtemp + units[k % 8];
                }
                result = rtemp + result;
                temp = temp.substring(0, temp.length() - 1);
                ++k;
            }
            while (result.endsWith(numeric[0])) {
                result = result.substring(0, result.lastIndexOf(numeric[0]));
            }
            while (result.indexOf(numeric[0] + numeric[0]) != -1) {
                result = result.replaceAll(numeric[0] + numeric[0], numeric[0]);
            }
            for (int m = 1; m < units.length; ++m) {
                result = result.replaceAll(numeric[0] + units[m], units[m]);
            }
        }
        if (result.startsWith("\u4e00\u5341")) {
            result = result.substring(1);
        }
        if (result.contains(CHINESE_LOWER_DIGITS[0])) {
            result = result.replaceAll(CHINESE_LOWER_DIGITS[0], CHINESE_UPPER_DIGITS[0]);
        }
        return result;
    }

    public static int RomanToArabic(String roman) {
        int i = 0;
        int arabic = 0;
        while (i < roman.length()) {
            char letter = roman.charAt(i);
            int number = NumberFormater.letterToNumber(letter);
            if (++i == roman.length()) {
                arabic += number;
                continue;
            }
            int nextNumber = NumberFormater.letterToNumber(roman.charAt(i));
            if (nextNumber > number) {
                arabic += nextNumber - number;
                ++i;
                continue;
            }
            arabic += number;
        }
        return arabic;
    }

    public static String ArabicToRoman(int num, boolean upperCase) {
        int[] numbers = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] letters = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        String roman = "";
        for (int i = 0; i < numbers.length; ++i) {
            while (num >= numbers[i]) {
                roman = roman + letters[i];
                num -= numbers[i];
            }
        }
        if (!upperCase) {
            return roman.toLowerCase();
        }
        return roman;
    }

    private static int letterToNumber(char letter) {
        switch (letter) {
            case 'I': {
                return 1;
            }
            case 'V': {
                return 5;
            }
            case 'X': {
                return 10;
            }
            case 'L': {
                return 50;
            }
            case 'C': {
                return 100;
            }
            case 'D': {
                return 500;
            }
            case 'M': {
                return 1000;
            }
        }
        return -1;
    }

    public static DecimalFormat createFormater(String pattern, BigDecimal value) {
        Matcher m = specialPatternGroup.matcher(pattern);
        while (m.find()) {
            String match = m.group();
            String symbol = match.substring(match.indexOf(36) + 1, match.indexOf(45));
            if (symbol.indexOf(36) > -1) {
                StringBuffer sb = new StringBuffer();
                sb.append(symbol.substring(0, symbol.indexOf(36)));
                sb.append('\\');
                sb.append(symbol.substring(symbol.indexOf(36), symbol.length()));
                symbol = sb.toString();
            }
            pattern = m.replaceAll(symbol);
            m = specialPatternGroup.matcher(pattern);
        }
        StringBuffer sb = new StringBuffer(pattern);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c == '(') {
                int idx = sb.indexOf(")", i);
                if (idx <= -1 || sb.charAt(idx - 1) != '_') continue;
                sb.deleteCharAt(idx);
                sb.deleteCharAt(idx - 1);
                sb.deleteCharAt(i);
                --i;
                continue;
            }
            if (c == ')' && i > 0 && sb.charAt(i - 1) == '_') {
                sb.deleteCharAt(i);
                sb.deleteCharAt(i - 1);
                --i;
                continue;
            }
            if (c == '\\' || c == '\"' || c == '*') {
                sb.deleteCharAt(i);
                --i;
                continue;
            }
            if (c != '+' || i <= 0 || sb.charAt(i - 1) != 'E') continue;
            sb.deleteCharAt(i);
            --i;
        }
        try {
            return new DecimalFormat(sb.toString());
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            return NumberFormater.getDefaultFormat(value);
        }
    }

    private static DecimalFormat getDefaultFormat(BigDecimal value) {
        if (NumberFormater.isWholeNumber(value)) {
            return generalWholeNumFormat;
        }
        return generalDecimalNumFormat;
    }

    private static boolean isWholeNumber(BigDecimal value) {
        return value.compareTo(value.setScale(0, RoundingMode.HALF_UP)) == 0;
    }

    public static void main(String[] args) {
        System.out.println(NumberFormater.ArabicToRoman(1800, false));
        System.out.println(NumberFormater.isWholeNumber(new BigDecimal("1000.01")));
        BigDecimal bd = new BigDecimal("0.0");
        DecimalFormat df = NumberFormater.createFormater("0.00_);[Red](0.00)", bd);
        df = NumberFormater.getDefaultFormat(bd);
        System.out.println(df.format(bd));
        System.out.println(bd.signum());
        bd = new BigDecimal("456123.456789");
        df = NumberFormater.createFormater("0.#####E+0", bd);
        System.out.println(df.format(bd));
        bd = new BigDecimal("-1234.56789");
        df = NumberFormater.createFormater("_ \uffe5* #,##0.00_ ;_ \uffe5* -#,##0.00_ ;_ \uffe5* &quot;-&quot;??_ ;_ @_ ", bd);
        System.out.println(df.format(bd));
        System.out.println(Double.valueOf("3.1415"));
    }
}

