/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import cpcns.io.RandomAccessFileInputStream;
import cpcns.util.FileUtils;
import cpcns.util.IOUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarUtils {
    public static File findJarDir(Class<?> c) {
        URL url;
        try {
            url = c.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (Exception ex) {
            url = c.getResource(c.getSimpleName() + ".class");
        }
        String ext = url.toExternalForm();
        if (ext.endsWith(".jar")) {
            ext = ext.substring(0, ext.lastIndexOf("/"));
        } else {
            String suffix = "/" + c.getName().replace(".", "/") + ".class";
            if ((ext = ext.replace(suffix, "")).startsWith("jar:") && ext.endsWith(".jar!")) {
                ext = ext.substring(4, ext.lastIndexOf("/"));
            }
        }
        try {
            url = new URL(ext);
        }
        catch (MalformedURLException suffix) {
            // empty catch block
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            return new File(url.getPath());
        }
    }

    public static File findJarPath(Class<?> c) {
        String suffix22;
        URL url;
        try {
            url = c.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (Exception ex) {
            url = c.getResource(c.getSimpleName() + ".class");
        }
        String ext = url.toExternalForm();
        if (!ext.endsWith(".jar") && (ext = ext.replace(suffix22 = "/" + c.getName().replace(".", "/") + ".class", "")).startsWith("jar:") && ext.endsWith(".jar!")) {
            ext = ext.substring(4, ext.lastIndexOf("!"));
        }
        try {
            url = new URL(ext);
        }
        catch (MalformedURLException suffix22) {
            // empty catch block
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            return new File(url.getPath());
        }
    }

    public static InputStream extract(Class<?> c, String path) throws IOException {
        return JarUtils.extract(c, path, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream extract(Class<?> c, String path, String sub, boolean replace) throws IOException {
        if (c == null || path == null) {
            return null;
        }
        File jar = JarUtils.findJarPath(c);
        if (jar.isFile()) {
            InputStream is;
            String fn;
            int k;
            String name = jar.getName();
            int i = name.lastIndexOf(".");
            if (i != -1) {
                name = name.substring(0, i);
            }
            File dir = new File(jar.getParentFile(), name);
            if (sub != null && sub.length() > 0) {
                dir = new File(dir, sub);
            }
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ((k = (fn = path).lastIndexOf("/")) != -1) {
                fn = fn.substring(k + 1);
            }
            File file = new File(dir, fn);
            if ((replace || !file.exists()) && (is = c.getResourceAsStream(path)) != null) {
                FileOutputStream os = FileUtils.openOutputStream(file);
                try {
                    IOUtils.copy(is, (OutputStream)os);
                }
                finally {
                    IOUtils.closeQuietly(os);
                }
            }
            return new RandomAccessFileInputStream(file, false);
        }
        return c.getResourceAsStream(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream extractNewest(Class<?> c, String target, String path) throws IOException {
        if (c == null || path == null) {
            return null;
        }
        String separator = ".";
        File jar = JarUtils.findJarPath(c);
        path = JarUtils.resolveName(c, path);
        String parent = null;
        String baseName = path;
        int index = path.lastIndexOf("/");
        if (index > 0) {
            parent = path.substring(0, index);
            baseName = path.substring(index + 1);
        }
        long last = -1L;
        File dir = null;
        if (jar.isFile()) {
            long dirLast;
            String name = jar.getName();
            int i = name.lastIndexOf(".");
            if (i != -1) {
                name = name.substring(0, i);
            }
            if (target != null && target.trim().length() > 0) {
                name = name + "/" + target;
            }
            dir = new File(jar.getParentFile(), name);
            JarFile jf = new JarFile(jar, false);
            long jarLast = JarUtils.findNewestInJar(jf, separator, path);
            if (jarLast > (dirLast = JarUtils.findNewestInDir(dir, separator, baseName))) {
                String jen = path + (jarLast == 0L ? "" : separator + jarLast);
                JarEntry je = jf.getJarEntry(jen);
                InputStream is = jf.getInputStream(je);
                File file = new File(dir, baseName + (jarLast == 0L ? "" : separator + jarLast));
                FileOutputStream os = FileUtils.openOutputStream(file);
                try {
                    IOUtils.copy(is, (OutputStream)os);
                }
                finally {
                    IOUtils.closeQuietly(os);
                }
            }
            jf.close();
            last = Math.max(jarLast, dirLast);
        } else {
            dir = jar;
            if (parent != null) {
                dir = new File(jar, parent);
            }
            last = JarUtils.findNewestInDir(dir, separator, baseName);
        }
        if (last == -1L) {
            return null;
        }
        if (last == 0L) {
            return new RandomAccessFileInputStream(new File(dir, baseName), false);
        }
        return new RandomAccessFileInputStream(new File(dir, baseName + separator + last), false);
    }

    private static String resolveName(Class<?> c, String name) {
        if (name == null) {
            return name;
        }
        if (!name.startsWith("/")) {
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                name = baseName.substring(0, index).replace('.', '/') + "/" + name;
            }
        } else {
            name = name.substring(1);
        }
        return name;
    }

    private static long findNewestInJar(JarFile jf, String separator, String path) {
        long last = -1L;
        Enumeration<JarEntry> jes = jf.entries();
        while (jes.hasMoreElements()) {
            JarEntry je = jes.nextElement();
            String name = je.getName();
            if (!name.startsWith(path)) continue;
            int i = name.lastIndexOf(separator);
            if (i == -1 || name.equals(path)) {
                last = Math.max(0L, last);
                continue;
            }
            try {
                last = Math.max((long)Integer.valueOf(name.substring(i + 1)).intValue(), last);
            }
            catch (Exception exception) {}
        }
        return last;
    }

    private static long findNewestInDir(File dir, String separator, String baseName) {
        long last = -1L;
        File[] fs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
        if (fs == null || fs.length == 0) {
            return last;
        }
        for (File f : fs) {
            String name = f.getName();
            if (!name.startsWith(baseName)) continue;
            int i = name.lastIndexOf(separator);
            if (i == -1 || name.equals(baseName)) {
                last = Math.max(0L, last);
                continue;
            }
            try {
                last = Math.max((long)Integer.valueOf(name.substring(i + 1)).intValue(), last);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(Class<?> c, String source, File out) throws IOException {
        File jar;
        if (!out.exists()) {
            out.mkdirs();
        }
        if (source.startsWith("/")) {
            source = source.substring(1);
        }
        if ((jar = JarUtils.findJarPath(c)).isFile()) {
            JarFile jf = new JarFile(jar, false);
            Enumeration<JarEntry> es = jf.entries();
            while (es.hasMoreElements()) {
                JarEntry je = es.nextElement();
                String name = je.getName();
                if (!name.startsWith(source)) continue;
                name = name.substring(source.length() + 1);
                if (je.isDirectory()) {
                    File dir = new File(out, name);
                    dir.mkdirs();
                    continue;
                }
                File file = new File(out, name);
                File dir = file.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                InputStream in = null;
                FileOutputStream os = null;
                try {
                    in = jf.getInputStream(je);
                    os = FileUtils.openOutputStream(file);
                    IOUtils.copy(in, (OutputStream)os);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(os);
            }
            jf.close();
        } else {
            File dir = new File(jar, source);
            FileUtils.copyDirectory(dir, out);
        }
    }
}

