/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import cpcns.util.FileUtils;
import cpcns.util.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;

public class FileAccess {
    private static final String LOCK_SUFFIX = ".lock";

    public static boolean canRead(File file) {
        File lock;
        return file.exists() && !(lock = new File(file.getAbsolutePath() + LOCK_SUFFIX)).exists();
    }

    public static boolean canWrite(File file) {
        if (!file.exists()) {
            return true;
        }
        File lock = new File(file.getAbsolutePath() + LOCK_SUFFIX);
        if (lock.exists()) {
            try {
                String v = FileUtils.readFileToString(lock, "UTF-8");
                if (v != null && v.equals(ManagementFactory.getRuntimeMXBean().getName())) {
                    return false;
                }
                FileUtils.deleteQuietly(lock);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    public static void copy(InputStream is, File out) throws Exception {
        FileAccess.copy(is, out, new Classic());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, File out, Copier copier) throws Exception {
        if (is == null) {
            throw new IOException("InputStream is NULL!");
        }
        File lock = new File(out.getAbsolutePath() + LOCK_SUFFIX);
        FileUtils.writeStringToFile(lock, ManagementFactory.getRuntimeMXBean().getName(), "UTF-8");
        FileOutputStream os = FileUtils.openOutputStream(out);
        try {
            copier.copy(is, os);
            FileUtils.deleteQuietly(lock);
        }
        finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
        }
    }

    private static class Classic
    implements Copier {
        private Classic() {
        }

        @Override
        public void copy(InputStream is, OutputStream os) throws Exception {
            IOUtils.copy(is, os);
        }
    }

    public static interface Copier {
        public void copy(InputStream var1, OutputStream var2) throws Exception;
    }
}

