/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import cpcns.util.IOUtils;
import cpcns.util.JarUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Properties;

public class ConfigUtils {
    public static Properties load(Class<?> c, String name) {
        return ConfigUtils.load(c, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(File file) {
        Properties p = new Properties();
        if (!file.exists()) {
            return p;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            if (is != null) {
                p.load(new InputStreamReader((InputStream)is, "UTF-8"));
            }
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            Properties properties = null;
            return properties;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(Class<?> c, String name, boolean extract) {
        Properties p = new Properties();
        InputStream is = null;
        try {
            if (name != null) {
                is = extract ? JarUtils.extract(c, name) : c.getResourceAsStream(name);
            }
            if (is != null) {
                p.load(new InputStreamReader(is, "UTF-8"));
            }
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            Properties properties = null;
            return properties;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean store(Properties p, File file) {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            p.store(osw, null);
            boolean bl = true;
            IOUtils.closeQuietly(osw);
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(osw);
        }
    }

    public static String value(Properties p, String name, String def) {
        if (p == null || name == null) {
            return def;
        }
        String v = p.getProperty(name);
        if (v != null) {
            return v.trim();
        }
        return def;
    }

    public static int intValue(Properties p, String name, int def) {
        if (p == null || name == null) {
            return def;
        }
        String v = p.getProperty(name);
        if (v != null) {
            try {
                return Integer.valueOf(v.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public static float floatValue(Properties p, String name, float def) {
        if (p == null || name == null) {
            return def;
        }
        String v = p.getProperty(name);
        if (v != null) {
            try {
                return Float.valueOf(v.trim()).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public static boolean booleanValue(Properties p, String name, boolean def) {
        if (p == null || name == null) {
            return def;
        }
        String v = p.getProperty(name);
        if (v != null) {
            return ConfigUtils.toBoolean(v, def);
        }
        return def;
    }

    private static Boolean toBoolean(String v, boolean def) {
        if (v.equalsIgnoreCase("on")) {
            return true;
        }
        try {
            return Boolean.valueOf(v.trim());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static String[] arrayValue(Properties p, String name) {
        return ConfigUtils.arrayValue(p, name, String.class, null);
    }

    public static <T> T[] arrayValue(Properties p, String name, Class<T> type, String separator) {
        String[] ary;
        String v = ConfigUtils.value(p, name, null);
        if (v == null) {
            return null;
        }
        if (separator == null) {
            separator = "\\s+";
        }
        if ((ary = v.split(separator)) == null) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(type, ary.length);
        int i = 0;
        for (String s : ary) {
            if (s == null || (s = s.trim()).length() == 0) continue;
            if (type == Integer.TYPE || type == Integer.class) {
                array[i++] = Integer.valueOf(s);
                continue;
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                array[i++] = ConfigUtils.toBoolean(v, false);
                continue;
            }
            if (type == Float.TYPE || type == Float.class) {
                array[i++] = Float.valueOf(s);
                continue;
            }
            if (type != String.class) continue;
            array[i++] = s;
        }
        if (i + 1 < array.length) {
            array = Arrays.copyOf(array, i + 1);
        }
        return array;
    }
}

