/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ClassTool {
    public static Object invokeStaticMethod(String theClassFullName, String methodName, Class<?>[] paramsType, Object[] paramsValue) {
        return ClassTool.invokeStaticMethod(ClassTool.getClass(theClassFullName), methodName, paramsType, paramsValue);
    }

    public static Object invokeStaticMethod(Class<?> theClass, String methodName, Class<?>[] paramsType, Object[] paramsValue) {
        return ClassTool.invokeMethod(theClass, theClass, methodName, paramsType, paramsValue);
    }

    public static Object invokeMethod(String theClassFullName, Object theObject, String methodName, Class<?>[] paramsType, Object[] paramsValue) {
        Class<?> theClass = ClassTool.getClass(theClassFullName);
        return ClassTool.invokeMethod(theClass, theClass, methodName, paramsType, paramsValue);
    }

    public static Object invokeMethod(Class<?> theClass, Object theObject, String methodName, Class<?>[] paramsType, Object[] paramsValue) {
        Object ret = null;
        if (theClass != null) {
            try {
                Method m = theClass.getMethod(methodName, paramsType);
                ret = m.invoke(theObject, paramsValue);
            }
            catch (Exception e) {
                System.err.println("@\u9519\u8bef\uff1a\u901a\u8fc7\u53cd\u5c04\u8c03\u7528\u65b9\u6cd5" + theClass.getName() + "." + methodName + "(" + Arrays.toString(paramsType) + ")\u5931\u8d25\uff0c" + e.getMessage());
            }
        }
        return ret;
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean hasMethod(Class<?> theClass, String methodName, Class<?>[] paraTypes) {
        return ClassTool.getMethod(theClass, methodName, paraTypes) != null;
    }

    public static Method getMethod(Class<?> theClass, String methodName, Class<?>[] paraTypes) {
        try {
            Method m = theClass.getDeclaredMethod(methodName, paraTypes);
            if (m != null) {
                m.setAccessible(true);
            }
            return m;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object invokeMethod(Object theObject, String methodName, Object ... params) {
        Class[] types = null;
        if (params != null && params.length > 0) {
            types = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = params[i].getClass();
            }
        }
        Method m = null;
        m = theObject instanceof Class ? ClassTool.getMethod((Class)theObject, methodName, types) : ClassTool.getMethod(theObject.getClass(), methodName, types);
        if (m == null) {
            return null;
        }
        return ClassTool.invoke(theObject, m, params);
    }

    public static Object getFieldValue(Object theObject, String fieldName) {
        Class<?> c = theObject instanceof Class ? (Class<?>)theObject : theObject.getClass();
        try {
            Field f = null;
            while (true) {
                try {
                    f = c.getDeclaredField(fieldName);
                }
                catch (Exception e) {
                    c = c.getSuperclass();
                    if (c == null) break;
                    if (c != Object.class) continue;
                }
                break;
            }
            if (f != null) {
                f.setAccessible(true);
                return f.get(theObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Object invoke(Object o, Method method, Object ... params) {
        try {
            return method.invoke(o, params);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isInterface(Class<?> theClass, String intefaceName) {
        Class<?>[] face = theClass.getInterfaces();
        for (int i = 0; i < face.length; ++i) {
            if (face[i].getName().equals(intefaceName)) {
                return true;
            }
            Class<?>[] face1 = face[i].getInterfaces();
            for (int j = 0; j < face1.length; ++j) {
                if (face1[j].getName().equals(intefaceName)) {
                    return true;
                }
                if (!ClassTool.isInterface(face1[j], intefaceName)) continue;
                return true;
            }
        }
        if (theClass.getSuperclass() != null) {
            return ClassTool.isInterface(theClass.getSuperclass(), intefaceName);
        }
        return false;
    }

    public static Object newInstance(Class<?> c, Object ... args) {
        if (c == null) {
            return null;
        }
        if (args == null || args.length == 0) {
            try {
                return c.newInstance();
            }
            catch (Exception e) {
                System.err.println("\u521b\u5efa\u7c7b\u7684\u5b9e\u4f8b\u5931\u8d25:" + e.getMessage());
            }
        } else {
            Class[] types = new Class[args.length];
            int i = 0;
            for (Object o : args) {
                types[i++] = o.getClass();
            }
            try {
                Constructor<?> cs = c.getConstructor(types);
                return cs.newInstance(args);
            }
            catch (Exception e) {
                System.err.println("\u521b\u5efa\u7c7b\u7684\u5b9e\u4f8b\u5931\u8d25:" + e.getMessage());
            }
        }
        return null;
    }
}

