/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

public class CacheManager<T> {
    private ConcurrentHashMap<String, Item<T>> map;
    private int maxSize;
    private ItemRejecter<T> rejecter;

    private CacheManager(int maxSize, ItemRejecter<T> rejecter) {
        this.maxSize = maxSize;
        this.rejecter = rejecter;
        this.map = new ConcurrentHashMap(this.maxSize);
    }

    public static <T> CacheManager<T> newMgr() {
        return new CacheManager<T>(50, null);
    }

    public static <T> CacheManager<T> newMgr(int maxSize) {
        return new CacheManager<T>(maxSize, null);
    }

    public static <T> CacheManager<T> newMgr(int maxSize, ItemRejecter<T> rejecter) {
        return new CacheManager<T>(maxSize, rejecter);
    }

    public CacheManager<T> rejecter(ItemRejecter<T> rejecter) {
        this.rejecter = rejecter;
        return this;
    }

    public T get(String key) {
        try {
            return this.get(key, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public T get(String key, ItemLoader<T> loader) throws Exception {
        Item<T> item = this.map.get(key);
        if (item != null) {
            ++item.count;
            item.last = System.currentTimeMillis();
            return item.it;
        }
        if (loader != null) {
            return (T)this.cache(key, (T)loader);
        }
        return null;
    }

    private T cache(String key, ItemLoader<T> loader) throws Exception {
        Item item = new Item(key);
        item.it = loader.load(key);
        Item old = this.map.putIfAbsent(key, item);
        if (old != null) {
            if (this.rejecter != null) {
                this.rejecter.reject(item.it);
            }
            item = old;
        }
        ++item.count;
        item.last = System.currentTimeMillis();
        this.tryReject();
        return item.it;
    }

    private void tryReject() {
        if (this.maxSize == -1) {
            return;
        }
        if (this.map.size() < this.maxSize) {
            return;
        }
        ArrayList<Item<T>> list = new ArrayList<Item<T>>(this.map.values());
        Collections.sort(list);
        for (Item<T> i : list) {
            this.map.remove(i.key);
            if (this.rejecter != null) {
                this.rejecter.reject(i.it);
            }
            if (this.map.size() > this.maxSize) continue;
            break;
        }
    }

    public T cache(String key, T it) {
        Item item = new Item(key);
        item.it = it;
        ++item.count;
        item.last = System.currentTimeMillis();
        Item old = this.map.put(key, item);
        if (old != null) {
            return old.it;
        }
        this.tryReject();
        return null;
    }

    public synchronized void clear() {
        if (this.rejecter != null) {
            for (Item<T> item : this.map.values()) {
                this.rejecter.reject(item.it);
            }
        }
        this.map.clear();
    }

    public static void main(String[] args) {
        final CacheManager cb = CacheManager.newMgr(10);
        for (int c = 0; c < 2; ++c) {
            new Thread(){

                @Override
                public void run() {
                    long l = System.currentTimeMillis();
                    for (int i = 0; i < 100; ++i) {
                        cb.cache("" + i, new Object());
                    }
                    System.out.println(System.currentTimeMillis() - l);
                }
            }.start();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("###############");
        for (int c = 0; c < 2; ++c) {
            new Thread(){

                @Override
                public void run() {
                    long l = System.currentTimeMillis();
                    for (int i = 0; i < 100; ++i) {
                        cb.get("" + i);
                    }
                    System.out.println(System.currentTimeMillis() - l);
                }
            }.start();
        }
    }

    private static class Item<T>
    implements Comparable<Item<T>> {
        final String key;
        volatile T it;
        volatile long count = 0L;
        volatile long last;

        public Item(String key) {
            this.key = key;
        }

        public String toString() {
            return "Item [key=" + this.key + ", count=" + this.count + ", last=" + this.last + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.it == null ? 0 : this.it.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            return !(this.it == null ? other.it != null : !this.it.equals(other.it));
        }

        @Override
        public int compareTo(Item<T> o) {
            return (int)(this.last - o.last);
        }
    }

    public static interface ItemRejecter<T> {
        public void reject(T var1);
    }

    public static interface ItemLoader<T> {
        public T load(String var1) throws Exception;
    }
}

