/*
 * Decompiled with CFR 0.152.
 */
package cpcns.lang.character;

import cpcns.lang.character.CharacterData;
import cpcns.lang.character.UnicodeScript;
import java.util.Arrays;

public final class Characters {
    public static boolean isIdeographic(int code) {
        return CharacterData.of(code).isIdeographic(code);
    }

    public static boolean isValidCodePoint(int codePoint) {
        int plane = codePoint >>> 16;
        return plane < 17;
    }

    public static boolean isArabic(int codePoint) {
        return UnicodeScript.ARABIC == UnicodeScript.of(codePoint);
    }

    public static boolean isChinese(int codePoint) {
        return UnicodeScript.HAN == UnicodeScript.of(codePoint);
    }

    public static int[] codePoints(String text) {
        int codepoint;
        int[] array = new int[text.length()];
        int index = 0;
        for (int i = 0; i < text.length(); i += Character.charCount(codepoint)) {
            codepoint = text.codePointAt(i);
            array[index++] = codepoint;
        }
        return Arrays.copyOf(array, index);
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString(Characters.codePoints("1\u4f60\u597d...")));
        System.out.println(Characters.isIdeographic(20320));
        System.out.println(Characters.isIdeographic(49));
    }
}

