/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import cpcns.io.ReleasableInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream
extends ReleasableInputStream {
    private File file;
    private RandomAccessFile raf;
    private boolean delete;

    public RandomAccessFileInputStream(File file) throws IOException {
        this(file, true);
    }

    public RandomAccessFileInputStream(File file, boolean deleteWhenRelease) throws IOException {
        this.file = file;
        this.raf = new RandomAccessFile(file, "r");
        this.delete = deleteWhenRelease;
    }

    @Override
    public void release() throws IOException {
        this.close0();
        if (this.delete && this.file.exists()) {
            this.file.delete();
        }
    }

    @Override
    public void close() throws IOException {
        this.close0();
    }

    private void close0() throws IOException {
        this.raf.close();
    }

    @Override
    public int read() throws IOException {
        return this.raf.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raf.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        long avail = this.raf.length() - this.raf.getFilePointer();
        return avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
    }

    @Override
    public void reset() throws IOException {
        this.raf.seek(0L);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.raf.skipBytes((int)n);
    }

    @Override
    public boolean inMemory() {
        return false;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public String toString() {
        return "RandomAccessFileInputStream [file=" + this.file + ", delete=" + this.delete + "]";
    }
}

