/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import cpcns.io.UnclosedOutputStream;
import cpcns.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class OutputToInput {
    public static InputStream connect(Producer p) throws IOException {
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        new POT(pos, p).start();
        return pis;
    }

    public static void main(String[] args) {
        try {
            InputStream is = OutputToInput.connect(new Producer(){

                @Override
                public void produce(OutputStream os) {
                    try {
                        os.write("Hello".getBytes());
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            System.out.println(IOUtils.toString(is));
            IOUtils.closeQuietly(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface Producer {
        public void produce(OutputStream var1);
    }

    private static class POT
    extends Thread {
        private PipedOutputStream pos;
        private Producer p;

        public POT(PipedOutputStream pos, Producer p) {
            this.pos = pos;
            this.p = p;
        }

        @Override
        public void run() {
            UnclosedOutputStream uos = new UnclosedOutputStream(this.pos);
            try {
                this.p.produce(uos);
            }
            finally {
                IOUtils.closeQuietly(uos);
                IOUtils.closeQuietly(this.pos);
            }
        }
    }
}

