/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import cpcns.util.StringTool;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestOutputStream
extends OutputStream {
    private boolean pause = false;
    private MessageDigest msgd = null;
    private OutputStream out = null;
    byte[] digest = null;

    public DigestOutputStream(String algorithm, OutputStream os) throws NoSuchAlgorithmException {
        this.msgd = MessageDigest.getInstance(algorithm);
        this.out = os;
    }

    public DigestOutputStream(String algorithm) throws NoSuchAlgorithmException {
        this.msgd = MessageDigest.getInstance(algorithm);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.out != null) {
            this.out.write(b);
        }
        this.update(new byte[]{(byte)b}, 0, 1);
        this.digest = null;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        if (this.out != null) {
            this.out.write(b);
        }
        this.update(b, 0, b.length);
        this.digest = null;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.out != null) {
            this.out.write(b, off, len);
        }
        this.update(b, off, len);
        this.digest = null;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void pause() {
        this.pause = true;
    }

    public void restart() {
        this.pause = false;
    }

    public void reset() {
        if (this.msgd != null) {
            this.msgd.reset();
        }
        this.digest = null;
    }

    private void update(byte[] input, int off, int len) {
        if (this.msgd != null && !this.pause) {
            this.msgd.update(input);
        }
    }

    public byte[] getDigest() {
        this.digest = (byte[])(this.msgd != null ? this.msgd.digest() : null);
        return this.digest;
    }

    public String getDigestText() {
        byte[] hash = null;
        hash = this.digest != null ? this.digest : this.getDigest();
        if (hash == null) {
            return null;
        }
        return StringTool.bytesToHexStr(hash, false);
    }
}

