/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class CRC32OutputStream
extends OutputStream {
    private boolean pause = false;
    private CRC32 crc = new CRC32();
    private OutputStream out = null;

    public CRC32OutputStream() {
    }

    public CRC32OutputStream(OutputStream os) {
        this.out = os;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.out != null) {
            this.out.write(b);
        }
        if (!this.pause) {
            this.crc.update(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        if (this.out != null) {
            this.out.write(b);
        }
        if (!this.pause) {
            this.crc.update(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.out != null) {
            this.out.write(b, off, len);
        }
        if (!this.pause) {
            this.crc.update(b, off, len);
        }
    }

    public long getCRC32Value() {
        return this.crc.getValue();
    }

    public void pause() {
        this.pause = true;
    }

    public void restart() {
        this.pause = false;
    }

    public void reset() {
        this.crc.reset();
    }
}

