/*
 * Decompiled with CFR 0.152.
 */
package cpcns.http.html;

import cpcns.util.FileUtils;
import cpcns.util.IOUtils;
import cpcns.util.StreamUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class Util {
    public static final String STYLE_DIR = "style";
    public static final String CLASS_MAIN = "main";
    public static final String CLASS_BACKGROUND = "backdrop";
    public static final String CLASS_BG_IMAGE = "bgi";
    public static final String CLASS_FOREGROUND = "fgc";
    public static final String CLASS_GROUP = "group";
    public static final String CLASS_TEXT = "text";
    public static final String FILE_INFO = "info.json";
    public static final String FILE_OUTLINE = "outline.json";
    public static final String OUTLINE_EMPTY = "[]";
    public static final String FILE_FINISH = ".finish";
    public static final String FILE_THUMB = "thumb";
    public static final String TYPE_IMAGE = "png";
    public static final String TYPE_HTML = "html";
    public static final String FILE_INDEX = "index.html";
    public static final String FLAG_OFD = "_ofd";
    public static final String FLAG_PDF = "_pdf";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStyle(File dir, Style style) {
        if (dir == null || style == null) {
            return;
        }
        File out = new File(dir, style.path());
        if (out.exists()) {
            return;
        }
        InputStream is = null;
        try {
            is = style.data();
            StreamUtils.store(is, out);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public static boolean isFinish(File dir, int width) {
        return new File(dir, FILE_FINISH).exists() || new File(dir, width + File.separator + FILE_FINISH).exists();
    }

    public static void finish(File dir) throws IOException {
        File file = new File(dir, FILE_FINISH);
        if (file.exists()) {
            return;
        }
        String text = String.valueOf(System.currentTimeMillis());
        FileUtils.writeStringToFile(file, text, "UTF-8");
    }

    public static String html(int index) {
        return index + "." + TYPE_HTML;
    }

    public static String image(int index) {
        return index + "." + TYPE_IMAGE;
    }

    public static abstract class Style {
        public static Style index = new Style(){

            @Override
            public String title() {
                return "index.css";
            }

            @Override
            public InputStream data() {
                return Util.class.getResourceAsStream(this.title());
            }
        };
        public static Style fixed = new Style(){

            @Override
            public String title() {
                return "fixed.css";
            }

            @Override
            public InputStream data() {
                return Util.class.getResourceAsStream(this.title());
            }
        };

        public abstract InputStream data();

        public abstract String title();

        public String path() {
            return "./style/" + this.title();
        }
    }
}

