/*
 * Decompiled with CFR 0.152.
 */
package cpcns.http.html;

import cpcns.http.html.BaseDOM;
import cpcns.http.html.HTML;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class Head
extends BaseDOM {
    private static final long serialVersionUID = -92872919475107904L;
    public static final int LINK_TYPE_SCRIPT = 0;
    public static final int LINK_TYPE_STYLE = 0;
    private List<Meta> metas;
    private String title;
    private List<Style> styles;
    private List<String> scripts;

    Head(HTML parent) {
        this.parent = parent;
    }

    public void meta(String name, String content) {
        if (this.metas == null) {
            this.metas = new ArrayList<Meta>();
        }
        this.metas.add(new Meta(name, content));
    }

    public void style(String style) {
        if (style == null) {
            return;
        }
        Style s = new Style();
        s.content = style;
        this.add(s);
    }

    private void add(Style s) {
        if (this.styles == null) {
            this.styles = new ArrayList<Style>();
        }
        this.styles.add(s);
    }

    public void title(String title) {
        this.title = title;
    }

    public void link(int type, String value) {
        if (type == 0) {
            Style s = new Style();
            s.src = value;
            this.add(s);
        } else if (type == 0) {
            if (this.scripts == null) {
                this.scripts = new ArrayList<String>();
            }
            this.scripts.add(value);
        }
    }

    @Override
    public void write(Writer writer, int level) throws IOException {
        this.line(writer, level, "<head>");
        int lv = level + 1;
        this.line(writer, lv, "<meta http-equiv=\"content-type\" content=\"text/html;charset=UTF-8\"/>");
        if (this.metas != null) {
            for (Meta m : this.metas) {
                m.write(writer, lv);
            }
        }
        if (this.title != null) {
            this.line(writer, lv, "<title>" + this.title + "</title>");
        }
        if (this.scripts != null) {
            for (String s : this.scripts) {
                this.line(writer, lv, "<script type=\"text/javascript\" src=\"" + s + "\"></script>");
            }
        }
        if (this.styles != null) {
            for (Style style : this.styles) {
                style.write(writer, lv);
            }
        }
        this.line(writer, level, "</head>");
    }

    private static class Style
    extends BaseDOM {
        private static final long serialVersionUID = 4117584419301071223L;
        private String src;
        private String content;

        private Style() {
        }

        @Override
        protected void write(Writer writer, int level) throws IOException {
            if (this.src != null) {
                this.line(writer, level, "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.src + "\">");
            } else {
                this.line(writer, level, "<style type=\"text/css\">");
                this.line(writer, level + 1, this.content);
                this.line(writer, level, "</style>");
            }
        }
    }

    private static class Meta
    extends BaseDOM {
        private static final long serialVersionUID = -2960288197404482511L;
        private String name;
        private String content;

        public Meta(String name, String content) {
            this.name = name;
            this.content = content;
        }

        @Override
        public void write(Writer writer, int level) throws IOException {
            this.line(writer, level, "<meta name=\"" + this.name + "\" content=\"" + this.content + "\"/>");
        }
    }
}

