/*
 * Decompiled with CFR 0.152.
 */
package cpcns.http;

import cpcns.http.HttpMethod;
import cpcns.http.HttpRequest;
import cpcns.http.HttpResponse;
import cpcns.http.KeyVal;
import cpcns.http.Validate;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpConnection {
    private HttpRequest req = new HttpRequest();
    private HttpResponse res = new HttpResponse();
    static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }};

    public static HttpConnection connect(String url) {
        HttpConnection con = new HttpConnection();
        con.url(url);
        return con;
    }

    public static HttpConnection connect(URL url) {
        HttpConnection con = new HttpConnection();
        con.url(url);
        return con;
    }

    private HttpConnection() {
    }

    public HttpConnection url(URL url) {
        this.req.url(url);
        return this;
    }

    public HttpConnection cache(File file) {
        this.req.cache(file);
        return this;
    }

    public HttpConnection url(String url) {
        Validate.notEmpty(url, "Must supply a valid URL");
        try {
            this.req.url(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + url, e);
        }
        return this;
    }

    public HttpConnection userAgent(String userAgent) {
        Validate.notNull(userAgent, "User agent must not be null");
        this.req.header("User-Agent", userAgent);
        return this;
    }

    public HttpConnection timeout(int millis) {
        this.req.timeout(millis);
        return this;
    }

    public HttpConnection followRedirects(boolean followRedirects) {
        this.req.followRedirects(followRedirects);
        return this;
    }

    public HttpConnection referrer(String referrer) {
        Validate.notNull(referrer, "Referrer must not be null");
        this.req.header("Referer", referrer);
        return this;
    }

    public HttpConnection method(HttpMethod method) {
        this.req.method(method);
        return this;
    }

    public HttpConnection method(String method) {
        HttpMethod hm = HttpMethod.valueOf(method);
        if (hm == null) {
            hm = HttpMethod.GET;
        }
        this.req.method(hm);
        return this;
    }

    public HttpConnection ignoreHttpErrors(boolean ignoreHttpErrors) {
        this.req.ignoreHttpErrors(ignoreHttpErrors);
        return this;
    }

    public HttpConnection data(String key, String value) {
        this.req.data(KeyVal.create(key, value));
        return this;
    }

    public HttpConnection data(String key, File value) {
        this.req.data(KeyVal.create(key, value));
        return this;
    }

    public HttpConnection data(Map<String, ?> data) {
        Validate.notNull(data, "Data map must not be null");
        for (Map.Entry<String, ?> entry : data.entrySet()) {
            this.req.data(KeyVal.create(entry.getKey(), entry.getValue()));
        }
        return this;
    }

    public HttpConnection data(String ... keyvals) {
        Validate.notNull(keyvals, "Data key value pairs must not be null");
        Validate.isTrue(keyvals.length % 2 == 0, "Must supply an even number of key value pairs");
        for (int i = 0; i < keyvals.length; i += 2) {
            String key = keyvals[i];
            String value = keyvals[i + 1];
            Validate.notEmpty(key, "Data key must not be empty");
            Validate.notNull(value, "Data value must not be null");
            this.req.data(KeyVal.create(key, value));
        }
        return this;
    }

    public HttpConnection header(String name, String value) {
        this.req.header(name, value);
        return this;
    }

    public HttpConnection cookie(String name, String value) {
        this.req.cookie(name, value);
        return this;
    }

    public HttpConnection cookies(Map<String, String> cookies) {
        Validate.notNull(cookies, "Cookie map must not be null");
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            this.req.cookie(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpResponse execute() throws IOException {
        this.res = this.res.execute(this.req);
        return this.res;
    }

    public HttpRequest request() {
        return this.req;
    }

    public HttpConnection request(HttpRequest request) {
        this.req = request;
        return this;
    }

    public HttpResponse response() {
        return this.res;
    }

    public HttpConnection response(HttpResponse response) {
        this.res = response;
        return this;
    }

    static {
        HttpsURLConnection.setDefaultHostnameVerifier(new HttpConnection().new NullHostNameVerifier());
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class NullHostNameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }
}

