/*
 * Decompiled with CFR 0.152.
 */
package cpcns.http;

import cpcns.http.HttpMethod;
import cpcns.http.Validate;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class HttpBase<T extends HttpBase<?>> {
    URL url;
    HttpMethod method;
    Map<String, String> headers = new LinkedHashMap<String, String>();
    Map<String, String> cookies = new LinkedHashMap<String, String>();

    HttpBase() {
    }

    public URL url() {
        return this.url;
    }

    public T url(URL url) {
        Validate.notNull(url, "URL must not be null");
        this.url = url;
        return (T)this;
    }

    public HttpMethod method() {
        return this.method;
    }

    public T method(HttpMethod method) {
        Validate.notNull((Object)method, "Method must not be null");
        this.method = method;
        return (T)this;
    }

    public String header(String name) {
        Validate.notNull(name, "Header name must not be null");
        return this.getHeaderCaseInsensitive(name);
    }

    public T header(String name, String value) {
        Validate.notEmpty(name, "Header name must not be empty");
        Validate.notNull(value, "Header value must not be null");
        this.removeHeader(name);
        this.headers.put(name, value);
        return (T)this;
    }

    public boolean hasHeader(String name) {
        Validate.notEmpty(name, "Header name must not be empty");
        return this.getHeaderCaseInsensitive(name) != null;
    }

    public T removeHeader(String name) {
        Validate.notEmpty(name, "Header name must not be empty");
        Map.Entry<String, String> entry = this.scanHeaders(name);
        if (entry != null) {
            this.headers.remove(entry.getKey());
        }
        return (T)this;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    private String getHeaderCaseInsensitive(String name) {
        Map.Entry<String, String> entry;
        Validate.notNull(name, "Header name must not be null");
        String value = this.headers.get(name);
        if (value == null) {
            value = this.headers.get(name.toLowerCase());
        }
        if (value == null && (entry = this.scanHeaders(name)) != null) {
            value = entry.getValue();
        }
        return value;
    }

    private Map.Entry<String, String> scanHeaders(String name) {
        String lc = name.toLowerCase();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            if (!entry.getKey().toLowerCase().equals(lc)) continue;
            return entry;
        }
        return null;
    }

    public String cookie(String name) {
        Validate.notNull(name, "Cookie name must not be null");
        return this.cookies.get(name);
    }

    public T cookie(String name, String value) {
        Validate.notEmpty(name, "Cookie name must not be empty");
        Validate.notNull(value, "Cookie value must not be null");
        this.cookies.put(name, value);
        return (T)this;
    }

    public boolean hasCookie(String name) {
        Validate.notEmpty("Cookie name must not be empty");
        return this.cookies.containsKey(name);
    }

    public T removeCookie(String name) {
        Validate.notEmpty("Cookie name must not be empty");
        this.cookies.remove(name);
        return (T)this;
    }

    public Map<String, String> cookies() {
        return this.cookies;
    }
}

