/*
 * Decompiled with CFR 0.152.
 */
package cpcns.http;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharsetTools {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");
    public static final String defaultCharset = "UTF-8";

    public static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            String charset = m.group(1).trim();
            if (Charset.isSupported(charset)) {
                return charset;
            }
            if (Charset.isSupported(charset = charset.toUpperCase(Locale.ENGLISH))) {
                return charset;
            }
        }
        return null;
    }
}

