/*
 * Decompiled with CFR 0.152.
 */
package cpcns.detect.impl;

import cpcns.detect.impl.LittleEndian;
import cpcns.detect.impl.OfficeCheckable;
import cpcns.io.RandomAccessFileInputStream;
import cpcns.util.FileUtils;
import cpcns.util.Hex;
import cpcns.util.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SimpleOfficeCheck
implements OfficeCheckable {
    private static void readFully(RandomAccessFile input, byte[] data) throws IOException {
        int len = input.read(data, 0, data.length);
        if (len != data.length) {
            throw new IOException("Read data length error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String check(InputStream input) throws IOException {
        File file = null;
        boolean del = false;
        if (input instanceof RandomAccessFileInputStream) {
            RandomAccessFileInputStream fis = (RandomAccessFileInputStream)input;
            file = fis.getFile();
        } else {
            file = File.createTempFile("SOC-", ".dat");
            del = true;
            StreamUtils.store(input, file);
        }
        Office office = new Office(file);
        try {
            office.read();
            String ret = office.type;
            if (office.appName != null) {
                String appName = office.appName.toLowerCase();
                if (appName.contains("wps") || appName.contains("kso")) {
                    ret = "ks+" + ret;
                } else if (appName.contains("microsoft")) {
                    ret = "ms+" + ret;
                }
            }
            String string = ret;
            return string;
        }
        finally {
            office.close();
            if (del) {
                FileUtils.deleteQuietly(file);
            }
        }
    }

    private static class Value {
        private Object val;

        Value(byte[] data, int offset) {
            long type = LittleEndian.getUInt(data, offset);
            switch ((int)type) {
                case 30: {
                    long len = LittleEndian.getUInt(data, offset + 4);
                    try {
                        this.val = new String(data, offset + 8, (int)len, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    break;
                }
                case 64: {
                    try {
                        this.val = new String(data, offset + 4, 8, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    break;
                }
                default: {
                    this.val = LittleEndian.getUInt(data, offset + 4);
                }
            }
        }

        public String toString() {
            return this.val == null ? null : this.val.toString();
        }
    }

    private static class Group {
        private Map<Long, Value> map = new LinkedHashMap<Long, Value>();

        Group(byte[] data, int offset) {
            long size = LittleEndian.getUInt(data, offset);
            long count = LittleEndian.getUInt(data, offset + 4);
            int start = offset + 8;
            int i = 0;
            while ((long)i < count) {
                long type = LittleEndian.getUInt(data, start);
                long off = LittleEndian.getUInt(data, start + 4);
                Value value = new Value(data, (int)((long)offset + off));
                this.map.put(type, value);
                start += 8;
                ++i;
            }
        }

        public String value(long key) {
            Value val = this.map.get(key);
            return val == null ? null : val.toString();
        }
    }

    private static class Summary {
        private List<Group> list = new ArrayList<Group>();

        Summary(byte[] data) {
            long count = LittleEndian.getUInt(data, 24);
            int i = 0;
            while ((long)i < count) {
                int offset = 28 + i * 20;
                byte[] b = Arrays.copyOfRange(data, offset, offset + 16);
                String v = Hex.encodeHexString(b);
                if (!"E0859FF2F94F6810AB9108002B27B3D9".equalsIgnoreCase(v)) {
                    System.err.println("Not SummaryInformation Group");
                } else {
                    long start = LittleEndian.getUInt(data, offset + 16);
                    Group group = new Group(data, (int)start);
                    this.list.add(group);
                }
                ++i;
            }
        }

        public String appName() {
            for (Group group : this.list) {
                String val = group.value(18L);
                if (val == null) continue;
                return val;
            }
            return null;
        }
    }

    private static class Entry {
        private static final int LENGTH = 128;
        private static final short TYPE_DIR = 1;
        private static final short TYPE_NODE = 2;
        private static final short TYPE_ROOT = 5;
        private String name;
        private short type;
        private long leftDid;
        private long rightDid;
        private long childDid;
        private long startSid;
        private long size;
        private List<Site> sites;

        private Entry(byte[] data, int offset) {
            this.type = LittleEndian.getUByte(data, offset + 66);
            if (Entry.isValid(this.type)) {
                char[] cs = new char[32];
                for (int i = 0; i < cs.length; ++i) {
                    cs[i] = (char)LittleEndian.getUShort(data, offset + i * 2);
                }
                int len = LittleEndian.getUShort(data, offset + 64) / 2 - 1;
                this.name = new String(cs, 0, len);
            }
            this.leftDid = LittleEndian.getUInt(data, offset + 68);
            this.rightDid = LittleEndian.getUInt(data, offset + 72);
            this.childDid = LittleEndian.getUInt(data, offset + 76);
            this.startSid = LittleEndian.getUInt(data, offset + 116);
            this.size = LittleEndian.getUInt(data, offset + 120);
        }

        private static boolean isValid(short type) {
            return type == 5 || type == 2 || type == 1;
        }

        private void load(Header header) throws IOException {
            boolean isMini;
            if (this.type != 2) {
                return;
            }
            this.sites = new ArrayList<Site>();
            long sid = this.startSid;
            boolean bl = isMini = this.size < header.streamSize;
            while (sid != 0xFFFFFFFEL && sid != 0xFFFFFFFFL) {
                long offset = header.offset(sid, !isMini);
                long count = isMini ? (long)header.miniSectorSize : (long)header.sectorSize;
                this.sites.add(new Site(offset, count));
                sid = header.nextSid(sid, !isMini);
            }
        }
    }

    private static class Site {
        private final long offset;
        private final long count;

        private Site(long offset, long count) {
            this.offset = offset;
            this.count = count;
        }

        public String toString() {
            return "Site{offset=" + this.offset + ", count=" + this.count + '}';
        }
    }

    private static class Header {
        private static final int[] OFFICE_MAGIC = new int[]{208, 207, 17, 224, 161, 177, 26, 225};
        private static final int LENGTH = 512;
        private static final int DifSector = -4;
        private static final int FatSector = -3;
        private static final long END_OF_CHAIN = 0xFFFFFFFEL;
        private static final long FREE_SECTOR = 0xFFFFFFFFL;
        private RandomAccessFile raf;
        private int sectorSize;
        private int miniSectorSize;
        private long streamSize;
        private long entryStartSid;
        private final long miniStartSid;
        private final long miniFatCount;
        private final long difStartSid;
        private final long difCount;
        private List<Long> fatSids;
        private List<Long> miniSids;
        private List<Long> miniFatSids;
        private Entry root;

        private Header(RandomAccessFile raf) throws IOException {
            this.raf = raf;
            this.raf.seek(0L);
            byte[] data = new byte[512];
            SimpleOfficeCheck.readFully(raf, data);
            for (int i = 0; i < OFFICE_MAGIC.length; ++i) {
                if (OFFICE_MAGIC[i] == (data[i] & 0xFF)) continue;
                throw new IOException("MagicNumber match failed");
            }
            this.sectorSize = (int)Math.pow(2.0, LittleEndian.getUShort(data, 30));
            this.miniSectorSize = (int)Math.pow(2.0, LittleEndian.getUShort(data, 32));
            long fatCount = LittleEndian.getUInt(data, 44);
            this.entryStartSid = LittleEndian.getUInt(data, 48);
            this.streamSize = LittleEndian.getUInt(data, 56);
            this.miniStartSid = LittleEndian.getUInt(data, 60);
            this.miniFatCount = LittleEndian.getUInt(data, 64);
            this.difStartSid = LittleEndian.getUInt(data, 68);
            this.difCount = LittleEndian.getUInt(data, 72);
            if (fatCount > 0L) {
                long ui;
                this.fatSids = new ArrayList<Long>();
                for (int i = 0; i < 109 && (ui = LittleEndian.getUInt(data, 76 + i * 4)) != 0xFFFFFFFFL; ++i) {
                    this.fatSids.add(ui);
                }
            }
        }

        private void ready() throws IOException {
            long sid;
            if (this.miniFatCount > 0L) {
                this.miniFatSids = new ArrayList<Long>();
                sid = this.miniStartSid;
                do {
                    this.miniFatSids.add(sid);
                } while ((sid = this.nextNormalSid(sid)) > this.miniStartSid && sid < 0xFFFFFFFEL);
            }
            if (this.miniFatSids != null && !this.miniFatSids.isEmpty() && this.root != null) {
                this.miniSids = new ArrayList<Long>();
                sid = this.root.startSid;
                do {
                    this.miniSids.add(sid);
                } while ((sid = this.nextNormalSid(sid)) > this.root.startSid && sid < 0xFFFFFFFEL);
            }
            if (this.difCount > 0L) {
                byte[] b;
                long difSid = this.difStartSid;
                do {
                    long entryStart = this.sectorOffset(difSid);
                    this.raf.seek(entryStart);
                    b = new byte[512];
                    SimpleOfficeCheck.readFully(this.raf, b);
                    for (int i = 0; i < 127; ++i) {
                        long fatSid = LittleEndian.getUInt(b, i * 4);
                        if (fatSid == 0xFFFFFFFFL) {
                            return;
                        }
                        this.fatSids.add(fatSid);
                    }
                } while ((difSid = LittleEndian.getUInt(b, 508)) > this.difStartSid && difSid < 0xFFFFFFFEL);
            }
        }

        private long sectorOffset(long sid) {
            return 512L + (long)this.sectorSize * sid;
        }

        private long miniSecotrOffset(long sid) {
            long id = this.miniSids.get((int)(sid * (long)this.miniSectorSize / (long)this.sectorSize));
            long offset = sid * (long)this.miniSectorSize % (long)this.sectorSize;
            return 512L + (long)this.sectorSize * id + offset;
        }

        private long offset(long sid, boolean normal) {
            return normal ? this.sectorOffset(sid) : this.miniSecotrOffset(sid);
        }

        private long nextNormalSid(long currentSid) throws IOException {
            try {
                Long next = this.fatSids.get((int)(currentSid / 128L));
                long offset = this.sectorOffset(next) + 4L * (currentSid % 128L);
                this.raf.seek(offset);
                byte[] b = new byte[4];
                SimpleOfficeCheck.readFully(this.raf, b);
                return LittleEndian.getUInt(b);
            }
            catch (IndexOutOfBoundsException e) {
                return 0L;
            }
        }

        private long nextSid(long currentSid, boolean normal) throws IOException {
            return normal ? this.nextNormalSid(currentSid) : this.nextMiniSid(currentSid);
        }

        private long nextMiniSid(long currentSid) throws IOException {
            Long next = this.miniFatSids.get((int)(currentSid / 128L));
            long offset = this.sectorOffset(next) + 4L * (currentSid % 128L);
            this.raf.seek(offset);
            byte[] b = new byte[4];
            SimpleOfficeCheck.readFully(this.raf, b);
            return LittleEndian.getUInt(b);
        }
    }

    private static class Office {
        private RandomAccessFile raf;
        private String type;
        private String appName;
        private boolean encrypted;

        private Office(File file) throws IOException {
            this.raf = new RandomAccessFile(file, "r");
        }

        private void read() throws IOException {
            Header header = new Header(this.raf);
            ArrayList<Entry> entries = new ArrayList<Entry>();
            long sid = header.entryStartSid;
            do {
                entries.addAll(this.entries(header, sid));
            } while ((sid = header.nextNormalSid(sid)) > header.entryStartSid && sid < 0xFFFFFFFEL);
            for (Entry entry : entries) {
                if (entry.type != 5) continue;
                header.root = entry;
                break;
            }
            header.ready();
            for (Entry entry : entries) {
                if ("\u0005SummaryInformation".equals(entry.name)) {
                    entry.load(header);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    for (Site site : entry.sites) {
                        this.raf.seek(site.offset);
                        byte[] b = new byte[(int)site.count];
                        SimpleOfficeCheck.readFully(this.raf, b);
                        baos.write(b);
                    }
                    Summary info = new Summary(baos.toByteArray());
                    this.appName = info.appName();
                    continue;
                }
                if ("WordDocument".equals(entry.name)) {
                    this.type = "doc";
                    continue;
                }
                if ("Workbook".equals(entry.name)) {
                    this.type = "xls";
                    continue;
                }
                if ("PowerPoint Document".equals(entry.name)) {
                    this.type = "ppt";
                    continue;
                }
                if (!"VisioDocument".equals(entry.name)) continue;
                this.type = "vsd";
            }
        }

        private List<Entry> entries(Header header, long sid) throws IOException {
            this.raf.seek(header.sectorOffset(sid));
            byte[] data = new byte[header.sectorSize];
            SimpleOfficeCheck.readFully(this.raf, data);
            int count = data.length / 128;
            ArrayList<Entry> list = new ArrayList<Entry>();
            for (int i = 0; i < count; ++i) {
                Entry e = new Entry(data, i * 128);
                if (!Entry.isValid(e.type)) continue;
                list.add(e);
            }
            return list;
        }

        private void close() {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

