/*
 * Decompiled with CFR 0.152.
 */
package cpcns.detect.impl;

import cpcns.detect.impl.OfficeCheckable;
import cpcns.detect.impl.SimpleOfficeCheck;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class MSOffice2007Detector
implements Detector {
    private static final long serialVersionUID = -5647996050623162115L;
    private static final int[] OFFICE_MAGIC = new int[]{208, 207, 17, 224, 161, 177, 26, 225};
    private OfficeCheckable office;

    public MSOffice2007Detector() {
        try {
            Class<?> c = Class.forName("com.suwell.ofd.office.OfficeCheck");
            Object o = c.newInstance();
            this.office = (OfficeCheckable)OfficeCheckable.class.cast(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.office == null) {
            this.office = new SimpleOfficeCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        if (!input.markSupported()) {
            input = new BufferedInputStream(input);
        }
        input.mark(1024);
        try {
            byte[] buf = new byte[512];
            int len = input.read(buf);
            if (len < OFFICE_MAGIC.length) {
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
            String head = new String(buf, 0, len, "UTF-8");
            if (head.contains("<?xml")) {
                if (head.contains("http://schemas.microsoft.com/office/word/2003/wordml")) {
                    MediaType mediaType = MediaType.application((String)"doc");
                    return mediaType;
                }
                if (head.contains("schemas-microsoft-com:office:spreadsheet")) {
                    MediaType mediaType = MediaType.application((String)"xls");
                    return mediaType;
                }
                if (head.contains("<?mso-application progid=\"PowerPoint.Show\"?>")) {
                    MediaType mediaType = MediaType.application((String)"ppt");
                    return mediaType;
                }
                if (head.contains("http://schemas.microsoft.com/visio/")) {
                    MediaType mediaType = MediaType.application((String)"vsd");
                    return mediaType;
                }
            }
            for (int i = 0; i < OFFICE_MAGIC.length; ++i) {
                if (OFFICE_MAGIC[i] == (buf[i] & 0xFF)) continue;
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
            input.reset();
            try {
                String ret = this.office.check(input);
                if (ret != null) {
                    MediaType mediaType = MediaType.application((String)ret);
                    return mediaType;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MediaType mediaType = MediaType.parse((String)"application/office-x");
            return mediaType;
        }
        finally {
            try {
                input.reset();
            }
            catch (IOException iOException) {}
        }
    }
}

