/*
 * Decompiled with CFR 0.152.
 */
package cpcns.defs;

import cpcns.defs.IMargin;

public class Margin
implements IMargin {
    private float top = 0.0f;
    private float bottom = 0.0f;
    private float left = 0.0f;
    private float right = 0.0f;

    public Margin() {
    }

    public Margin(float left, float right, float top, float bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    @Override
    public float getBottom() {
        return this.bottom;
    }

    @Override
    public void setBottom(float bottom) {
        this.bottom = bottom;
    }

    @Override
    public float getLeft() {
        return this.left;
    }

    @Override
    public void setLeft(float left) {
        this.left = left;
    }

    @Override
    public float getRight() {
        return this.right;
    }

    @Override
    public void setRight(float right) {
        this.right = right;
    }

    @Override
    public float getTop() {
        return this.top;
    }

    @Override
    public void setTop(float top) {
        this.top = top;
    }

    public void copyTo(Margin margin) {
        if (margin == null) {
            margin = new Margin();
        }
        margin.top = this.top;
        margin.bottom = this.bottom;
        margin.left = this.left;
        margin.right = this.right;
    }

    public void rotate(int target) {
        while (target > 4) {
            target -= 4;
        }
        while (target < -4) {
            target += 4;
        }
        Margin copies = new Margin();
        if (target > 0) {
            this.copyTo(copies);
            this.top = copies.getLeft();
            this.right = copies.getTop();
            this.bottom = copies.getRight();
            this.left = copies.getBottom();
            this.rotate(--target);
        } else if (target < 0) {
            this.copyTo(copies);
            this.top = copies.getRight();
            this.right = copies.getBottom();
            this.bottom = copies.getLeft();
            this.left = copies.getTop();
            this.rotate(++target);
        }
    }

    public void transform(boolean isHorizenal) {
        Margin copies = new Margin();
        this.copyTo(copies);
        if (isHorizenal) {
            this.left = copies.right;
            this.right = copies.left;
        } else {
            this.top = copies.bottom;
            this.bottom = copies.top;
        }
    }

    public void scale(float xscale, float yscale) {
        this.left *= xscale;
        this.right *= xscale;
        this.top *= yscale;
        this.bottom *= yscale;
    }
}

