/*
 * Decompiled with CFR 0.152.
 */
package cpcns.convert.model;

import cpcns.util.IOUtils;
import cpcns.util.XMLVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TaskCode {
    private static Log log = LogFactory.getLog(TaskCode.class);
    private Properties mapping;
    private Map<String, Code> cache = new HashMap<String, Code>();

    private TaskCode() {
        this.loadMapping();
        this.loadXML();
    }

    public static TaskCode instance() {
        return TCH.instance;
    }

    private void loadMapping() {
        InputStream in = this.getClass().getResourceAsStream("code.mapping.properties");
        try {
            this.mapping = new Properties();
            this.mapping.load(in);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXML() {
        block8: {
            InputStream in = this.getClass().getResourceAsStream("code.xml");
            try {
                Document doc = XMLVisitor.parse((InputStream)in, (boolean)false);
                Element root = doc.getDocumentElement();
                List list = XMLVisitor.children((Element)root);
                if (list == null) break block8;
                for (Element child : list) {
                    String name = child.getLocalName();
                    if ("StatusGroup".equals(name)) {
                        List cs = XMLVisitor.children((Element)child);
                        if (cs == null) continue;
                        for (Element o : cs) {
                            this.parseCode(o);
                        }
                        continue;
                    }
                    if (!"Status".equals(name)) continue;
                    this.parseCode(child);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    private void parseCode(Element status) {
        String s;
        if (status == null) {
            return;
        }
        String name = status.getLocalName();
        if (!"Status".equals(name)) {
            return;
        }
        Code code = new Code();
        String f = status.getAttribute("finish");
        if (f != null && f.length() > 0) {
            code.finish = Boolean.valueOf(f);
        }
        if ((s = status.getAttribute("success")) != null && s.length() > 0) {
            code.success = Boolean.valueOf(s);
        }
        code.value = this.childText(status, "Code");
        code.name = this.childText(status, "Display");
        code.detail = this.childText(status, "Detail");
        this.cache.put(code.value, code);
    }

    private String childText(Element parent, String name) {
        if (parent == null) {
            return null;
        }
        Element e = XMLVisitor.findByXPath((Element)parent, (String)name);
        if (e == null) {
            return null;
        }
        return e.getTextContent().trim();
    }

    public List<String> keys() {
        ArrayList<String> list = new ArrayList<String>(this.cache.keySet());
        Collections.sort(list);
        return list;
    }

    public Code code(String c) {
        String k;
        Code code = this.cache.get(c);
        if (code == null && this.mapping != null && (k = this.mapping.getProperty(c)) != null) {
            code = this.cache.get(k);
        }
        return code;
    }

    public void print() {
        log.debug((Object)"##### Task Code #####");
        for (String n : this.keys()) {
            Code c = this.code(n);
            log.debug((Object)(n + " = " + c.toString()));
        }
        log.debug((Object)"#####################");
    }

    public static class Code
    implements Serializable {
        private static final long serialVersionUID = 1352874237124835059L;
        private String name;
        private String value;
        private String detail;
        private boolean finish = true;
        private boolean success = false;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public boolean isFinish() {
            return this.finish;
        }

        public void setFinish(boolean finish) {
            this.finish = finish;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String toString() {
            return "[" + this.finish + ", " + this.success + ", " + this.name + ", " + this.detail + "]";
        }
    }

    private static class TCH {
        private static TaskCode instance = new TaskCode();

        private TCH() {
        }
    }
}

