/*
 * Decompiled with CFR 0.152.
 */
package cpcns.convert.impl;

import cpcns.convert.impl.CommandConvertor;
import cpcns.convert.impl.PluginUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MultipleCMDConvertor
extends CommandConvertor {
    private static Log log = LogFactory.getLog(MultipleCMDConvertor.class);
    protected static final int FLAG_WAIT = 0;
    protected static final int FLAG_DONE = 1;
    protected static final int FLAG_ERROR = -1;
    protected AtomicInteger flag = new AtomicInteger(0);
    protected String cleaner;
    private AtomicBoolean ready = new AtomicBoolean(false);
    private BufferedWriter bw;

    public void setCleaner(String path) {
        this.cleaner = path;
        if (this.cleaner != null) {
            this.clean();
        }
    }

    @Override
    public void destroy() {
        this.exit();
        super.destroy();
        this.clean();
    }

    @Override
    protected void whenTimeout(TimeoutException e) {
        super.whenTimeout(e);
        this.destroy();
    }

    protected void execute(String cmd) throws IOException {
        if (this.bw != null) {
            cmd = cmd.trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Command : " + cmd));
            }
            this.bw.write(cmd + "\n");
            this.bw.flush();
        } else {
            log.warn((Object)("Process output is invalid when execute cmd " + cmd));
        }
    }

    @Override
    protected int execute(String app, String ... cmd) throws Exception {
        int v;
        if (this.process == null) {
            ProcessBuilder pb = new ProcessBuilder(app).redirectErrorStream(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Run application : " + pb.command()));
            }
            this.process = pb.start();
            this.bw = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
            new ConsoleOutput(this, this.process.getInputStream()).start();
            int count = 0;
            while (!this.ready.get() && count++ < 10) {
                Thread.sleep(100L);
            }
        }
        long l = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Execute command...");
        }
        this.flag.set(0);
        StringBuilder sb = new StringBuilder();
        sb.append("convert ");
        for (String c : cmd) {
            System.out.println("\u8ffd\u52a0\u53c2\u6570\uff1a----\u300b" + cmd);
            sb.append("\"").append(c).append("\" ");
        }
        this.execute(sb.toString());
        while ((v = this.flag.get()) == 0) {
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Execute command end, cost " + (System.currentTimeMillis() - l) + " ms"));
        }
        return v;
    }

    protected void exit() {
        try {
            this.execute("exit");
            if (this.bw != null) {
                this.bw.close();
                this.bw = null;
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void clean() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Call cleaner");
        }
        if (this.cleaner != null) {
            try {
                Runtime.getRuntime().exec(new String[]{"cmd", "/Q", "/C", this.cleaner}).waitFor();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected boolean processLine(String line) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("> " + line));
        }
        if (line != null) {
            line = line.trim();
            System.out.println(line);
            if (line.startsWith("ready")) {
                this.ready.set(true);
            } else if (line.startsWith("Done")) {
                this.flag.set(1);
            } else if (line.startsWith("Error") || line.startsWith("Failed")) {
                this.flag.set(-1);
            }
        }
        return true;
    }

    private class ConsoleOutput
    extends Thread {
        private MultipleCMDConvertor mcc;
        private InputStream in;

        public ConsoleOutput(MultipleCMDConvertor mcc, InputStream in) {
            super("Console");
            this.mcc = mcc;
            this.in = in;
        }

        @Override
        public void run() {
            BufferedReader out = null;
            try {
                String line;
                out = new BufferedReader(new InputStreamReader(this.in, PluginUtil.arch() == PluginUtil.Arch.win ? "GBK" : "UTF-8"));
                while (this.mcc.process != null && !this.mcc.timeout && (line = out.readLine()) != null && this.mcc.processLine(line.trim())) {
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

