/*
 * Decompiled with CFR 0.152.
 */
package cpcns.convert.impl;

import cpcns.convert.impl.BaseConvertor;
import cpcns.convert.impl.IConvertorPlugin;
import cpcns.convert.impl.PluginClassLoader;
import cpcns.convert.impl.PluginUtil;
import cpcns.util.ConfigUtils;
import cpcns.util.JarUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BasePlugin
implements IConvertorPlugin {
    private static Log log = LogFactory.getLog(BasePlugin.class);
    private Properties config;
    private File dir;
    private Map<String, Integer> types;
    private PluginUtil.Space[] spaces;

    protected boolean doLoad(String[] names) throws MalformedURLException {
        if (names == null || names.length == 0) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Try to load resource " + Arrays.toString(names)));
        }
        ArrayList<URL> jars = new ArrayList<URL>();
        File base = JarUtils.findJarDir(this.getClass());
        for (String name : names) {
            URL url = this.findJar(base, name);
            if (url == null) continue;
            jars.add(url);
        }
        if (!jars.isEmpty()) {
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl instanceof PluginClassLoader) {
                ((PluginClassLoader)cl).addURLs(jars.toArray(new URL[jars.size()]));
            } else {
                log.warn((Object)"ClassLoader is not PluginClassLoader");
                return false;
            }
        }
        return true;
    }

    protected URL findJar(File base, String name) throws MalformedURLException {
        File jar;
        if (base.getName().endsWith("bin")) {
            base = base.getParentFile();
        }
        if (!(jar = new File(base, name)).exists()) {
            jar = new File(base, "lib/" + name);
        }
        if (jar.exists()) {
            String url = "file:///" + jar.getAbsolutePath().replace('\\', '/');
            return new URL(url);
        }
        return null;
    }

    protected Properties config() {
        if (this.config == null) {
            this.config = ConfigUtils.load(this.getClass(), (String)"config.properties");
            try {
                Class<?> threadClazz = Class.forName("com.suwell.ofd.config.util.NodeConfig");
                Method method = threadClazz.getMethod("mergeNodeConfig", String.class, Map.class, String[].class);
                method.invoke(null, this.name(), this.config, new String[]{"name"});
            }
            catch (Exception e) {
                log.debug((Object)"Unable to override configuration!");
            }
        }
        return this.config;
    }

    protected File dir() {
        if (this.dir == null) {
            this.dir = JarUtils.findJarDir(this.getClass());
            if (this.dir.getName().endsWith("bin")) {
                this.dir = this.dir.getParentFile();
            }
        }
        return this.dir;
    }

    @Override
    public String name() {
        return ConfigUtils.value((Properties)this.config(), (String)"name", (String)"UNKOWN");
    }

    @Override
    public int size() {
        return ConfigUtils.intValue((Properties)this.config(), (String)"size", (int)1);
    }

    public Map<String, Integer> canProcess() {
        if (this.types == null) {
            this.types = new HashMap<String, Integer>();
            String[] process = (String[])ConfigUtils.arrayValue((Properties)this.config(), (String)"process", String.class, (String)";");
            if (process != null) {
                for (String s : process) {
                    String[] array = s.split("=");
                    String k = array[0];
                    String v = array[1];
                    int cost = Integer.valueOf(v);
                    this.types.put(k, cost);
                }
            }
        }
        return this.types;
    }

    @Override
    public boolean load() {
        String[] names;
        this.spaces = PluginUtil.timeout(this.config().getProperty("timeout", null));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Timeout space is " + Arrays.toString(this.spaces)));
        }
        if ((names = (String[])ConfigUtils.arrayValue((Properties)this.config(), (String)"depends", String.class, (String)";")) != null) {
            try {
                return this.doLoad(names);
            }
            catch (MalformedURLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected void attach(BaseConvertor bc) {
        if (bc == null) {
            return;
        }
        bc.setSpaces(this.spaces);
    }
}

