/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.extend.xbrl.model;

import com.suwell.extend.xbrl.BankConst;
import com.suwell.extend.xbrl.model.BankXbrlContext;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;

public class BankXbrlCommon
implements Closeable,
BankConst {
    private static final String HEAD = "<xbrli:xbrl xmlns:link=\"http://www.xbrl.org/2003/linkbase\" xmlns:gen=\"http://xbrl.org/2008/generic\" xmlns:num=\"http://www.xbrl.org/dtr/type/numeric\" xmlns:nonnum=\"http://www.xbrl.org/dtr/type/non-numeric\" xmlns:xbrldt=\"http://xbrl.org/2005/xbrldt\" xmlns:label=\"http://xbrl.org/2008/label\" xmlns:bkrs-20211130_rol=\"http://xbrl.mof.gov.cn/taxonomy/2021-11-30/bkrs/rol\" xmlns:xl=\"http://www.xbrl.org/2003/XLink\" xmlns:bkrs=\"http://xbrl.mof.gov.cn/taxonomy/2021-11-30/bkrs\" xmlns:bkrs_entry_point=\"http://xbrl.mof.gov.cn/taxonomy/2021-11-30/bkrs/bkrs_entry_point\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xbrli=\"http://www.xbrl.org/2003/instance\" xmlns:iso4217=\"http://www.xbrl.org/2003/iso4217\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">";
    private static final String FOOT = "</xbrli:xbrl>";
    private static final String LINK_T = "<link:schemaRef xlink:type=\"%s\" xlink:href=\"%s\"/>";
    private static final String CONTEXT_T = "\n <xbrli:context id=\"%s\">\n%s\n </xbrli:context>";
    private static final String UNIT_T = "\n <xbrli:unit id=\"%s\">\n  <xbrli:measure>iso4217:%s</xbrli:measure>\n </xbrli:unit>";
    private Writer writer;
    private String id;
    private String currency;

    public BankXbrlCommon(Writer writer, String id) throws IOException {
        this.writer = writer;
        this.id = id;
        writer.write(HEAD);
    }

    public BankXbrlCommon(Writer writer, String id, List<String> head) throws IOException {
        this.writer = writer;
        this.id = id;
        StringBuilder sb = new StringBuilder("<xbrli:xbrl");
        for (String s : head) {
            sb.append(" ").append(s);
        }
        sb.append(">");
        writer.write(sb.toString());
    }

    public BankXbrlCommon addLink(String type, String herf) throws IOException {
        this.writer.write("\n ".concat(String.format(LINK_T, type, herf)));
        return this;
    }

    public BankXbrlCommon addContext(BankXbrlContext context) throws IOException {
        this.writer.write(String.format(CONTEXT_T, this.id, context.build()));
        return this;
    }

    public BankXbrlCommon addUnit(String currency) throws IOException {
        this.currency = currency;
        this.writer.write(String.format(UNIT_T, currency, currency));
        return this;
    }

    public BankXbrlCommon addCommonData(Map<String, String> data, Set<String> numberFilter, String suf) throws IOException {
        this.writer.write(this.assembleData(data, numberFilter, suf, BankXbrlCommon.moreBlank(1)));
        return this;
    }

    private String assembleData(Map<String, String> data, Set<String> numberFilter, String suf, String mk) {
        StringBuilder sb = new StringBuilder();
        if (data.get("IdentificationOfCreditOrDebit").equals("1")) {
            this.bkermap(data);
        }
        for (Map.Entry<String, String> d : data.entrySet()) {
            sb.append("\n").append(mk).append("<").append(suf).append(d.getKey()).append(" ").append(this.addAttribute("contextRef", this.id));
            if (numberFilter != null && numberFilter.size() > 0 && numberFilter.contains(d.getKey())) {
                String v = d.getValue();
                sb.append(" ").append(this.addAttribute("unitRef", this.currency)).append(" ").append(this.addAttribute("decimals", this.parserDecimals(v)));
            }
            if ("OtherAccountingInformation".equals(d.getKey())) {
                sb.append(">").append(d.getValue()).append("<").append("/").append(suf).append(d.getKey()).append(">");
                continue;
            }
            sb.append(">").append(this.escape(d.getValue())).append("<").append("/").append(suf).append(d.getKey()).append(">");
        }
        return sb.toString();
    }

    public Map<String, String> bkermap(Map<String, String> data) {
        String AccountNameOfPayer = data.get("AccountNameOfPayer");
        String AccountNumberOfPayer = data.get("AccountNumberOfPayer");
        String OpeningBankOfPayer = data.get("OpeningBankOfPayer");
        String AccountNameOfPayee = data.get("AccountNameOfPayee");
        String AccountNumberOfPayee = data.get("AccountNumberOfPayee");
        String OpeningBankOfPayee = data.get("OpeningBankOfPayee");
        data.put("AccountNameOfPayer", AccountNameOfPayee);
        data.put("AccountNumberOfPayer", AccountNumberOfPayee);
        data.put("OpeningBankOfPayer", OpeningBankOfPayee);
        data.put("AccountNameOfPayee", AccountNameOfPayer);
        data.put("AccountNumberOfPayee", AccountNumberOfPayer);
        data.put("OpeningBankOfPayee", OpeningBankOfPayer);
        return data;
    }

    public Map<String, String> bkrsmap(Map<String, String> data) {
        LinkedHashMap<String, String> linkddata = new LinkedHashMap<String, String>();
        if (null != data.get("DateOfBookkeeping")) {
            linkddata.put("DateOfBookkeeping", data.get("DateOfBookkeeping"));
        }
        if (null != data.get("TypesOfBusinessProducts")) {
            linkddata.put("TypesOfBusinessProducts", data.get("TypesOfBusinessProducts"));
        }
        if (null != data.get("TypeOfSourceDocument")) {
            linkddata.put("TypeOfSourceDocument", data.get("TypeOfSourceDocument"));
        }
        if (null != data.get("NumberOfSourceDocument")) {
            linkddata.put("NumberOfSourceDocument", data.get("NumberOfSourceDocument"));
        }
        if (null != data.get("NotesOfBankElectronicReceipt")) {
            linkddata.put("NotesOfBankElectronicReceipt", data.get("NotesOfBankElectronicReceipt"));
        }
        if (null != data.get("IdentificationOfCreditOrDebit")) {
            linkddata.put("IdentificationOfCreditOrDebit", data.get("IdentificationOfCreditOrDebit"));
        }
        if (null != data.get("TransactionAmount")) {
            linkddata.put("TransactionAmount", data.get("TransactionAmount"));
        }
        if (null != data.get("DebitOrCreditOfBalance")) {
            linkddata.put("DebitOrCreditOfBalance", data.get("DebitOrCreditOfBalance"));
        }
        if (null != data.get("AccountBalance")) {
            linkddata.put("AccountBalance", data.get("AccountBalance"));
        }
        if (null != data.get("TransactionCode")) {
            linkddata.put("TransactionCode", data.get("TransactionCode"));
        }
        if (null != data.get("AccountOfCounterparty")) {
            linkddata.put("AccountOfCounterparty", data.get("AccountOfCounterparty"));
        }
        if (null != data.get("NameOfCounterparty")) {
            linkddata.put("NameOfCounterparty", data.get("NameOfCounterparty"));
        }
        if (null != data.get("DepositoryBankOfCounterparty")) {
            linkddata.put("DepositoryBankOfCounterparty", data.get("DepositoryBankOfCounterparty"));
        }
        if (null != data.get("Bookkeeper")) {
            linkddata.put("Bookkeeper", data.get("Bookkeeper"));
        }
        if (null != data.get("TimeOfBookkeeping")) {
            linkddata.put("TimeOfBookkeeping", data.get("TimeOfBookkeeping"));
        }
        if (null != data.get("JournalAccountOfBookkeeping")) {
            linkddata.put("JournalAccountOfBookkeeping", data.get("JournalAccountOfBookkeeping"));
        }
        if (null != data.get("OtherAccountingInformation")) {
            linkddata.put("OtherAccountingInformation", StringEscapeUtils.unescapeXml((String)data.get("OtherAccountingInformation")));
        }
        if (null != data.get("NumberOfBankElectronicReceipt")) {
            linkddata.put("NumberOfBankElectronicReceipt", data.get("NumberOfBankElectronicReceipt"));
        }
        return linkddata;
    }

    public BankXbrlCommon addItemData(Map<String, String> data, Set<String> numberFilter, String suf, String nodeName) throws IOException {
        StringBuilder sb = new StringBuilder("\n").append(BankXbrlCommon.moreBlank(1));
        sb.append("<").append(suf).append(nodeName).append(">");
        sb.append(this.assembleData(this.bkrsmap(data), numberFilter, suf, BankXbrlCommon.moreBlank(2)));
        sb.append("\n").append(BankXbrlCommon.moreBlank(1)).append("<").append("/").append(suf).append(nodeName).append(">");
        this.writer.write(sb.toString());
        return this;
    }

    private String parserDecimals(String v) {
        String[] ts = v.trim().split("[.]");
        String decimals = ts.length == 1 ? "0" : ts[1].length() + "";
        return decimals;
    }

    private String addAttribute(String k, String v) {
        return String.format("%s=\"%s\"", k, v);
    }

    private String escape(String value) {
        if (value != null) {
            if (value.contains("&")) {
                value = value.replace("&", "&amp;");
            }
            if (value.contains("<")) {
                value = value.replace("<", "&lt;");
            }
            if (value.contains(">")) {
                value = value.replace(">", "&gt;");
            }
            if (value.contains("'")) {
                value = value.replace("'", "&apos;");
            }
            if (value.contains("\"")) {
                value = value.replace("\"", "&quot;");
            }
        }
        return value;
    }

    public static String moreBlank(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.write("\n".concat(FOOT));
            this.writer.flush();
            this.writer.close();
        }
    }
}

