/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.extend.bank.sdk;

import com.suwell.extend.xbrl.model.BankStatementAccount;
import com.suwell.local.convert.FileMain;
import com.suwell.local.convert.StandaloneHelper;
import com.suwell.local.convert.Utils;
import com.suwell.ofd.custom.wrapper.model.Pair;
import com.suwell.ofd.custom.wrapper.model.SealInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class BankReceiptCreater {
    public static void createCompoundOFD(File tplFile, File data, File out) throws Exception {
        BankReceiptCreater.createStatementAccount(tplFile, data, out);
    }

    public static void createStatementAccount(File tplFile, File data, File out) throws Exception {
        FileMain fileMain = new FileMain();
        fileMain.data((Object)tplFile, (Object)data, null, null, new Pair[0]);
        StandaloneHelper.instance().formbuilder(fileMain, out, new String[0]);
    }

    public static void createStatementAccountAndXbrl(File tplFile, File data, File out) throws Exception {
        BankReceiptCreater.createStatementAccountAndXbrl(tplFile, data, out, null, (SealInfo)null, null);
    }

    public static void createStatementAccountAndXbrl(File tplFile, File data, File out, String attachname) throws Exception {
        BankReceiptCreater.createStatementAccountAndXbrl(tplFile, data, out, attachname, (SealInfo)null, null);
    }

    public static void createStatementAccountAndXbrl(File tplFile, File data, File out, SealInfo seal, String sealprovider) throws Exception {
        BankReceiptCreater.createStatementAccountAndXbrl(tplFile, data, out, null, seal, sealprovider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createStatementAccountAndXbrl(File tplFile, File data, File out, String attachname, SealInfo seal, String sealprovider) throws Exception {
        FileMain fileMain = new FileMain();
        fileMain.data((Object)tplFile, (Object)data, null, null, new Pair[0]);
        BankStatementAccount bankStatementAccount = new BankStatementAccount();
        SAXReader reader = new SAXReader(Utils.factory.newSAXParser().getXMLReader());
        Document document = reader.read(data);
        File file = File.createTempFile("tmp_", ".xml");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            String id = bankStatementAccount.createXbrl(document.getRootElement(), writer);
            if (!StringUtils.isEmpty((CharSequence)attachname)) {
                fileMain.attach(attachname, "xml", (Object)file, false);
            } else {
                fileMain.attach("bkrs_issuer_" + id, "xml", (Object)file, false);
            }
            if (!StringUtils.isEmpty((CharSequence)sealprovider)) {
                fileMain.seal(sealprovider, null, seal);
            }
            StandaloneHelper.instance().formbuilder(fileMain, out, new String[0]);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
            FileUtils.deleteQuietly((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createStatementAccountAndXbrl(File tplFile, File data, File out, String dateOfBookkeeping, String identificationCodeOfIssuer, String currency) throws Exception {
        FileMain fileMain = new FileMain();
        fileMain.data((Object)tplFile, (Object)data, null, null, new Pair[0]);
        BankStatementAccount bankStatementAccount = new BankStatementAccount();
        File file = File.createTempFile("tmp_", ".xml");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            bankStatementAccount.createXbrl(data, writer, dateOfBookkeeping, identificationCodeOfIssuer, currency);
            fileMain.attach(identificationCodeOfIssuer, "xml", (Object)file, false);
            StandaloneHelper.instance().formbuilder(fileMain, out, new String[0]);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
            FileUtils.deleteQuietly((File)file);
        }
    }

    public static void createReceiptAndXbrl(File tplFile, File data, File out) throws Exception {
        BankReceiptCreater.createStatementAccountAndXbrl(tplFile, data, out, null, (SealInfo)null, null);
    }

    public static void createReceiptAndXbrl(File tplFile, File data, File out, String attachname) throws Exception {
        BankReceiptCreater.createStatementAccountAndXbrl(tplFile, data, out, attachname, (SealInfo)null, null);
    }

    public static void createReceiptAndXbrl(File tplFile, File data, File out, SealInfo seal, String sealprovider) throws Exception {
        BankReceiptCreater.createStatementAccountAndXbrl(tplFile, data, out, null, seal, sealprovider);
    }

    public static void createReceiptAndXbrl(File tplFile, File data, File out, String attachname, SealInfo seal, String sealprovider) throws Exception {
    }
}

