/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.agent.callback;

import com.suwell.ofd.custom.agent.ConvertCallback;
import com.suwell.ofd.custom.wrapper.io.IOTools;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCallback
implements ConvertCallback,
Closeable {
    private static Logger log = LoggerFactory.getLogger(SimpleCallback.class);
    private OutputStream out;

    public SimpleCallback(File out) throws IOException {
        this(IOTools.openOutputStream((File)out));
    }

    public SimpleCallback(OutputStream out) {
        this.out = out;
    }

    @Override
    public OutputStream openOutput() throws IOException {
        return this.out;
    }

    @Override
    public void onStart() {
        log.debug("Task start");
    }

    @Override
    public void onSuccess() {
        log.debug("Task success");
    }

    @Override
    public void onFailed(String code, String message) {
        log.debug("Task failed, code = {}, message = {}", (Object)code, (Object)message);
    }

    @Override
    public void onException(Exception ex) {
        log.error("Task exception", (Throwable)ex);
    }

    @Override
    public void onFinally() {
        IOTools.closeQuietly((Closeable)this);
    }

    @Override
    public void close() throws IOException {
        IOTools.closeQuietly((Closeable)this.out);
    }
}

