/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.agent;

import com.suwell.ofd.custom.agent.ConvertAgent;
import com.suwell.ofd.custom.agent.ConvertCallback;
import com.suwell.ofd.custom.agent.TransferCallback;
import com.suwell.ofd.custom.wrapper.Const;
import com.suwell.ofd.custom.wrapper.PackEntry;
import com.suwell.ofd.custom.wrapper.Packet;
import com.suwell.ofd.custom.wrapper.io.FilenameUtils;
import com.suwell.ofd.custom.wrapper.model.Common;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentHelper {
    private static Logger log = LoggerFactory.getLogger(AgentHelper.class);
    public static int maxWaitCount = 10;
    private static AtomicReference<Semaphore> ars = new AtomicReference();

    private static Semaphore get() {
        Semaphore semaphore = ars.get();
        if (semaphore == null && maxWaitCount > 0) {
            while (!ars.compareAndSet(null, new Semaphore(maxWaitCount))) {
            }
            semaphore = ars.get();
        }
        return semaphore;
    }

    public static void submit(ConvertAgent agent, boolean block, File source, File out) throws Exception {
        String name = source.getName();
        String fmt = FilenameUtils.getExtension((String)name);
        log.info("Submit {}, type is {}", (Object)name, (Object)fmt);
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        packet.file(new Common(name, fmt, 0, PackEntry.wrap((File)source)));
        AgentHelper.submit(agent, block, packet, out, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void submit(ConvertAgent agent, boolean block, Packet packet, File out, String name) throws Exception {
        Semaphore semaphore = AgentHelper.get();
        if (semaphore != null) {
            semaphore.acquire();
        }
        if (name == null) {
            name = UUID.randomUUID().toString();
        }
        long time = System.currentTimeMillis();
        log.info("Submit packet, name is {}", (Object)name);
        if (block) {
            try {
                agent.convert(packet, (OutputStream)new FileOutputStream(out));
            }
            finally {
                if (semaphore != null) {
                    semaphore.release();
                }
            }
            log.info("{} Finally cost {}", (Object)name, (Object)(System.currentTimeMillis() - time));
        } else {
            FCB fcb = new FCB(name, time, out);
            fcb.semaphore = semaphore;
            agent.convertNoWait(packet, (ConvertCallback)fcb);
        }
    }

    private static void walk(File dir, FileVisitor visitor, final Set<String> ass, int lv) {
        File[] fs = ass.isEmpty() ? dir.listFiles() : dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String ext = FilenameUtils.getExtension((String)name);
                return ass.contains(ext);
            }
        });
        if (fs != null && fs.length > 0) {
            Arrays.sort(fs, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    int o2d;
                    int o1d = o1.isDirectory() ? 2 : 1;
                    int v = o1d - (o2d = o2.isDirectory() ? 2 : 1);
                    if (v == 0) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return v;
                }
            });
            for (File file : fs) {
                if (file.isFile()) {
                    if (visitor.visit(lv, file)) continue;
                    break;
                }
                AgentHelper.walk(file, visitor, ass, lv + 1);
            }
        }
    }

    public static void walk(File dir, FileVisitor visitor, String ... acceptSuffix) {
        HashSet<String> ass = new HashSet<String>();
        if (acceptSuffix != null && acceptSuffix.length > 0) {
            for (String suffix : acceptSuffix) {
                if (suffix == null) continue;
                if (suffix.charAt(0) == '.') {
                    suffix = suffix.substring(1);
                }
                ass.add(suffix.toLowerCase());
            }
        }
        AgentHelper.walk(dir, visitor, ass, 1);
    }

    private static class FCB
    implements ConvertCallback,
    TransferCallback {
        private long pks;
        private long ups;
        private long dls;
        private long qs;
        private long cs = System.currentTimeMillis();
        private Semaphore semaphore;
        private final String name;
        private final long start;
        private final File out;

        FCB(String name, long time, File out) {
            this.name = name;
            this.start = time;
            this.out = out;
        }

        @Override
        public OutputStream openOutput() throws IOException {
            return new FileOutputStream(this.out);
        }

        @Override
        public void onStart() {
            this.cs = System.currentTimeMillis();
            log.info("{} Start..., in queue wait {}", (Object)this.name, (Object)(this.cs - this.qs));
        }

        @Override
        public void onSuccess() {
            log.info("{} Success cost {}", (Object)this.name, (Object)(System.currentTimeMillis() - this.cs));
        }

        @Override
        public void onFailed(String code, String message) {
            log.info("{} Failed cost {}", (Object)this.name, (Object)(System.currentTimeMillis() - this.cs));
        }

        @Override
        public void onException(Exception ex) {
            log.info("Exception", (Throwable)ex);
        }

        @Override
        public void onFinally() {
            log.info("{} Finally cost {}", (Object)this.name, (Object)(System.currentTimeMillis() - this.start));
            if (this.semaphore != null) {
                this.semaphore.release();
            }
        }

        @Override
        public void onPackStart() {
            this.pks = System.currentTimeMillis();
            log.info("{} Pack...", (Object)this.name);
        }

        @Override
        public void onPackEnd() {
            log.info("{} Pack cost {}", (Object)this.name, (Object)(System.currentTimeMillis() - this.pks));
        }

        @Override
        public void onUploadStart() {
            log.info("{} Upload...", (Object)this.name);
            this.ups = System.currentTimeMillis();
        }

        @Override
        public void onUploadEnd() {
            log.info("{} Upload cost {}", (Object)this.name, (Object)(System.currentTimeMillis() - this.ups));
            this.qs = System.currentTimeMillis();
        }

        @Override
        public void onTicket(String ticket) {
            log.info("{} Real ticket = {}", (Object)this.name, (Object)ticket);
        }

        @Override
        public void onDownloadStart() {
            log.info("{} Download...", (Object)this.name);
            this.dls = System.currentTimeMillis();
        }

        @Override
        public void onDownloadEnd() {
            log.info("{} Download cost {}", (Object)this.name, (Object)(System.currentTimeMillis() - this.dls));
        }
    }

    public static interface FileVisitor {
        public boolean visit(int var1, File var2);
    }
}

